/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.command;

import com.hm.h2.command.Command;
import com.hm.h2.command.CommandContainer;
import com.hm.h2.command.Prepared;
import com.hm.h2.engine.DbObject;
import com.hm.h2.engine.Session;
import com.hm.h2.expression.Parameter;
import com.hm.h2.expression.ParameterInterface;
import com.hm.h2.result.ResultInterface;
import com.hm.h2.result.ResultWithGeneratedKeys;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

class CommandList
extends Command {
    private CommandContainer command;
    private final ArrayList<Prepared> commands;
    private final ArrayList<Parameter> parameters;
    private String remaining;
    private Command remainingCommand;

    CommandList(Session session, String string, CommandContainer commandContainer, ArrayList<Prepared> arrayList, ArrayList<Parameter> arrayList2, String string2) {
        super(session, string);
        this.command = commandContainer;
        this.commands = arrayList;
        this.parameters = arrayList2;
        this.remaining = string2;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.parameters;
    }

    private void executeRemaining() {
        for (Prepared prepared : this.commands) {
            prepared.prepare();
            if (prepared.isQuery()) {
                prepared.query(0);
                continue;
            }
            prepared.update();
        }
        if (this.remaining != null) {
            this.remainingCommand = this.session.prepareLocal(this.remaining);
            this.remaining = null;
            if (this.remainingCommand.isQuery()) {
                this.remainingCommand.query(0);
            } else {
                this.remainingCommand.update(null);
            }
        }
    }

    @Override
    public ResultWithGeneratedKeys update(Object object) {
        ResultWithGeneratedKeys resultWithGeneratedKeys = this.command.executeUpdate(null);
        this.executeRemaining();
        return resultWithGeneratedKeys;
    }

    @Override
    public void prepareJoinBatch() {
        this.command.prepareJoinBatch();
    }

    @Override
    public ResultInterface query(int n) {
        ResultInterface resultInterface = this.command.query(n);
        this.executeRemaining();
        return resultInterface;
    }

    @Override
    public void stop() {
        this.command.stop();
        for (Prepared prepared : this.commands) {
            CommandContainer.clearCTE(this.session, prepared);
        }
        if (this.remainingCommand != null) {
            this.remainingCommand.stop();
        }
    }

    @Override
    public boolean isQuery() {
        return this.command.isQuery();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.command.queryMeta();
    }

    @Override
    public int getCommandType() {
        return this.command.getCommandType();
    }

    @Override
    public Set<DbObject> getDependencies() {
        HashSet<DbObject> hashSet = new HashSet<DbObject>();
        for (Prepared prepared : this.commands) {
            prepared.collectDependencies(hashSet);
        }
        return hashSet;
    }
}

