/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.command.ddl;

import com.hm.h2.command.ddl.DefineCommand;
import com.hm.h2.engine.Database;
import com.hm.h2.engine.Domain;
import com.hm.h2.engine.Session;
import com.hm.h2.message.DbException;
import com.hm.h2.table.Column;
import com.hm.h2.table.Table;
import com.hm.h2.value.DataType;

public class CreateDomain
extends DefineCommand {
    private String typeName;
    private Column column;
    private boolean ifNotExists;

    public CreateDomain(Session session) {
        super(session);
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (database.findDomain(this.typeName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90119, this.typeName);
        }
        DataType dataType = DataType.getTypeByName(this.typeName, this.session.getDatabase().getMode());
        if (dataType != null) {
            if (!dataType.hidden) {
                throw DbException.get(90119, this.typeName);
            }
            Table table = this.session.getDatabase().getFirstUserTable();
            if (table != null) {
                StringBuilder stringBuilder = new StringBuilder(this.typeName).append(" (");
                table.getSQL(stringBuilder, false).append(')');
                throw DbException.get(90119, stringBuilder.toString());
            }
        }
        int n = this.getObjectId();
        Domain domain = new Domain(database, n, this.typeName);
        domain.setColumn(this.column);
        database.addDatabaseObject(this.session, domain);
        return 0;
    }

    @Override
    public int getType() {
        return 33;
    }
}

