/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.command.ddl;

import com.hm.h2.command.ddl.SchemaCommand;
import com.hm.h2.engine.Database;
import com.hm.h2.engine.Session;
import com.hm.h2.message.DbException;
import com.hm.h2.schema.Schema;
import com.hm.h2.schema.TriggerObject;
import com.hm.h2.table.Table;

public class DropTrigger
extends SchemaCommand {
    private String triggerName;
    private boolean ifExists;

    public DropTrigger(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setTriggerName(String string) {
        this.triggerName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        TriggerObject triggerObject = this.getSchema().findTrigger(this.triggerName);
        if (triggerObject == null) {
            if (!this.ifExists) {
                throw DbException.get(90042, this.triggerName);
            }
        } else {
            Table table = triggerObject.getTable();
            this.session.getUser().checkRight(table, 15);
            database.removeSchemaObject(this.session, triggerObject);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 45;
    }
}

