/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.command.dml;

import com.hm.h2.command.Prepared;
import com.hm.h2.command.dml.AllColumnsForPlan;
import com.hm.h2.command.dml.DataChangeStatement;
import com.hm.h2.command.dml.Select;
import com.hm.h2.engine.DbObject;
import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.ExpressionVisitor;
import com.hm.h2.expression.Parameter;
import com.hm.h2.expression.ValueExpression;
import com.hm.h2.message.DbException;
import com.hm.h2.result.ResultInterface;
import com.hm.h2.result.ResultTarget;
import com.hm.h2.result.Row;
import com.hm.h2.result.RowList;
import com.hm.h2.table.Column;
import com.hm.h2.table.DataChangeDeltaTable;
import com.hm.h2.table.PlanItem;
import com.hm.h2.table.Table;
import com.hm.h2.table.TableFilter;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueNull;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Update
extends Prepared
implements DataChangeStatement {
    private Expression condition;
    private TableFilter targetTableFilter;
    private TableFilter sourceTableFilter;
    private Expression limitExpr;
    private boolean updateToCurrentValuesReturnsZero;
    private final LinkedHashMap<Column, Expression> setClauseMap = new LinkedHashMap();
    private HashSet<Long> updatedKeysCollector;
    private ResultTarget deltaChangeCollector;
    private DataChangeDeltaTable.ResultOption deltaChangeCollectionMode;

    public Update(Session session) {
        super(session);
    }

    @Override
    public Table getTable() {
        return this.targetTableFilter.getTable();
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setAssignment(Column column, Expression expression) {
        if (this.setClauseMap.put(column, expression) != null) {
            throw DbException.get(42121, column.getName());
        }
        if (expression instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            parameter.setColumn(column);
        }
    }

    public void setUpdatedKeysCollector(HashSet<Long> hashSet) {
        this.updatedKeysCollector = hashSet;
    }

    @Override
    public void setDeltaChangeCollector(ResultTarget resultTarget, DataChangeDeltaTable.ResultOption resultOption) {
        this.deltaChangeCollector = resultTarget;
        this.deltaChangeCollectionMode = resultOption;
    }

    @Override
    public int update() {
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        try (RowList rowList = new RowList(this.session);){
            Row row;
            Object object;
            Table table = this.targetTableFilter.getTable();
            this.session.getUser().checkRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, true, false);
            this.setCurrentRowNumber(0L);
            int n = 0;
            Column[] columnArray = table.getColumns();
            int n2 = columnArray.length;
            int n3 = -1;
            if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                n3 = ((Value)object).getInt();
            }
            while (this.targetTableFilter.next()) {
                Object object2;
                this.setCurrentRowNumber(n + 1);
                if (n3 >= 0 && n >= n3) break;
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                object = this.targetTableFilter.get();
                if (table.isMVStore()) {
                    row = table.lockRow(this.session, (Row)object);
                    if (row == null) continue;
                    if (!object.hasSharedData(row)) {
                        object = row;
                        this.targetTableFilter.set((Row)object);
                        if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                    }
                }
                row = table.getTemplateRow();
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    Column column = columnArray[i];
                    Expression expression = this.setClauseMap.get(column);
                    if (expression == null) {
                        if (column.getOnUpdateExpression() != null) {
                            bl = true;
                        }
                        object2 = object.getValue(i);
                    } else {
                        object2 = expression == ValueExpression.getDefault() ? table.getDefaultValue(this.session, column) : expression.getValue(this.session);
                    }
                    row.setValue(i, (Value)object2);
                }
                long l = object.getKey();
                row.setKey(l);
                table.validateConvertUpdateSequence(this.session, row);
                if (bl || this.updateToCurrentValuesReturnsZero) {
                    int n4;
                    bl = false;
                    for (n4 = 0; n4 < n2; ++n4) {
                        if (Objects.equals(object.getValue(n4), row.getValue(n4))) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        for (n4 = 0; n4 < n2; ++n4) {
                            object2 = columnArray[n4];
                            if (this.setClauseMap.get(object2) != null || ((Column)object2).getOnUpdateExpression() == null) continue;
                            row.setValue(n4, table.getOnUpdateValue(this.session, (Column)object2));
                        }
                    } else if (this.updateToCurrentValuesReturnsZero) {
                        --n;
                    }
                }
                if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.OLD) {
                    this.deltaChangeCollector.addRow(object.getValueList());
                } else if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
                    this.deltaChangeCollector.addRow((Value[])row.getValueList().clone());
                }
                if (!table.fireRow() || !table.fireBeforeRow(this.session, (Row)object, row)) {
                    rowList.add((Row)object);
                    rowList.add(row);
                    if (this.updatedKeysCollector != null) {
                        this.updatedKeysCollector.add(l);
                    }
                    if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
                        this.deltaChangeCollector.addRow(row.getValueList());
                    }
                }
                ++n;
            }
            table.updateRows(this, this.session, rowList);
            if (table.fireRow()) {
                rowList.reset();
                while (rowList.hasNext()) {
                    object = rowList.next();
                    row = rowList.next();
                    table.fireAfterRow(this.session, (Row)object, row, false);
                }
            }
            table.fire(this.session, 2, false);
            int n5 = n;
            return n5;
        }
    }

    @Override
    public String getPlanSQL(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        this.targetTableFilter.getPlanSQL(stringBuilder, false, bl).append("\nSET\n    ");
        boolean bl2 = false;
        for (Map.Entry<Column, Expression> entry : this.setClauseMap.entrySet()) {
            if (bl2) {
                stringBuilder.append(",\n    ");
            }
            bl2 = true;
            entry.getKey().getSQL(stringBuilder, bl).append(" = ");
            entry.getValue().getSQL(stringBuilder, bl);
        }
        if (this.condition != null) {
            stringBuilder.append("\nWHERE ");
            this.condition.getUnenclosedSQL(stringBuilder, bl);
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT ");
            this.limitExpr.getUnenclosedSQL(stringBuilder, bl);
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        for (Map.Entry<Column, Expression> object2 : this.setClauseMap.entrySet()) {
            Expression expression = object2.getValue();
            expression.mapColumns(this.targetTableFilter, 0, 0);
            if (this.sourceTableFilter != null) {
                expression.mapColumns(this.sourceTableFilter, 0, 0);
            }
            object2.setValue(expression.optimize(this.session));
        }
        TableFilter[] tableFilterArray = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem planItem = this.targetTableFilter.getBestPlanItem(this.session, tableFilterArray, 0, new AllColumnsForPlan(tableFilterArray));
        this.targetTableFilter.setPlanItem(planItem);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 68;
    }

    @Override
    public String getStatementName() {
        return "UPDATE";
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }

    public void setUpdateToCurrentValuesReturnsZero(boolean bl) {
        this.updateToCurrentValuesReturnsZero = bl;
    }

    @Override
    public void collectDependencies(HashSet<DbObject> hashSet) {
        Select select;
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        if (this.condition != null) {
            this.condition.isEverything(expressionVisitor);
        }
        if (this.sourceTableFilter != null && (select = this.sourceTableFilter.getSelect()) != null) {
            select.isEverything(expressionVisitor);
        }
    }
}

