/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.expression;

import com.hm.h2.command.Parser;
import com.hm.h2.command.dml.Select;
import com.hm.h2.command.dml.SelectGroups;
import com.hm.h2.command.dml.SelectListColumnResolver;
import com.hm.h2.engine.Database;
import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.ExpressionVisitor;
import com.hm.h2.expression.ValueExpression;
import com.hm.h2.expression.condition.Comparison;
import com.hm.h2.index.IndexCondition;
import com.hm.h2.message.DbException;
import com.hm.h2.schema.Constant;
import com.hm.h2.schema.Schema;
import com.hm.h2.table.Column;
import com.hm.h2.table.ColumnResolver;
import com.hm.h2.table.Table;
import com.hm.h2.table.TableFilter;
import com.hm.h2.value.ExtTypeInfo;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueBoolean;
import com.hm.h2.value.ValueNull;

public class ExpressionColumn
extends Expression {
    private final Database database;
    private final String schemaName;
    private final String tableAlias;
    private String columnName;
    private final boolean rowId;
    private ColumnResolver columnResolver;
    private int queryLevel;
    private Column column;

    public ExpressionColumn(Database database, Column column) {
        this.database = database;
        this.column = column;
        this.schemaName = null;
        this.tableAlias = null;
        this.columnName = null;
        this.rowId = column.isRowId();
    }

    public ExpressionColumn(Database database, String string, String string2, String string3, boolean bl) {
        this.database = database;
        this.schemaName = string;
        this.tableAlias = string2;
        this.columnName = string3;
        this.rowId = bl;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        if (this.schemaName != null) {
            Parser.quoteIdentifier(stringBuilder, this.schemaName, bl).append('.');
        }
        if (this.tableAlias != null) {
            Parser.quoteIdentifier(stringBuilder, this.tableAlias, bl).append('.');
        }
        if (this.column != null) {
            if (this.columnResolver != null && this.columnResolver.hasDerivedColumnList()) {
                Parser.quoteIdentifier(stringBuilder, this.columnResolver.getColumnName(this.column), bl);
            } else {
                this.column.getSQL(stringBuilder, bl);
            }
        } else if (this.rowId) {
            stringBuilder.append(this.columnName);
        } else {
            Parser.quoteIdentifier(stringBuilder, this.columnName, bl);
        }
        return stringBuilder;
    }

    public TableFilter getTableFilter() {
        return this.columnResolver == null ? null : this.columnResolver.getTableFilter();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        if (this.tableAlias != null && !this.database.equalsIdentifiers(this.tableAlias, columnResolver.getTableAlias())) {
            return;
        }
        if (this.schemaName != null && !this.database.equalsIdentifiers(this.schemaName, columnResolver.getSchemaName())) {
            return;
        }
        if (this.rowId) {
            Column column = columnResolver.getRowIdColumn();
            if (column != null) {
                this.mapColumn(columnResolver, column, n);
            }
            return;
        }
        Column column = columnResolver.findColumn(this.columnName);
        if (column != null) {
            this.mapColumn(columnResolver, column, n);
            return;
        }
        Column[] columnArray = columnResolver.getSystemColumns();
        for (int i = 0; columnArray != null && i < columnArray.length; ++i) {
            column = columnArray[i];
            if (!this.database.equalsIdentifiers(this.columnName, column.getName())) continue;
            this.mapColumn(columnResolver, column, n);
            return;
        }
    }

    private void mapColumn(ColumnResolver columnResolver, Column column, int n) {
        if (this.columnResolver == null) {
            this.queryLevel = n;
            this.column = column;
            this.columnResolver = columnResolver;
        } else if (this.queryLevel == n && this.columnResolver != columnResolver && !(columnResolver instanceof SelectListColumnResolver)) {
            throw DbException.get(90059, this.columnName);
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (this.columnResolver == null) {
            Constant constant;
            Schema schema = session.getDatabase().findSchema(this.tableAlias == null ? session.getCurrentSchemaName() : this.tableAlias);
            if (schema != null && (constant = schema.findConstant(this.columnName)) != null) {
                return constant.getValue();
            }
            throw this.getColumnException(42122);
        }
        return this.columnResolver.optimize(this, this.column);
    }

    public DbException getColumnException(int n) {
        String string = this.columnName;
        if (this.tableAlias != null) {
            string = this.tableAlias + '.' + string;
            if (this.schemaName != null) {
                string = this.schemaName + '.' + string;
            }
        }
        return DbException.get(n, string);
    }

    @Override
    public void updateAggregate(Session session, int n) {
        Select select = this.columnResolver.getSelect();
        if (select == null) {
            throw DbException.get(90016, this.getSQL(false));
        }
        SelectGroups selectGroups = select.getGroupDataIfCurrent(false);
        if (selectGroups == null) {
            return;
        }
        Value value = (Value)selectGroups.getCurrentGroupExprData(this);
        if (value == null) {
            selectGroups.setCurrentGroupExprData(this, this.columnResolver.getValue(this.column));
        } else if (!select.isGroupWindowStage2() && !this.database.areEqual(this.columnResolver.getValue(this.column), value)) {
            throw DbException.get(90016, this.getSQL(false));
        }
    }

    @Override
    public Value getValue(Session session) {
        Object object;
        Object object2;
        Select select = this.columnResolver.getSelect();
        if (select != null && (object2 = select.getGroupDataIfCurrent(false)) != null) {
            object = (Value)((SelectGroups)object2).getCurrentGroupExprData(this);
            if (object != null) {
                return object;
            }
            if (select.isGroupWindowStage2()) {
                throw DbException.get(90016, this.getSQL(false));
            }
        }
        if ((object2 = this.columnResolver.getValue(this.column)) == null) {
            if (select == null) {
                throw DbException.get(23502, this.getSQL(false));
            }
            throw DbException.get(90016, this.getSQL(false));
        }
        if (object2 != ValueNull.INSTANCE && (object = this.column.getType().getExtTypeInfo()) != null) {
            return ((ExtTypeInfo)object).cast((Value)object2);
        }
        return object2;
    }

    @Override
    public TypeInfo getType() {
        return this.column == null ? TypeInfo.TYPE_UNKNOWN : this.column.getType();
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    public Column getColumn() {
        return this.column;
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getOriginalTableAliasName() {
        return this.tableAlias;
    }

    @Override
    public String getColumnName() {
        if (this.column != null) {
            if (this.columnResolver != null) {
                return this.columnResolver.getColumnName(this.column);
            }
            return this.column.getName();
        }
        return this.columnName;
    }

    @Override
    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    @Override
    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    @Override
    public String getAlias() {
        if (this.column != null) {
            if (this.columnResolver != null) {
                return this.columnResolver.getColumnName(this.column);
            }
            return this.column.getName();
        }
        if (this.tableAlias != null) {
            return this.tableAlias + '.' + this.columnName;
        }
        return this.columnName;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.column.getSequence() != null;
    }

    @Override
    public int getNullable() {
        return this.column.isNullable() ? 1 : 0;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: {
                return false;
            }
            case 2: 
            case 5: 
            case 8: {
                return true;
            }
            case 0: {
                return this.queryLevel < expressionVisitor.getQueryLevel();
            }
            case 3: {
                if (expressionVisitor.getQueryLevel() < this.queryLevel) {
                    return true;
                }
                if (this.getTableFilter() == null) {
                    return false;
                }
                return this.getTableFilter().isEvaluatable();
            }
            case 4: {
                expressionVisitor.addDataModificationId(this.column.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.columnResolver != expressionVisitor.getResolver();
            }
            case 7: {
                if (this.column != null) {
                    expressionVisitor.addDependency(this.column.getTable());
                }
                return true;
            }
            case 9: {
                if (this.column == null) {
                    throw DbException.get(42122, this.getSQL(false));
                }
                expressionVisitor.addColumn1(this.column);
                return true;
            }
            case 10: {
                if (this.column == null) {
                    throw DbException.get(42122, this.getSQL(false));
                }
                expressionVisitor.addColumn2(this.column);
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 2;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        TableFilter tableFilter2 = this.getTableFilter();
        if (tableFilter == tableFilter2 && this.column.getType().getValueType() == 1) {
            IndexCondition indexCondition = IndexCondition.get(0, this, ValueExpression.get(ValueBoolean.TRUE));
            tableFilter.addIndexCondition(indexCondition);
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.getBoolean(false));
    }
}

