/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.expression.aggregate;

import com.hm.h2.engine.Database;
import com.hm.h2.expression.aggregate.AggregateDataCollecting;
import com.hm.h2.expression.aggregate.AggregateDataCount;
import com.hm.h2.expression.aggregate.AggregateDataDefault;
import com.hm.h2.expression.aggregate.AggregateDataDistinctWithCounts;
import com.hm.h2.expression.aggregate.AggregateDataEnvelope;
import com.hm.h2.expression.aggregate.AggregateDataSelectivity;
import com.hm.h2.expression.aggregate.AggregateType;
import com.hm.h2.message.DbException;
import com.hm.h2.value.Value;

abstract class AggregateData {
    AggregateData() {
    }

    static AggregateData create(AggregateType aggregateType, boolean bl, int n) {
        switch (aggregateType) {
            case COUNT_ALL: {
                return new AggregateDataCount(true);
            }
            case COUNT: {
                if (bl) break;
                return new AggregateDataCount(false);
            }
            case LISTAGG: 
            case ARRAY_AGG: 
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: 
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: 
            case MEDIAN: 
            case JSON_ARRAYAGG: 
            case JSON_OBJECTAGG: {
                break;
            }
            case MIN: 
            case MAX: 
            case BIT_OR: 
            case BIT_AND: 
            case ANY: 
            case EVERY: {
                return new AggregateDataDefault(aggregateType, n);
            }
            case SUM: 
            case AVG: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                if (bl) break;
                return new AggregateDataDefault(aggregateType, n);
            }
            case SELECTIVITY: {
                return new AggregateDataSelectivity(bl);
            }
            case HISTOGRAM: {
                return new AggregateDataDistinctWithCounts(false, 10000);
            }
            case MODE: {
                return new AggregateDataDistinctWithCounts(true, Integer.MAX_VALUE);
            }
            case ENVELOPE: {
                return new AggregateDataEnvelope();
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)aggregateType));
            }
        }
        return new AggregateDataCollecting(bl);
    }

    abstract void add(Database var1, Value var2);

    abstract Value getValue(Database var1, int var2);
}

