/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.expression.aggregate;

import com.hm.h2.engine.Database;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.ExpressionColumn;
import com.hm.h2.expression.aggregate.AggregateData;
import com.hm.h2.index.Index;
import com.hm.h2.mvstore.db.MVSpatialIndex;
import com.hm.h2.table.Column;
import com.hm.h2.table.TableFilter;
import com.hm.h2.util.geometry.GeometryUtils;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueGeometry;
import com.hm.h2.value.ValueNull;
import java.util.ArrayList;

class AggregateDataEnvelope
extends AggregateData {
    private double[] envelope;

    AggregateDataEnvelope() {
    }

    static Index getGeometryColumnIndex(Expression expression) {
        ArrayList<Index> arrayList;
        TableFilter tableFilter;
        ExpressionColumn expressionColumn;
        Column column;
        if (expression instanceof ExpressionColumn && (column = (expressionColumn = (ExpressionColumn)expression).getColumn()).getType().getValueType() == 22 && (tableFilter = expressionColumn.getTableFilter()) != null && (arrayList = tableFilter.getTable().getIndexes()) != null) {
            int n = arrayList.size();
            for (int i = 1; i < n; ++i) {
                Index index = arrayList.get(i);
                if (!(index instanceof MVSpatialIndex) || !index.isFirstColumn(column)) continue;
                return index;
            }
        }
        return null;
    }

    @Override
    void add(Database database, Value value) {
        if (value == ValueNull.INSTANCE) {
            return;
        }
        this.envelope = GeometryUtils.union(this.envelope, ((ValueGeometry)value.convertTo(22)).getEnvelopeNoCopy());
    }

    @Override
    Value getValue(Database database, int n) {
        return ValueGeometry.fromEnvelope(this.envelope);
    }
}

