/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.expression.condition;

import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.condition.SimplePredicate;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueBoolean;
import com.hm.h2.value.ValueNull;
import java.util.Arrays;

public class TypePredicate
extends SimplePredicate {
    private final TypeInfo[] typeList;
    private int[] valueTypes;

    public TypePredicate(Expression expression, boolean bl, TypeInfo[] typeInfoArray) {
        super(expression, bl);
        this.typeList = typeInfoArray;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(" IS");
        if (this.not) {
            stringBuilder.append(" NOT");
        }
        stringBuilder.append(" OF (");
        for (int i = 0; i < this.typeList.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.typeList[i].getSQL(stringBuilder);
        }
        return stringBuilder.append(')');
    }

    @Override
    public Expression optimize(Session session) {
        int n = this.typeList.length;
        this.valueTypes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.valueTypes[i] = this.typeList[i].getValueType();
        }
        Arrays.sort(this.valueTypes);
        return super.optimize(session);
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(Arrays.binarySearch(this.valueTypes, value.getValueType()) >= 0 ^ this.not);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new TypePredicate(this.left, !this.not, this.typeList);
    }
}

