/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.index;

import com.hm.h2.command.dml.Query;
import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.expression.ExpressionColumn;
import com.hm.h2.expression.ExpressionVisitor;
import com.hm.h2.message.DbException;
import com.hm.h2.result.ResultInterface;
import com.hm.h2.table.Column;
import com.hm.h2.table.TableType;
import com.hm.h2.value.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class IndexCondition {
    public static final int EQUALITY = 1;
    public static final int START = 2;
    public static final int END = 4;
    public static final int RANGE = 6;
    public static final int ALWAYS_FALSE = 8;
    public static final int SPATIAL_INTERSECTS = 16;
    private final Column column;
    private final int compareType;
    private final Expression expression;
    private List<Expression> expressionList;
    private Query expressionQuery;

    private IndexCondition(int n, ExpressionColumn expressionColumn, Expression expression) {
        this.compareType = n;
        this.column = expressionColumn == null ? null : expressionColumn.getColumn();
        this.expression = expression;
    }

    public static IndexCondition get(int n, ExpressionColumn expressionColumn, Expression expression) {
        return new IndexCondition(n, expressionColumn, expression);
    }

    public static IndexCondition getInList(ExpressionColumn expressionColumn, List<Expression> list) {
        IndexCondition indexCondition = new IndexCondition(7, expressionColumn, null);
        indexCondition.expressionList = list;
        return indexCondition;
    }

    public static IndexCondition getInQuery(ExpressionColumn expressionColumn, Query query) {
        assert (query.isRandomAccessResult());
        IndexCondition indexCondition = new IndexCondition(8, expressionColumn, null);
        indexCondition.expressionQuery = query;
        return indexCondition;
    }

    public Value getCurrentValue(Session session) {
        return this.expression.getValue(session);
    }

    public Value[] getCurrentValueList(Session session) {
        TreeSet<Value> treeSet = new TreeSet<Value>(session.getDatabase().getCompareMode());
        for (Expression expression : this.expressionList) {
            Value value = expression.getValue(session);
            value = this.column.convert(value, true);
            treeSet.add(value);
        }
        Value[] valueArray = treeSet.toArray(new Value[treeSet.size()]);
        Arrays.sort(valueArray, session.getDatabase().getCompareMode());
        return valueArray;
    }

    public ResultInterface getCurrentResult() {
        return this.expressionQuery.query(0);
    }

    public String getSQL(boolean bl) {
        if (this.compareType == 6) {
            return "FALSE";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.column.getSQL(stringBuilder, bl);
        switch (this.compareType) {
            case 0: {
                stringBuilder.append(" = ");
                break;
            }
            case 16: {
                stringBuilder.append(this.expression.isNullConstant() || this.column.getType().getValueType() == 1 && this.expression.isConstant() ? " IS " : " IS NOT DISTINCT FROM ");
                break;
            }
            case 1: {
                stringBuilder.append(" >= ");
                break;
            }
            case 2: {
                stringBuilder.append(" > ");
                break;
            }
            case 3: {
                stringBuilder.append(" <= ");
                break;
            }
            case 4: {
                stringBuilder.append(" < ");
                break;
            }
            case 7: {
                stringBuilder.append(" IN(");
                Expression.writeExpressions(stringBuilder, this.expressionList, bl);
                stringBuilder.append(')');
                break;
            }
            case 8: {
                stringBuilder.append(" IN(");
                stringBuilder.append(this.expressionQuery.getPlanSQL(bl));
                stringBuilder.append(')');
                break;
            }
            case 9: {
                stringBuilder.append(" && ");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.compareType);
            }
        }
        if (this.expression != null) {
            this.expression.getSQL(stringBuilder, bl);
        }
        return stringBuilder.toString();
    }

    public int getMask(ArrayList<IndexCondition> arrayList) {
        switch (this.compareType) {
            case 6: {
                return 8;
            }
            case 0: 
            case 16: {
                return 1;
            }
            case 7: 
            case 8: {
                if (arrayList.size() > 1 && TableType.TABLE != this.column.getTable().getTableType()) {
                    return 0;
                }
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: {
                return 4;
            }
            case 9: {
                return 16;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    public boolean isAlwaysFalse() {
        return this.compareType == 6;
    }

    public boolean isStart() {
        switch (this.compareType) {
            case 0: 
            case 1: 
            case 2: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnd() {
        switch (this.compareType) {
            case 0: 
            case 3: 
            case 4: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isSpatialIntersects() {
        switch (this.compareType) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    public int getCompareType() {
        return this.compareType;
    }

    public Column getColumn() {
        return this.column;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<Expression> getExpressionList() {
        return this.expressionList;
    }

    public Query getExpressionQuery() {
        return this.expressionQuery;
    }

    public boolean isEvaluatable() {
        if (this.expression != null) {
            return this.expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
        }
        if (this.expressionList != null) {
            for (Expression expression : this.expressionList) {
                if (expression.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
                return false;
            }
            return true;
        }
        return this.expressionQuery.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("column=").append(this.column).append(", compareType=");
        return IndexCondition.compareTypeToString(stringBuilder, this.compareType).append(", expression=").append(this.expression).append(", expressionList=").append(this.expressionList).append(", expressionQuery=").append(this.expressionQuery).toString();
    }

    private static StringBuilder compareTypeToString(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuilder.append("EQUALITY");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("START");
        }
        if ((n & 4) == 4) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("END");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuilder.append(", ");
            }
            bl = true;
            stringBuilder.append("ALWAYS_FALSE");
        }
        if ((n & 0x10) == 16) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("SPATIAL_INTERSECTS");
        }
        return stringBuilder;
    }
}

