/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.jdbc;

import com.hm.h2.expression.ParameterInterface;
import com.hm.h2.jdbc.JdbcCallableStatementBackwardsCompat;
import com.hm.h2.jdbc.JdbcConnection;
import com.hm.h2.jdbc.JdbcPreparedStatement;
import com.hm.h2.jdbc.JdbcResultSet;
import com.hm.h2.message.DbException;
import com.hm.h2.value.ValueNull;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class JdbcCallableStatement
extends JdbcPreparedStatement
implements CallableStatement,
JdbcCallableStatementBackwardsCompat {
    private BitSet outParameters;
    private int maxOutParameters;
    private HashMap<String, Integer> namedParameters;

    JdbcCallableStatement(JdbcConnection jdbcConnection, String string, int n, int n2, int n3) {
        super(jdbcConnection, string, n, n2, n3, false, null);
        this.setTrace(this.session.getTrace(), 0, n);
    }

    @Override
    public int executeUpdate() {
        try {
            this.checkClosed();
            if (this.command.isQuery()) {
                super.executeQuery();
                return 0;
            }
            return super.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate() {
        try {
            this.checkClosed();
            if (this.command.isQuery()) {
                super.executeQuery();
                return 0L;
            }
            return super.executeLargeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void registerOutParameter(int n, int n2) {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) {
        this.registerOutParameter(this.getIndexForName(string), n, string2);
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) {
        this.registerOutParameter(this.getIndexForName(string), n, n2);
    }

    @Override
    public void registerOutParameter(String string, int n) {
        this.registerOutParameter(this.getIndexForName(string), n);
    }

    @Override
    public boolean wasNull() {
        return this.getOpenResultSet().wasNull();
    }

    @Override
    public URL getURL(int n) {
        throw this.unsupported("url");
    }

    @Override
    public String getString(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getString(n);
    }

    @Override
    public boolean getBoolean(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBoolean(n);
    }

    @Override
    public byte getByte(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getByte(n);
    }

    @Override
    public short getShort(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getShort(n);
    }

    @Override
    public int getInt(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getInt(n);
    }

    @Override
    public long getLong(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getLong(n);
    }

    @Override
    public float getFloat(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getFloat(n);
    }

    @Override
    public double getDouble(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getDouble(n);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBigDecimal(n, n2);
    }

    @Override
    public byte[] getBytes(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBytes(n);
    }

    @Override
    public Date getDate(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getDate(n);
    }

    @Override
    public Time getTime(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getTime(n);
    }

    @Override
    public Timestamp getTimestamp(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getTimestamp(n);
    }

    @Override
    public Object getObject(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getObject(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBigDecimal(n);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) {
        throw this.unsupported("map");
    }

    @Override
    public Ref getRef(int n) {
        throw this.unsupported("ref");
    }

    @Override
    public Blob getBlob(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getBlob(n);
    }

    @Override
    public Clob getClob(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getClob(n);
    }

    @Override
    public Array getArray(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getArray(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getDate(n, calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getTime(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getTimestamp(n, calendar);
    }

    @Override
    public URL getURL(String string) {
        throw this.unsupported("url");
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) {
        return this.getTimestamp(this.getIndexForName(string), calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) {
        return this.getTime(this.getIndexForName(string), calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) {
        return this.getDate(this.getIndexForName(string), calendar);
    }

    @Override
    public Array getArray(String string) {
        return this.getArray(this.getIndexForName(string));
    }

    @Override
    public Clob getClob(String string) {
        return this.getClob(this.getIndexForName(string));
    }

    @Override
    public Blob getBlob(String string) {
        return this.getBlob(this.getIndexForName(string));
    }

    @Override
    public Ref getRef(String string) {
        throw this.unsupported("ref");
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) {
        throw this.unsupported("map");
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.getIndexForName(string));
    }

    @Override
    public Object getObject(String string) {
        return this.getObject(this.getIndexForName(string));
    }

    @Override
    public Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.getIndexForName(string));
    }

    @Override
    public Time getTime(String string) {
        return this.getTime(this.getIndexForName(string));
    }

    @Override
    public Date getDate(String string) {
        return this.getDate(this.getIndexForName(string));
    }

    @Override
    public byte[] getBytes(String string) {
        return this.getBytes(this.getIndexForName(string));
    }

    @Override
    public double getDouble(String string) {
        return this.getDouble(this.getIndexForName(string));
    }

    @Override
    public float getFloat(String string) {
        return this.getFloat(this.getIndexForName(string));
    }

    @Override
    public long getLong(String string) {
        return this.getLong(this.getIndexForName(string));
    }

    @Override
    public int getInt(String string) {
        return this.getInt(this.getIndexForName(string));
    }

    @Override
    public short getShort(String string) {
        return this.getShort(this.getIndexForName(string));
    }

    @Override
    public byte getByte(String string) {
        return this.getByte(this.getIndexForName(string));
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(this.getIndexForName(string));
    }

    @Override
    public String getString(String string) {
        return this.getString(this.getIndexForName(string));
    }

    @Override
    public RowId getRowId(int n) {
        throw this.unsupported("rowId");
    }

    @Override
    public RowId getRowId(String string) {
        throw this.unsupported("rowId");
    }

    @Override
    public NClob getNClob(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getNClob(n);
    }

    @Override
    public NClob getNClob(String string) {
        return this.getNClob(this.getIndexForName(string));
    }

    @Override
    public SQLXML getSQLXML(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getSQLXML(n);
    }

    @Override
    public SQLXML getSQLXML(String string) {
        return this.getSQLXML(this.getIndexForName(string));
    }

    @Override
    public String getNString(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getNString(n);
    }

    @Override
    public String getNString(String string) {
        return this.getNString(this.getIndexForName(string));
    }

    @Override
    public Reader getNCharacterStream(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getNCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) {
        return this.getNCharacterStream(this.getIndexForName(string));
    }

    @Override
    public Reader getCharacterStream(int n) {
        this.checkRegistered(n);
        return this.getOpenResultSet().getCharacterStream(n);
    }

    @Override
    public Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.getIndexForName(string));
    }

    @Override
    public void setNull(String string, int n, String string2) {
        this.setNull(this.getIndexForName(string), n, string2);
    }

    @Override
    public void setNull(String string, int n) {
        this.setNull(this.getIndexForName(string), n);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) {
        this.setTimestamp(this.getIndexForName(string), timestamp, calendar);
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) {
        this.setTime(this.getIndexForName(string), time, calendar);
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) {
        this.setDate(this.getIndexForName(string), date, calendar);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) {
        this.setCharacterStream(this.getIndexForName(string), reader, n);
    }

    @Override
    public void setObject(String string, Object object) {
        this.setObject(this.getIndexForName(string), object);
    }

    @Override
    public void setObject(String string, Object object, int n) {
        this.setObject(this.getIndexForName(string), object, n);
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) {
        this.setObject(this.getIndexForName(string), object, n, n2);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) {
        this.setBinaryStream(this.getIndexForName(string), inputStream, n);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) {
        this.setAsciiStream(this.getIndexForName(string), inputStream, l);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) {
        this.setTimestamp(this.getIndexForName(string), timestamp);
    }

    @Override
    public void setTime(String string, Time time) {
        this.setTime(this.getIndexForName(string), time);
    }

    @Override
    public void setDate(String string, Date date) {
        this.setDate(this.getIndexForName(string), date);
    }

    @Override
    public void setBytes(String string, byte[] byArray) {
        this.setBytes(this.getIndexForName(string), byArray);
    }

    @Override
    public void setString(String string, String string2) {
        this.setString(this.getIndexForName(string), string2);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) {
        this.setBigDecimal(this.getIndexForName(string), bigDecimal);
    }

    @Override
    public void setDouble(String string, double d) {
        this.setDouble(this.getIndexForName(string), d);
    }

    @Override
    public void setFloat(String string, float f) {
        this.setFloat(this.getIndexForName(string), f);
    }

    @Override
    public void setLong(String string, long l) {
        this.setLong(this.getIndexForName(string), l);
    }

    @Override
    public void setInt(String string, int n) {
        this.setInt(this.getIndexForName(string), n);
    }

    @Override
    public void setShort(String string, short s) {
        this.setShort(this.getIndexForName(string), s);
    }

    @Override
    public void setByte(String string, byte by) {
        this.setByte(this.getIndexForName(string), by);
    }

    @Override
    public void setBoolean(String string, boolean bl) {
        this.setBoolean(this.getIndexForName(string), bl);
    }

    @Override
    public void setURL(String string, URL uRL) {
        throw this.unsupported("url");
    }

    @Override
    public void setRowId(String string, RowId rowId) {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(String string, String string2) {
        this.setNString(this.getIndexForName(string), string2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) {
        this.setNCharacterStream(this.getIndexForName(string), reader, l);
    }

    @Override
    public void setNClob(String string, NClob nClob) {
        this.setNClob(this.getIndexForName(string), nClob);
    }

    @Override
    public void setClob(String string, Reader reader, long l) {
        this.setClob(this.getIndexForName(string), reader, l);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) {
        this.setBlob(this.getIndexForName(string), inputStream, l);
    }

    @Override
    public void setNClob(String string, Reader reader, long l) {
        this.setNClob(this.getIndexForName(string), reader, l);
    }

    @Override
    public void setBlob(String string, Blob blob) {
        this.setBlob(this.getIndexForName(string), blob);
    }

    @Override
    public void setClob(String string, Clob clob) {
        this.setClob(this.getIndexForName(string), clob);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) {
        this.setAsciiStream(this.getIndexForName(string), inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) {
        this.setAsciiStream(this.getIndexForName(string), inputStream, n);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) {
        this.setBinaryStream(this.getIndexForName(string), inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) {
        this.setBinaryStream(this.getIndexForName(string), inputStream, l);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) {
        this.setBlob(this.getIndexForName(string), inputStream);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) {
        this.setCharacterStream(this.getIndexForName(string), reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) {
        this.setCharacterStream(this.getIndexForName(string), reader, l);
    }

    @Override
    public void setClob(String string, Reader reader) {
        this.setClob(this.getIndexForName(string), reader);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) {
        this.setNCharacterStream(this.getIndexForName(string), reader);
    }

    @Override
    public void setNClob(String string, Reader reader) {
        this.setNClob(this.getIndexForName(string), reader);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) {
        this.setSQLXML(this.getIndexForName(string), sQLXML);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) {
        return this.getOpenResultSet().getObject(n, clazz);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) {
        return this.getObject(this.getIndexForName(string), clazz);
    }

    private ResultSetMetaData getCheckedMetaData() {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        if (resultSetMetaData == null) {
            throw DbException.getUnsupportedException("Supported only for calling stored procedures");
        }
        return resultSetMetaData;
    }

    private void checkIndexBounds(int n) {
        this.checkClosed();
        if (n < 1 || n > this.maxOutParameters) {
            throw DbException.getInvalidValueException("parameterIndex", n);
        }
    }

    private void registerOutParameter(int n) {
        try {
            this.checkClosed();
            if (this.outParameters == null) {
                this.maxOutParameters = Math.min(this.getParameterMetaData().getParameterCount(), this.getCheckedMetaData().getColumnCount());
                this.outParameters = new BitSet();
            }
            this.checkIndexBounds(n);
            ParameterInterface parameterInterface = this.command.getParameters().get(--n);
            if (!parameterInterface.isValueSet()) {
                parameterInterface.setValue(ValueNull.INSTANCE, false);
            }
            this.outParameters.set(n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void checkRegistered(int n) {
        try {
            this.checkIndexBounds(n);
            if (!this.outParameters.get(n - 1)) {
                throw DbException.getInvalidValueException("parameterIndex", n);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private int getIndexForName(String string) {
        try {
            Object object;
            this.checkClosed();
            if (this.namedParameters == null) {
                object = this.getCheckedMetaData();
                int n = object.getColumnCount();
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (int i = 1; i <= n; ++i) {
                    hashMap.put(object.getColumnLabel(i), i);
                }
                this.namedParameters = hashMap;
            }
            if ((object = this.namedParameters.get(string)) == null) {
                throw DbException.getInvalidValueException("parameterName", string);
            }
            return (Integer)object;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private JdbcResultSet getOpenResultSet() {
        try {
            this.checkClosed();
            if (this.resultSet == null) {
                throw DbException.get(2000);
            }
            if (this.resultSet.isBeforeFirst()) {
                this.resultSet.next();
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }
}

