/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.jdbc;

import com.hm.h2.command.CommandInterface;
import com.hm.h2.expression.ParameterInterface;
import com.hm.h2.jdbc.JdbcPreparedStatement;
import com.hm.h2.message.DbException;
import com.hm.h2.message.Trace;
import com.hm.h2.message.TraceObject;
import com.hm.h2.util.MathUtils;
import com.hm.h2.value.DataType;
import com.hm.h2.value.TypeInfo;
import java.sql.ParameterMetaData;
import java.util.ArrayList;

public class JdbcParameterMetaData
extends TraceObject
implements ParameterMetaData {
    private final JdbcPreparedStatement prep;
    private final int paramCount;
    private final ArrayList<? extends ParameterInterface> parameters;

    JdbcParameterMetaData(Trace trace, JdbcPreparedStatement jdbcPreparedStatement, CommandInterface commandInterface, int n) {
        this.setTrace(trace, 11, n);
        this.prep = jdbcPreparedStatement;
        this.parameters = commandInterface.getParameters();
        this.paramCount = this.parameters.size();
    }

    @Override
    public int getParameterCount() {
        try {
            this.debugCodeCall("getParameterCount");
            this.checkClosed();
            return this.paramCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getParameterMode(int n) {
        try {
            this.debugCodeCall("getParameterMode", n);
            this.getParameter(n);
            return 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getParameterType(int n) {
        try {
            this.debugCodeCall("getParameterType", n);
            int n2 = this.getParameter(n).getType().getValueType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getDataType((int)n2).sqlType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getPrecision(int n) {
        try {
            this.debugCodeCall("getPrecision", n);
            TypeInfo typeInfo = this.getParameter(n).getType();
            return typeInfo.getValueType() == -1 ? 0 : MathUtils.convertLongToInt(typeInfo.getPrecision());
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getScale(int n) {
        try {
            this.debugCodeCall("getScale", n);
            TypeInfo typeInfo = this.getParameter(n).getType();
            return typeInfo.getValueType() == -1 ? 0 : typeInfo.getScale();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int isNullable(int n) {
        try {
            this.debugCodeCall("isNullable", n);
            return this.getParameter(n).getNullable();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isSigned(int n) {
        try {
            this.debugCodeCall("isSigned", n);
            this.getParameter(n);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getParameterClassName(int n) {
        try {
            this.debugCodeCall("getParameterClassName", n);
            int n2 = this.getParameter(n).getType().getValueType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getTypeClassName(n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getParameterTypeName(int n) {
        try {
            this.debugCodeCall("getParameterTypeName", n);
            int n2 = this.getParameter(n).getType().getValueType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getDataType((int)n2).name;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private ParameterInterface getParameter(int n) {
        this.checkClosed();
        if (n < 1 || n > this.paramCount) {
            throw DbException.getInvalidValueException("param", n);
        }
        return this.parameters.get(n - 1);
    }

    private void checkClosed() {
        this.prep.checkClosed();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        try {
            if (this.isWrapperFor(clazz)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", clazz);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return this.getTraceObjectName() + ": parameterCount=" + this.paramCount;
    }
}

