/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.table;

import com.hm.h2.command.dml.TableValueConstructor;
import com.hm.h2.engine.Session;
import com.hm.h2.expression.Expression;
import com.hm.h2.result.ResultInterface;
import com.hm.h2.result.SimpleResult;
import com.hm.h2.schema.Schema;
import com.hm.h2.table.Column;
import com.hm.h2.table.VirtualConstructedTable;
import java.util.ArrayList;

public class TableValueConstructorTable
extends VirtualConstructedTable {
    private final ArrayList<ArrayList<Expression>> rows;

    public TableValueConstructorTable(Schema schema, Session session, Column[] columnArray, ArrayList<ArrayList<Expression>> arrayList) {
        super(schema, 0, "VALUES");
        this.setColumns(columnArray);
        this.rows = arrayList;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rows.size();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rows.size();
    }

    @Override
    public ResultInterface getResult(Session session) {
        SimpleResult simpleResult = new SimpleResult();
        for (Column column : this.columns) {
            String string = column.getName();
            simpleResult.addColumn(string, string, column.getType());
        }
        TableValueConstructor.getVisibleResult(session, simpleResult, this.columns, this.rows);
        return simpleResult;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        TableValueConstructor.getValuesSQL(stringBuilder, bl, this.rows);
        return stringBuilder.append(')');
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

