/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.value;

import com.hm.h2.api.IntervalQualifier;
import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.engine.SessionInterface;
import com.hm.h2.message.DbException;
import com.hm.h2.result.ResultInterface;
import com.hm.h2.result.SimpleResult;
import com.hm.h2.security.SHA256;
import com.hm.h2.store.Data;
import com.hm.h2.store.DataReader;
import com.hm.h2.util.Bits;
import com.hm.h2.util.CurrentTimestamp;
import com.hm.h2.util.DateTimeUtils;
import com.hm.h2.util.IOUtils;
import com.hm.h2.util.JdbcUtils;
import com.hm.h2.util.MathUtils;
import com.hm.h2.util.NetUtils;
import com.hm.h2.util.StringUtils;
import com.hm.h2.util.Utils;
import com.hm.h2.value.DataType;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueArray;
import com.hm.h2.value.ValueBoolean;
import com.hm.h2.value.ValueByte;
import com.hm.h2.value.ValueBytes;
import com.hm.h2.value.ValueDate;
import com.hm.h2.value.ValueDecimal;
import com.hm.h2.value.ValueDouble;
import com.hm.h2.value.ValueEnumBase;
import com.hm.h2.value.ValueFloat;
import com.hm.h2.value.ValueGeometry;
import com.hm.h2.value.ValueInt;
import com.hm.h2.value.ValueInterval;
import com.hm.h2.value.ValueJavaObject;
import com.hm.h2.value.ValueJson;
import com.hm.h2.value.ValueLobDb;
import com.hm.h2.value.ValueLong;
import com.hm.h2.value.ValueNull;
import com.hm.h2.value.ValueResultSet;
import com.hm.h2.value.ValueRow;
import com.hm.h2.value.ValueShort;
import com.hm.h2.value.ValueString;
import com.hm.h2.value.ValueStringFixed;
import com.hm.h2.value.ValueStringIgnoreCase;
import com.hm.h2.value.ValueTime;
import com.hm.h2.value.ValueTimeTimeZone;
import com.hm.h2.value.ValueTimestamp;
import com.hm.h2.value.ValueTimestampTimeZone;
import com.hm.h2.value.ValueUuid;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;

public class Transfer {
    private static final int BUFFER_SIZE = 65536;
    private static final int LOB_MAGIC = 4660;
    private static final int LOB_MAC_SALT_LENGTH = 16;
    private static final int NULL = 0;
    private static final int BOOLEAN = 1;
    private static final int BYTE = 2;
    private static final int SHORT = 3;
    private static final int INT = 4;
    private static final int LONG = 5;
    private static final int DECIMAL = 6;
    private static final int DOUBLE = 7;
    private static final int FLOAT = 8;
    private static final int TIME = 9;
    private static final int DATE = 10;
    private static final int TIMESTAMP = 11;
    private static final int BYTES = 12;
    private static final int STRING = 13;
    private static final int STRING_IGNORECASE = 14;
    private static final int BLOB = 15;
    private static final int CLOB = 16;
    private static final int ARRAY = 17;
    private static final int RESULT_SET = 18;
    private static final int JAVA_OBJECT = 19;
    private static final int UUID = 20;
    private static final int STRING_FIXED = 21;
    private static final int GEOMETRY = 22;
    private static final int TIMESTAMP_TZ = 24;
    private static final int ENUM = 25;
    private static final int INTERVAL = 26;
    private static final int ROW = 27;
    private static final int JSON = 28;
    private static final int TIME_TZ = 29;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private SessionInterface session;
    private boolean ssl;
    private int version;
    private byte[] lobMacSalt;

    public Transfer(SessionInterface sessionInterface, Socket socket) {
        this.session = sessionInterface;
        this.socket = socket;
    }

    public synchronized void init() {
        if (this.socket != null) {
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 65536));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 65536));
        }
    }

    public void flush() {
        this.out.flush();
    }

    public Transfer writeBoolean(boolean bl) {
        this.out.writeByte((byte)(bl ? 1 : 0));
        return this;
    }

    public boolean readBoolean() {
        return this.in.readByte() != 0;
    }

    private Transfer writeByte(byte by) {
        this.out.writeByte(by);
        return this;
    }

    private byte readByte() {
        return this.in.readByte();
    }

    public Transfer writeInt(int n) {
        this.out.writeInt(n);
        return this;
    }

    public int readInt() {
        return this.in.readInt();
    }

    public Transfer writeLong(long l) {
        this.out.writeLong(l);
        return this;
    }

    public long readLong() {
        return this.in.readLong();
    }

    private Transfer writeDouble(double d) {
        this.out.writeDouble(d);
        return this;
    }

    private Transfer writeFloat(float f) {
        this.out.writeFloat(f);
        return this;
    }

    private double readDouble() {
        return this.in.readDouble();
    }

    private float readFloat() {
        return this.in.readFloat();
    }

    public Transfer writeString(String string) {
        if (string == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(string.length());
            this.out.writeChars(string);
        }
        return this;
    }

    public String readString() {
        int n = this.in.readInt();
        if (n == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.in.readChar());
        }
        String string = stringBuilder.toString();
        string = StringUtils.cache(string);
        return string;
    }

    public Transfer writeBytes(byte[] byArray) {
        if (byArray == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(byArray.length);
            this.out.write(byArray);
        }
        return this;
    }

    public Transfer writeBytes(byte[] byArray, int n, int n2) {
        this.out.write(byArray, n, n2);
        return this;
    }

    public byte[] readBytes() {
        int n = this.readInt();
        if (n == -1) {
            return null;
        }
        byte[] byArray = Utils.newBytes(n);
        this.in.readFully(byArray);
        return byArray;
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        this.in.readFully(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.socket != null) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                DbException.traceThrowable(iOException);
            }
            finally {
                this.socket = null;
            }
        }
    }

    public Transfer writeTypeInfo(TypeInfo typeInfo) {
        return this.writeInt(typeInfo.getValueType()).writeLong(typeInfo.getPrecision()).writeInt(typeInfo.getScale());
    }

    public TypeInfo readTypeInfo() {
        return TypeInfo.getTypeInfo(this.readInt(), this.readLong(), this.readInt(), null);
    }

    public void writeValue(Value value) {
        int n = value.getValueType();
        switch (n) {
            case 0: {
                this.writeInt(0);
                break;
            }
            case 12: {
                this.writeInt(12);
                this.writeBytes(value.getBytesNoCopy());
                break;
            }
            case 19: {
                this.writeInt(19);
                this.writeBytes(value.getBytesNoCopy());
                break;
            }
            case 20: {
                this.writeInt(20);
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 1: {
                this.writeInt(1);
                this.writeBoolean(value.getBoolean());
                break;
            }
            case 2: {
                this.writeInt(2);
                this.writeByte(value.getByte());
                break;
            }
            case 9: {
                this.writeInt(9);
                this.writeLong(((ValueTime)value).getNanos());
                break;
            }
            case 41: {
                ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value;
                if (this.version >= 19) {
                    this.writeInt(29);
                    this.writeLong(valueTimeTimeZone.getNanos());
                    this.writeInt(valueTimeTimeZone.getTimeZoneOffsetSeconds());
                    break;
                }
                this.writeInt(9);
                ValueTimestampTimeZone valueTimestampTimeZone = this.session instanceof CastDataProvider ? ((CastDataProvider)((Object)this.session)).currentTimestamp() : CurrentTimestamp.get();
                this.writeLong(DateTimeUtils.normalizeNanosOfDay(valueTimeTimeZone.getNanos() + (long)(valueTimeTimeZone.getTimeZoneOffsetSeconds() - valueTimestampTimeZone.getTimeZoneOffsetSeconds()) * 86400000000000L));
                break;
            }
            case 10: {
                this.writeInt(10);
                this.writeLong(((ValueDate)value).getDateValue());
                break;
            }
            case 11: {
                this.writeInt(11);
                ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                this.writeLong(valueTimestamp.getDateValue());
                this.writeLong(valueTimestamp.getTimeNanos());
                break;
            }
            case 24: {
                this.writeInt(24);
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                this.writeLong(valueTimestampTimeZone.getDateValue());
                this.writeLong(valueTimestampTimeZone.getTimeNanos());
                int n2 = valueTimestampTimeZone.getTimeZoneOffsetSeconds();
                this.writeInt(this.version >= 19 ? n2 : n2 / 60);
                break;
            }
            case 6: {
                this.writeInt(6);
                this.writeString(value.getString());
                break;
            }
            case 7: {
                this.writeInt(7);
                this.writeDouble(value.getDouble());
                break;
            }
            case 8: {
                this.writeInt(8);
                this.writeFloat(value.getFloat());
                break;
            }
            case 4: {
                this.writeInt(4);
                this.writeInt(value.getInt());
                break;
            }
            case 5: {
                this.writeInt(5);
                this.writeLong(value.getLong());
                break;
            }
            case 3: {
                this.writeInt(3);
                this.writeInt(value.getShort());
                break;
            }
            case 13: {
                this.writeInt(13);
                this.writeString(value.getString());
                break;
            }
            case 14: {
                this.writeInt(14);
                this.writeString(value.getString());
                break;
            }
            case 21: {
                this.writeInt(21);
                this.writeString(value.getString());
                break;
            }
            case 15: {
                ValueLobDb valueLobDb;
                this.writeInt(15);
                if (this.version >= 11 && value instanceof ValueLobDb && (valueLobDb = (ValueLobDb)value).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(valueLobDb.getTableId());
                    this.writeLong(valueLobDb.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(valueLobDb.getLobId()));
                    }
                    this.writeLong(valueLobDb.getType().getPrecision());
                    break;
                }
                long l = value.getType().getPrecision();
                if (l < 0L) {
                    throw DbException.get(90067, "length=" + l);
                }
                this.writeLong(l);
                long l2 = IOUtils.copyAndCloseInput(value.getInputStream(), this.out);
                if (l2 != l) {
                    throw DbException.get(90067, "length:" + l + " written:" + l2);
                }
                this.writeInt(4660);
                break;
            }
            case 16: {
                ValueLobDb valueLobDb;
                this.writeInt(16);
                if (this.version >= 11 && value instanceof ValueLobDb && (valueLobDb = (ValueLobDb)value).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(valueLobDb.getTableId());
                    this.writeLong(valueLobDb.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(valueLobDb.getLobId()));
                    }
                    this.writeLong(valueLobDb.getType().getPrecision());
                    break;
                }
                long l = value.getType().getPrecision();
                if (l < 0L) {
                    throw DbException.get(90067, "length=" + l);
                }
                this.writeLong(l);
                Reader reader = value.getReader();
                Data.copyString(reader, this.out);
                this.writeInt(4660);
                break;
            }
            case 17: {
                this.writeInt(17);
                ValueArray valueArray = (ValueArray)value;
                Value[] valueArray2 = valueArray.getList();
                int n3 = valueArray2.length;
                Class<?> clazz = valueArray.getComponentType();
                if (clazz == Object.class) {
                    this.writeInt(n3);
                } else {
                    this.writeInt(-(n3 + 1));
                    this.writeString(clazz.getName());
                }
                for (Value value2 : valueArray2) {
                    this.writeValue(value2);
                }
                break;
            }
            case 39: {
                this.writeInt(this.version >= 18 ? 27 : 17);
                ValueRow valueRow = (ValueRow)value;
                Value[] valueArray = valueRow.getList();
                int n4 = valueArray.length;
                this.writeInt(n4);
                for (Value value3 : valueArray) {
                    this.writeValue(value3);
                }
                break;
            }
            case 25: {
                this.writeInt(25);
                this.writeInt(value.getInt());
                this.writeString(value.getString());
                break;
            }
            case 18: {
                this.writeInt(18);
                ResultInterface resultInterface = ((ValueResultSet)value).getResult();
                int n5 = resultInterface.getVisibleColumnCount();
                this.writeInt(n5);
                for (int i = 0; i < n5; ++i) {
                    TypeInfo typeInfo = resultInterface.getColumnType(i);
                    if (this.version >= 18) {
                        this.writeString(resultInterface.getAlias(i));
                        this.writeString(resultInterface.getColumnName(i));
                        this.writeTypeInfo(typeInfo);
                        continue;
                    }
                    this.writeString(resultInterface.getColumnName(i));
                    this.writeInt(DataType.getDataType((int)typeInfo.getValueType()).sqlType);
                    this.writeInt(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                    this.writeInt(typeInfo.getScale());
                }
                while (resultInterface.next()) {
                    this.writeBoolean(true);
                    Value[] valueArray = resultInterface.currentRow();
                    for (int i = 0; i < n5; ++i) {
                        this.writeValue(valueArray[i]);
                    }
                }
                this.writeBoolean(false);
                break;
            }
            case 22: {
                this.writeInt(22);
                if (this.version >= 14) {
                    this.writeBytes(value.getBytesNoCopy());
                    break;
                }
                this.writeString(value.getString());
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                if (this.version >= 18) {
                    ValueInterval valueInterval = (ValueInterval)value;
                    int n6 = n - 26;
                    if (valueInterval.isNegative()) {
                        n6 ^= 0xFFFFFFFF;
                    }
                    this.writeInt(26);
                    this.writeByte((byte)n6);
                    this.writeLong(valueInterval.getLeading());
                    break;
                }
                this.writeInt(13);
                this.writeString(value.getString());
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                if (this.version >= 18) {
                    ValueInterval valueInterval = (ValueInterval)value;
                    int n7 = n - 26;
                    if (valueInterval.isNegative()) {
                        n7 ^= 0xFFFFFFFF;
                    }
                    this.writeInt(26);
                    this.writeByte((byte)n7);
                    this.writeLong(valueInterval.getLeading());
                    this.writeLong(valueInterval.getRemaining());
                    break;
                }
                this.writeInt(13);
                this.writeString(value.getString());
                break;
            }
            case 40: {
                this.writeInt(28);
                this.writeBytes(value.getBytesNoCopy());
                break;
            }
            default: {
                if (JdbcUtils.customDataTypesHandler != null) {
                    this.writeInt(n);
                    this.writeBytes(value.getBytesNoCopy());
                    break;
                }
                throw DbException.get(90067, "type=" + n);
            }
        }
    }

    public Value readValue() {
        int n = this.readInt();
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueBytes.getNoCopy(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.getNoCopy(null, this.readBytes(), this.session.getDataHandler());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 10: {
                return ValueDate.fromDateValue(this.readLong());
            }
            case 9: {
                return ValueTime.fromNanos(this.readLong());
            }
            case 29: {
                return ValueTimeTimeZone.fromNanos(this.readLong(), this.readInt());
            }
            case 11: {
                return ValueTimestamp.fromDateValueAndNanos(this.readLong(), this.readLong());
            }
            case 24: {
                long l = this.readLong();
                long l2 = this.readLong();
                int n2 = this.readInt();
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l2, this.version >= 19 ? n2 : n2 * 60);
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.readDouble());
            }
            case 8: {
                return ValueFloat.get(this.readFloat());
            }
            case 25: {
                int n3 = this.readInt();
                String string = this.readString();
                return ValueEnumBase.get(string, n3);
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 15: {
                long l = this.readLong();
                if (this.version >= 11 && l == -1L) {
                    int n4 = this.readInt();
                    long l3 = this.readLong();
                    byte[] byArray = this.version >= 12 ? this.readBytes() : null;
                    long l4 = this.readLong();
                    return ValueLobDb.create(15, this.session.getDataHandler(), n4, l3, byArray, l4);
                }
                Value value = this.session.getDataHandler().getLobStorage().createBlob(this.in, l);
                int n5 = this.readInt();
                if (n5 != 4660) {
                    throw DbException.get(90067, "magic=" + n5);
                }
                return value;
            }
            case 16: {
                long l = this.readLong();
                if (this.version >= 11) {
                    if (l == -1L) {
                        int n6 = this.readInt();
                        long l5 = this.readLong();
                        byte[] byArray = this.version >= 12 ? this.readBytes() : null;
                        long l6 = this.readLong();
                        return ValueLobDb.create(16, this.session.getDataHandler(), n6, l5, byArray, l6);
                    }
                    if (l < 0L) {
                        throw DbException.get(90067, "length=" + l);
                    }
                }
                Value value = this.session.getDataHandler().getLobStorage().createClob(new DataReader(this.in), l);
                int n7 = this.readInt();
                if (n7 != 4660) {
                    throw DbException.get(90067, "magic=" + n7);
                }
                return value;
            }
            case 17: {
                int n8 = this.readInt();
                Class clazz = Object.class;
                if (n8 < 0) {
                    n8 = -(n8 + 1);
                    clazz = JdbcUtils.loadUserClass(this.readString());
                }
                Value[] valueArray = new Value[n8];
                for (int i = 0; i < n8; ++i) {
                    valueArray[i] = this.readValue();
                }
                return ValueArray.get(clazz, valueArray);
            }
            case 27: {
                int n9 = this.readInt();
                Value[] valueArray = new Value[n9];
                for (int i = 0; i < n9; ++i) {
                    valueArray[i] = this.readValue();
                }
                return ValueRow.get(valueArray);
            }
            case 18: {
                SimpleResult simpleResult = new SimpleResult();
                int n10 = this.readInt();
                for (int i = 0; i < n10; ++i) {
                    if (this.version >= 18) {
                        simpleResult.addColumn(this.readString(), this.readString(), this.readTypeInfo());
                        continue;
                    }
                    String string = this.readString();
                    simpleResult.addColumn(string, string, DataType.convertSQLTypeToValueType(this.readInt()), this.readInt(), this.readInt());
                }
                while (this.readBoolean()) {
                    Value[] valueArray = new Value[n10];
                    for (int i = 0; i < n10; ++i) {
                        valueArray[i] = this.readValue();
                    }
                    simpleResult.addRow(valueArray);
                }
                return ValueResultSet.get(simpleResult);
            }
            case 22: {
                if (this.version >= 14) {
                    return ValueGeometry.get(this.readBytes());
                }
                return ValueGeometry.get(this.readString());
            }
            case 26: {
                boolean bl;
                int n11 = this.readByte();
                boolean bl2 = bl = n11 < 0;
                if (bl) {
                    n11 ^= 0xFFFFFFFF;
                }
                return ValueInterval.from(IntervalQualifier.valueOf(n11), bl, this.readLong(), n11 < 5 ? 0L : this.readLong());
            }
            case 28: {
                return ValueJson.fromJson(this.readBytes());
            }
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.convert(ValueBytes.getNoCopy(this.readBytes()), n);
        }
        throw DbException.get(90067, "type=" + n);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSession(SessionInterface sessionInterface) {
        this.session = sessionInterface;
    }

    public void setSSL(boolean bl) {
        this.ssl = bl;
    }

    public Transfer openNewConnection() {
        InetAddress inetAddress = this.socket.getInetAddress();
        int n = this.socket.getPort();
        Socket socket = NetUtils.createSocket(inetAddress, n, this.ssl);
        Transfer transfer = new Transfer(null, socket);
        transfer.setSSL(this.ssl);
        return transfer;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public synchronized boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public void verifyLobMac(byte[] byArray, long l) {
        byte[] byArray2 = this.calculateLobMac(l);
        if (!Utils.compareSecure(byArray, byArray2)) {
            throw DbException.get(90067, "Invalid lob hmac; possibly the connection was re-opened internally");
        }
    }

    private byte[] calculateLobMac(long l) {
        if (this.lobMacSalt == null) {
            this.lobMacSalt = MathUtils.secureRandomBytes(16);
        }
        byte[] byArray = new byte[8];
        Bits.writeLong(byArray, 0, l);
        return SHA256.getHashWithSalt(byArray, this.lobMacSalt);
    }
}

