/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.value;

import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.message.DbException;
import com.hm.h2.value.CompareMode;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import java.sql.PreparedStatement;

public class ValueByte
extends Value {
    static final int PRECISION = 3;
    static final int DISPLAY_SIZE = 4;
    private final byte value;

    private ValueByte(byte by) {
        this.value = by;
    }

    @Override
    public Value add(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return ValueByte.checkRange(this.value + valueByte.value);
    }

    private static ValueByte checkRange(int n) {
        if ((byte)n != n) {
            throw DbException.get(22003, Integer.toString(n));
        }
        return ValueByte.get((byte)n);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueByte.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return ValueByte.checkRange(this.value - valueByte.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return ValueByte.checkRange(this.value * valueByte.value);
    }

    @Override
    public Value divide(Value value) {
        ValueByte valueByte = (ValueByte)value;
        if (valueByte.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.checkRange(this.value / valueByte.value);
    }

    @Override
    public Value modulus(Value value) {
        ValueByte valueByte = (ValueByte)value;
        if (valueByte.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.value % valueByte.value));
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return stringBuilder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_BYTE;
    }

    @Override
    public int getValueType() {
        return 2;
    }

    @Override
    public byte getByte() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Integer.compare(this.value, ((ValueByte)value).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) {
        preparedStatement.setByte(n, this.value);
    }

    public static ValueByte get(byte by) {
        return (ValueByte)Value.cache(new ValueByte(by));
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueByte && this.value == ((ValueByte)object).value;
    }
}

