/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.value;

import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.engine.SessionInterface;
import com.hm.h2.message.DbException;
import com.hm.h2.result.ResultInterface;
import com.hm.h2.result.SimpleResult;
import com.hm.h2.value.CompareMode;
import com.hm.h2.value.DataType;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;

public class ValueResultSet
extends Value {
    private final SimpleResult result;

    private ValueResultSet(SimpleResult simpleResult) {
        this.result = simpleResult;
    }

    public static ValueResultSet get(SimpleResult simpleResult) {
        return new ValueResultSet(simpleResult);
    }

    public static ValueResultSet get(SessionInterface sessionInterface, ResultSet resultSet, int n) {
        try {
            Value[] valueArray;
            int n2;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            SimpleResult simpleResult = new SimpleResult();
            for (n2 = 0; n2 < n3; ++n2) {
                valueArray = resultSetMetaData.getColumnLabel(n2 + 1);
                String string = resultSetMetaData.getColumnName(n2 + 1);
                int n4 = DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(n2 + 1), resultSetMetaData.getColumnTypeName(n2 + 1));
                int n5 = resultSetMetaData.getPrecision(n2 + 1);
                int n6 = resultSetMetaData.getScale(n2 + 1);
                simpleResult.addColumn((String)valueArray, string, n4, n5, n6);
            }
            for (n2 = 0; n2 < n && resultSet.next(); ++n2) {
                valueArray = new Value[n3];
                for (int i = 0; i < n3; ++i) {
                    valueArray[i] = DataType.convertToValue(sessionInterface, resultSet.getObject(i + 1), simpleResult.getColumnType(i).getValueType());
                }
                simpleResult.addRow(valueArray);
            }
            return new ValueResultSet(simpleResult);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public static ValueResultSet get(ResultInterface resultInterface, int n) {
        int n2;
        int n3 = resultInterface.getVisibleColumnCount();
        SimpleResult simpleResult = new SimpleResult();
        for (n2 = 0; n2 < n3; ++n2) {
            simpleResult.addColumn(resultInterface.getAlias(n2), resultInterface.getColumnName(n2), resultInterface.getColumnType(n2));
        }
        resultInterface.reset();
        for (n2 = 0; n2 < n && resultInterface.next(); ++n2) {
            simpleResult.addRow(Arrays.copyOf(resultInterface.currentRow(), n3));
        }
        return new ValueResultSet(simpleResult);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_RESULT_SET;
    }

    @Override
    public int getValueType() {
        return 18;
    }

    @Override
    public int getMemory() {
        return this.result.getRowCount() * this.result.getVisibleColumnCount() * 32 + 400;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        ResultInterface resultInterface = this.result.createShallowCopy(null);
        int n = resultInterface.getVisibleColumnCount();
        int n2 = 0;
        while (resultInterface.next()) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('(');
            Value[] valueArray = resultInterface.currentRow();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(valueArray[i].getString());
            }
            stringBuilder.append(')');
            ++n2;
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return this == value ? 0 : this.getString().compareTo(value.getString());
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public Object getObject() {
        return this.getString();
    }

    @Override
    public ResultInterface getResult() {
        return this.result.createShallowCopy(null);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) {
        throw this.getUnsupportedExceptionForOperation("PreparedStatement.set");
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return stringBuilder;
    }
}

