/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.value;

import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.engine.SysProperties;
import com.hm.h2.message.DbException;
import com.hm.h2.value.CompareMode;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueCollectionBase;
import java.sql.PreparedStatement;

public class ValueRow
extends ValueCollectionBase {
    private static final Object EMPTY = ValueRow.get(new Value[0]);

    private ValueRow(Value[] valueArray) {
        super(valueArray);
    }

    public static ValueRow get(Value[] valueArray) {
        return new ValueRow(valueArray);
    }

    public static ValueRow getEmpty() {
        return (ValueRow)EMPTY;
    }

    @Override
    public int getValueType() {
        return 39;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder("ROW (");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[i].getString());
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        ValueRow valueRow = (ValueRow)value;
        if (this.values == valueRow.values) {
            return 0;
        }
        int n = this.values.length;
        if (n != valueRow.values.length) {
            throw DbException.get(21002);
        }
        for (int i = 0; i < n; ++i) {
            Value value2 = this.values[i];
            Value value3 = valueRow.values[i];
            int n2 = value2.compareTo(value3, castDataProvider, compareMode);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public Object getObject() {
        int n = this.values.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            Value value = this.values[i];
            objectArray[i] = !SysProperties.OLD_RESULT_SET_GET_OBJECT && ((n2 = value.getValueType()) == 2 || n2 == 3) ? Integer.valueOf(value.getInt()) : value.getObject();
        }
        return objectArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) {
        throw this.getUnsupportedExceptionForOperation("PreparedStatement.set");
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("ROW (");
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.values[i].getSQL(stringBuilder);
        }
        return stringBuilder.append(')');
    }

    @Override
    public String getTraceSQL() {
        StringBuilder stringBuilder = new StringBuilder("ROW (");
        for (int i = 0; i < this.values.length; ++i) {
            Value value;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((value = this.values[i]) == null ? "null" : value.getTraceSQL());
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueRow)) {
            return false;
        }
        ValueRow valueRow = (ValueRow)object;
        if (this.values == valueRow.values) {
            return true;
        }
        int n = this.values.length;
        if (n != valueRow.values.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.values[i].equals(valueRow.values[i])) continue;
            return false;
        }
        return true;
    }
}

