/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.value;

import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.message.DbException;
import com.hm.h2.value.CompareMode;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import java.sql.PreparedStatement;

public class ValueShort
extends Value {
    static final int PRECISION = 5;
    static final int DISPLAY_SIZE = 6;
    private final short value;

    private ValueShort(short s) {
        this.value = s;
    }

    @Override
    public Value add(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return ValueShort.checkRange(this.value + valueShort.value);
    }

    private static ValueShort checkRange(int n) {
        if ((short)n != n) {
            throw DbException.get(22003, Integer.toString(n));
        }
        return ValueShort.get((short)n);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueShort.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return ValueShort.checkRange(this.value - valueShort.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return ValueShort.checkRange(this.value * valueShort.value);
    }

    @Override
    public Value divide(Value value) {
        ValueShort valueShort = (ValueShort)value;
        if (valueShort.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.checkRange(this.value / valueShort.value);
    }

    @Override
    public Value modulus(Value value) {
        ValueShort valueShort = (ValueShort)value;
        if (valueShort.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.value % valueShort.value));
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return stringBuilder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_SHORT;
    }

    @Override
    public int getValueType() {
        return 3;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Integer.compare(this.value, ((ValueShort)value).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) {
        preparedStatement.setShort(n, this.value);
    }

    public static ValueShort get(short s) {
        return (ValueShort)Value.cache(new ValueShort(s));
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueShort && this.value == ((ValueShort)object).value;
    }
}

