/*
 * Decompiled with CFR 0.152.
 */
package com.hm.h2.value;

import com.hm.h2.engine.CastDataProvider;
import com.hm.h2.engine.SysProperties;
import com.hm.h2.util.MathUtils;
import com.hm.h2.util.StringUtils;
import com.hm.h2.value.CompareMode;
import com.hm.h2.value.TypeInfo;
import com.hm.h2.value.Value;
import com.hm.h2.value.ValueNull;
import java.sql.PreparedStatement;

public class ValueString
extends Value {
    public static final ValueString EMPTY = new ValueString("");
    protected final String value;
    private TypeInfo type;

    protected ValueString(String string) {
        this.value = string;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return StringUtils.quoteStringSQL(stringBuilder, this.value);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueString && this.value.equals(((ValueString)object).value);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return compareMode.compareString(this.value, ((ValueString)value).value, false);
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) {
        preparedStatement.setString(n, this.value);
    }

    @Override
    public int getMemory() {
        return this.value.length() * 2 + 94;
    }

    @Override
    public Value convertPrecision(long l) {
        int n = MathUtils.convertLongToInt(l);
        if (this.value.length() <= n) {
            return this;
        }
        return this.getNew(this.value.substring(0, n));
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public final TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            int n = this.value.length();
            this.type = typeInfo = new TypeInfo(this.getValueType(), n, 0, n, null);
        }
        return typeInfo;
    }

    @Override
    public int getValueType() {
        return 13;
    }

    public static Value get(String string) {
        return ValueString.get(string, null);
    }

    public static Value get(String string, CastDataProvider castDataProvider) {
        if (string.isEmpty()) {
            return castDataProvider != null && castDataProvider.getMode().treatEmptyStringsAsNull ? ValueNull.INSTANCE : EMPTY;
        }
        ValueString valueString = new ValueString(StringUtils.cache(string));
        if (string.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueString;
        }
        return Value.cache(valueString);
    }

    protected Value getNew(String string) {
        return ValueString.get(string);
    }
}

