/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.BaseQueryKey;
import com.hm.postgresql.core.CachedQuery;
import com.hm.postgresql.core.CallableQueryKey;
import com.hm.postgresql.core.JdbcCallParseInfo;
import com.hm.postgresql.core.NativeQuery;
import com.hm.postgresql.core.Parser;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.QueryExecutor;
import com.hm.postgresql.core.QueryWithReturningColumnsKey;
import com.hm.postgresql.jdbc.PreferQueryMode;
import com.hm.postgresql.util.LruCache;
import com.hm.postgresql.util.internal.Nullness;
import java.util.List;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public CachedQuery create(Object object) {
        boolean bl;
        String string;
        BaseQueryKey baseQueryKey;
        assert (object instanceof String || object instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + object.getClass() + ", sql: " + object;
        if (object instanceof BaseQueryKey) {
            baseQueryKey = (BaseQueryKey)object;
            string = baseQueryKey.sql;
        } else {
            baseQueryKey = null;
            string = (String)object;
        }
        if (object instanceof String || Nullness.castNonNull(baseQueryKey).escapeProcessing) {
            string = Parser.replaceProcessing(string, true, this.queryExecutor.getStandardConformingStrings());
        }
        if (object instanceof CallableQueryKey) {
            JdbcCallParseInfo jdbcCallParseInfo = Parser.modifyJdbcCall(string, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion(), this.queryExecutor.getEscapeSyntaxCallMode());
            string = jdbcCallParseInfo.getSql();
            bl = jdbcCallParseInfo.isFunction();
        } else {
            bl = false;
        }
        boolean bl2 = object instanceof String || Nullness.castNonNull(baseQueryKey).isParameterized;
        boolean bl3 = bl2 || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] stringArray = object instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)object).columnNames : EMPTY_RETURNING;
        List<NativeQuery> list = Parser.parseJdbcSql(string, this.queryExecutor.getStandardConformingStrings(), bl2, bl3, this.queryExecutor.isReWriteBatchedInsertsEnabled(), this.queryExecutor.getQuoteReturningIdentifiers(), stringArray);
        Query query = this.queryExecutor.wrap(list);
        return new CachedQuery(object, query, bl);
    }
}

