/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Oid;
import com.hm.postgresql.jdbc.FieldMetadata;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class Field {
    public static final int TEXT_FORMAT = 0;
    public static final int BINARY_FORMAT = 1;
    private final int length;
    private final int oid;
    private final int mod;
    private String columnLabel;
    private int format = 0;
    private final int tableOid;
    private final int positionInTable;
    private @Nullable FieldMetadata metadata;
    private int sqlType;
    private String pgType = NOT_YET_LOADED;
    private static final String NOT_YET_LOADED = new String("pgType is not yet loaded");

    public Field(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, 0, 0);
    }

    public Field(String string, int n) {
        this(string, n, 0, -1);
    }

    public Field(String string, int n, int n2, int n3, int n4, int n5) {
        this.columnLabel = string;
        this.oid = n;
        this.length = n2;
        this.mod = n3;
        this.tableOid = n4;
        this.positionInTable = n5;
        this.metadata = n4 == 0 ? new FieldMetadata(string) : null;
    }

    @Pure
    public int getOID() {
        return this.oid;
    }

    public int getMod() {
        return this.mod;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public int getLength() {
        return this.length;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public int getTableOid() {
        return this.tableOid;
    }

    public int getPositionInTable() {
        return this.positionInTable;
    }

    public @Nullable FieldMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(FieldMetadata fieldMetadata) {
        this.metadata = fieldMetadata;
    }

    public String toString() {
        return "Field(" + (this.columnLabel != null ? this.columnLabel : "") + "," + Oid.toString(this.oid) + "," + this.length + "," + (this.format == 0 ? (char)'T' : 'B') + ")";
    }

    public void setSQLType(int n) {
        this.sqlType = n;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public void setPGType(String string) {
        this.pgType = string;
    }

    public String getPGType() {
        return this.pgType;
    }

    public boolean isTypeInitialized() {
        return this.pgType != NOT_YET_LOADED;
    }

    public void upperCaseLabel() {
        this.columnLabel = this.columnLabel.toUpperCase();
    }
}

