/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import java.io.IOException;
import java.io.OutputStream;

public class FixedLengthOutputStream
extends OutputStream {
    private final int size;
    private final OutputStream target;
    private int written;

    public FixedLengthOutputStream(int n, OutputStream outputStream) {
        this.size = n;
        this.target = outputStream;
    }

    @Override
    public void write(int n) {
        this.verifyAllowed(1);
        ++this.written;
        this.target.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.verifyAllowed(n2);
        this.target.write(byArray, n, n2);
        this.written += n2;
    }

    public int remaining() {
        return this.size - this.written;
    }

    private void verifyAllowed(int n) {
        if (this.remaining() < n) {
            throw new IOException("Attempt to write more than the specified " + this.size + " bytes");
        }
    }
}

