/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.JdbcCallParseInfo;
import com.hm.postgresql.core.NativeQuery;
import com.hm.postgresql.core.SqlCommand;
import com.hm.postgresql.core.SqlCommandType;
import com.hm.postgresql.core.Utils;
import com.hm.postgresql.jdbc.EscapeSyntaxCallMode;
import com.hm.postgresql.jdbc.EscapedFunctions2;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Parser {
    private static final int[] NO_BINDS = new int[0];
    private static final char[] QUOTE_OR_ALPHABETIC_MARKER = new char[]{'\"', '0'};
    private static final char[] QUOTE_OR_ALPHABETIC_MARKER_OR_PARENTHESIS = new char[]{'\"', '0', '('};
    private static final char[] SINGLE_QUOTE = new char[]{'\''};

    public static List<NativeQuery> parseJdbcSql(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String ... stringArray) {
        if (!bl2 && !bl3 && stringArray != null && stringArray.length == 0) {
            return Collections.singletonList(new NativeQuery(string, SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK)));
        }
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        ArrayList<Integer> arrayList = null;
        List<NativeQuery> list = null;
        boolean bl6 = false;
        boolean bl7 = false;
        int n3 = -1;
        int n4 = -1;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        SqlCommandType sqlCommandType = SqlCommandType.BLANK;
        SqlCommandType sqlCommandType2 = SqlCommandType.BLANK;
        int n5 = 0;
        boolean bl12 = true;
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        for (int i = 0; i < cArray.length; ++i) {
            int n9;
            char c = cArray[i];
            boolean bl13 = false;
            bl12 &= c == ';' || Character.isWhitespace(c);
            n8 = i;
            switch (c) {
                case '\'': {
                    i = Parser.parseSingleQuotes(cArray, i, bl);
                    break;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(cArray, i);
                    break;
                }
                case '-': {
                    i = Parser.parseLineComment(cArray, i);
                    break;
                }
                case '/': {
                    i = Parser.parseBlockComment(cArray, i);
                    break;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(cArray, i);
                    break;
                }
                case ')': {
                    if (--n2 != 0 || !bl7 || bl8) break;
                    n4 = stringBuilder.length() + i - n;
                    break;
                }
                case '?': {
                    stringBuilder.append(cArray, n, i - n);
                    if (i + 1 < cArray.length && cArray[i + 1] == '?') {
                        stringBuilder.append('?');
                        ++i;
                    } else if (!bl2) {
                        stringBuilder.append('?');
                    } else {
                        if (arrayList == null) {
                            arrayList = new ArrayList<Integer>();
                        }
                        arrayList.add(stringBuilder.length());
                        n9 = arrayList.size();
                        stringBuilder.append(NativeQuery.bindName(n9));
                    }
                    n = i + 1;
                    break;
                }
                case ';': {
                    if (n2 != 0) break;
                    if (!bl12) {
                        ++n5;
                        stringBuilder.append(cArray, n, i - n);
                        bl12 = true;
                    }
                    n = i + 1;
                    if (stringBuilder.length() > 0) {
                        if (Parser.addReturning(stringBuilder, sqlCommandType, stringArray, bl10, bl5)) {
                            bl10 = true;
                        }
                        if (bl3) {
                            if (list == null) {
                                list = new ArrayList<NativeQuery>();
                            }
                            if (!bl7 || !bl6 || n4 == -1 || arrayList != null && n4 < (Integer)arrayList.get(arrayList.size() - 1)) {
                                n3 = -1;
                                n4 = -1;
                            }
                            list.add(new NativeQuery(stringBuilder.toString(), Parser.toIntArray(arrayList), false, SqlCommand.createStatementTypeInfo(sqlCommandType, bl4, n3, n4, bl10, list.size())));
                        }
                    }
                    sqlCommandType2 = sqlCommandType;
                    bl11 = bl10;
                    sqlCommandType = SqlCommandType.BLANK;
                    bl10 = false;
                    if (!bl3) break;
                    if (arrayList != null) {
                        arrayList.clear();
                    }
                    stringBuilder.setLength(0);
                    bl7 = false;
                    bl6 = false;
                    n3 = -1;
                    n4 = -1;
                    bl8 = false;
                    break;
                }
                default: {
                    if (n7 >= 0) {
                        bl13 = Parser.isIdentifierContChar(c);
                        break;
                    }
                    bl13 = Parser.isIdentifierStartChar(c);
                    if (!bl13) break;
                    n7 = i;
                    if (n3 == -1 || n2 != 0) break;
                    bl8 = true;
                }
            }
            if (!(n7 < 0 || i != cArray.length - 1 && bl13)) {
                SqlCommandType sqlCommandType3;
                n9 = (bl13 ? i + 1 : n8) - n7;
                if (sqlCommandType == SqlCommandType.BLANK) {
                    if (n9 == 6 && Parser.parseCreateKeyword(cArray, n7)) {
                        sqlCommandType = SqlCommandType.CREATE;
                    } else if (n9 == 5 && Parser.parseAlterKeyword(cArray, n7)) {
                        sqlCommandType = SqlCommandType.ALTER;
                    } else if (n9 == 6 && Parser.parseUpdateKeyword(cArray, n7)) {
                        sqlCommandType = SqlCommandType.UPDATE;
                    } else if (n9 == 6 && Parser.parseDeleteKeyword(cArray, n7)) {
                        sqlCommandType = SqlCommandType.DELETE;
                    } else if (n9 == 4 && Parser.parseMoveKeyword(cArray, n7)) {
                        sqlCommandType = SqlCommandType.MOVE;
                    } else if (n9 == 6 && Parser.parseSelectKeyword(cArray, n7)) {
                        sqlCommandType = SqlCommandType.SELECT;
                    } else if (n9 == 4 && Parser.parseWithKeyword(cArray, n7)) {
                        sqlCommandType = SqlCommandType.WITH;
                    } else if (n9 == 6 && Parser.parseInsertKeyword(cArray, n7)) {
                        if (!bl9 && (list == null || list.isEmpty())) {
                            bl6 = n6 == 0;
                            bl9 = true;
                            sqlCommandType = SqlCommandType.INSERT;
                        } else {
                            bl6 = false;
                        }
                    }
                } else if (sqlCommandType == SqlCommandType.WITH && n2 == 0 && (sqlCommandType3 = Parser.parseWithCommandType(cArray, i, n7, n9)) != null) {
                    sqlCommandType = sqlCommandType3;
                }
                if (n2 == 0 && c != ')') {
                    if (n9 == 9 && Parser.parseReturningKeyword(cArray, n7)) {
                        bl10 = true;
                    } else if (n9 == 6 && Parser.parseValuesKeyword(cArray, n7)) {
                        bl7 = true;
                    }
                }
                n7 = -1;
                ++n6;
            }
            if (c != '(' || ++n2 != 1 || !bl7 || n3 != -1) continue;
            n3 = stringBuilder.length() + i - n;
        }
        if (!bl7 || !bl6 || n4 == -1 || arrayList != null && n4 < (Integer)arrayList.get(arrayList.size() - 1)) {
            n3 = -1;
            n4 = -1;
        }
        if (n < cArray.length && !bl12) {
            stringBuilder.append(cArray, n, cArray.length - n);
        } else if (n5 > 1) {
            bl10 = false;
            sqlCommandType = SqlCommandType.BLANK;
        } else if (n5 == 1) {
            bl10 = bl11;
            sqlCommandType = sqlCommandType2;
        }
        if (stringBuilder.length() == 0) {
            return list != null ? list : Collections.emptyList();
        }
        if (Parser.addReturning(stringBuilder, sqlCommandType, stringArray, bl10, bl5)) {
            bl10 = true;
        }
        NativeQuery nativeQuery = new NativeQuery(stringBuilder.toString(), Parser.toIntArray((List<Integer>)arrayList), !bl3, SqlCommand.createStatementTypeInfo(sqlCommandType, bl4, n3, n4, bl10, list == null ? 0 : list.size()));
        if (list == null) {
            return Collections.singletonList(nativeQuery);
        }
        if (!bl12) {
            list.add(nativeQuery);
        }
        return list;
    }

    private static @Nullable SqlCommandType parseWithCommandType(char[] cArray, int n, int n2, int n3) {
        int n4;
        SqlCommandType sqlCommandType;
        if (n3 == 6 && Parser.parseUpdateKeyword(cArray, n2)) {
            sqlCommandType = SqlCommandType.UPDATE;
        } else if (n3 == 6 && Parser.parseDeleteKeyword(cArray, n2)) {
            sqlCommandType = SqlCommandType.DELETE;
        } else if (n3 == 6 && Parser.parseInsertKeyword(cArray, n2)) {
            sqlCommandType = SqlCommandType.INSERT;
        } else if (n3 == 6 && Parser.parseSelectKeyword(cArray, n2)) {
            sqlCommandType = SqlCommandType.SELECT;
        } else {
            return null;
        }
        for (n4 = n; n4 < cArray.length; ++n4) {
            char c = cArray[n4];
            if (c == '-') {
                n4 = Parser.parseLineComment(cArray, n4);
                continue;
            }
            if (c == '/') {
                n4 = Parser.parseBlockComment(cArray, n4);
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (n4 + 2 >= cArray.length || !Parser.parseAsKeyword(cArray, n4) || Parser.isIdentifierContChar(cArray[n4 + 2])) {
            return sqlCommandType;
        }
        return null;
    }

    private static boolean addReturning(StringBuilder stringBuilder, SqlCommandType sqlCommandType, String[] stringArray, boolean bl, boolean bl2) {
        if (bl || stringArray.length == 0) {
            return false;
        }
        if (sqlCommandType != SqlCommandType.INSERT && sqlCommandType != SqlCommandType.UPDATE && sqlCommandType != SqlCommandType.DELETE && sqlCommandType != SqlCommandType.WITH) {
            return false;
        }
        stringBuilder.append("\nRETURNING ");
        if (stringArray.length == 1 && stringArray[0].charAt(0) == '*') {
            stringBuilder.append('*');
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (bl2) {
                Utils.escapeIdentifier(stringBuilder, string);
                continue;
            }
            stringBuilder.append(string);
        }
        return true;
    }

    private static int[] toIntArray(@Nullable List<Integer> list) {
        if (list == null || list.isEmpty()) {
            return NO_BINDS;
        }
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = list.get(i);
        }
        return nArray;
    }

    public static int parseSingleQuotes(char[] cArray, int n, boolean bl) {
        if (bl && n >= 2 && (cArray[n - 1] == 'e' || cArray[n - 1] == 'E') && Parser.charTerminatesIdentifier(cArray[n - 2])) {
            bl = false;
        }
        if (bl) {
            while (++n < cArray.length) {
                switch (cArray[n]) {
                    case '\'': {
                        return n;
                    }
                }
            }
        } else {
            block8: while (++n < cArray.length) {
                switch (cArray[n]) {
                    case '\\': {
                        ++n;
                        continue block8;
                    }
                    case '\'': {
                        return n;
                    }
                }
            }
        }
        return cArray.length;
    }

    public static int parseDoubleQuotes(char[] cArray, int n) {
        while (++n < cArray.length && cArray[n] != '\"') {
        }
        return n;
    }

    public static int parseDollarQuotes(char[] cArray, int n) {
        if (!(n + 1 >= cArray.length || n != 0 && Parser.isIdentifierContChar(cArray[n - 1]))) {
            int n2;
            int n3 = -1;
            if (cArray[n + 1] == '$') {
                n3 = n + 1;
            } else if (Parser.isDollarQuoteStartChar(cArray[n + 1])) {
                for (n2 = n + 2; n2 < cArray.length; ++n2) {
                    if (cArray[n2] == '$') {
                        n3 = n2;
                        break;
                    }
                    if (!Parser.isDollarQuoteContChar(cArray[n2])) break;
                }
            }
            if (n3 > 0) {
                n2 = n;
                int n4 = n3 - n + 1;
                n = n3;
                ++n;
                while (n < cArray.length) {
                    if (cArray[n] == '$' && Parser.subArraysEqual(cArray, n2, n, n4)) {
                        n += n4 - 1;
                        break;
                    }
                    ++n;
                }
            }
        }
        return n;
    }

    public static int parseLineComment(char[] cArray, int n) {
        block1: {
            if (n + 1 >= cArray.length || cArray[n + 1] != '-') break block1;
            while (n + 1 < cArray.length && cArray[++n] != '\r' && cArray[n] != '\n') {
            }
        }
        return n;
    }

    public static int parseBlockComment(char[] cArray, int n) {
        if (n + 1 < cArray.length && cArray[n + 1] == '*') {
            int n2 = 1;
            n += 2;
            while (n < cArray.length) {
                switch (cArray[n - 1]) {
                    case '*': {
                        if (cArray[n] != '/') break;
                        --n2;
                        ++n;
                        break;
                    }
                    case '/': {
                        if (cArray[n] != '*') break;
                        ++n2;
                        ++n;
                        break;
                    }
                }
                if (n2 == 0) {
                    --n;
                    break;
                }
                ++n;
            }
        }
        return n;
    }

    public static boolean parseDeleteKeyword(char[] cArray, int n) {
        if (cArray.length < n + 6) {
            return false;
        }
        return (cArray[n] | 0x20) == 100 && (cArray[n + 1] | 0x20) == 101 && (cArray[n + 2] | 0x20) == 108 && (cArray[n + 3] | 0x20) == 101 && (cArray[n + 4] | 0x20) == 116 && (cArray[n + 5] | 0x20) == 101;
    }

    public static boolean parseInsertKeyword(char[] cArray, int n) {
        if (cArray.length < n + 7) {
            return false;
        }
        return (cArray[n] | 0x20) == 105 && (cArray[n + 1] | 0x20) == 110 && (cArray[n + 2] | 0x20) == 115 && (cArray[n + 3] | 0x20) == 101 && (cArray[n + 4] | 0x20) == 114 && (cArray[n + 5] | 0x20) == 116;
    }

    public static boolean parseMoveKeyword(char[] cArray, int n) {
        if (cArray.length < n + 4) {
            return false;
        }
        return (cArray[n] | 0x20) == 109 && (cArray[n + 1] | 0x20) == 111 && (cArray[n + 2] | 0x20) == 118 && (cArray[n + 3] | 0x20) == 101;
    }

    public static boolean parseReturningKeyword(char[] cArray, int n) {
        if (cArray.length < n + 9) {
            return false;
        }
        return (cArray[n] | 0x20) == 114 && (cArray[n + 1] | 0x20) == 101 && (cArray[n + 2] | 0x20) == 116 && (cArray[n + 3] | 0x20) == 117 && (cArray[n + 4] | 0x20) == 114 && (cArray[n + 5] | 0x20) == 110 && (cArray[n + 6] | 0x20) == 105 && (cArray[n + 7] | 0x20) == 110 && (cArray[n + 8] | 0x20) == 103;
    }

    public static boolean parseSelectKeyword(char[] cArray, int n) {
        if (cArray.length < n + 6) {
            return false;
        }
        return (cArray[n] | 0x20) == 115 && (cArray[n + 1] | 0x20) == 101 && (cArray[n + 2] | 0x20) == 108 && (cArray[n + 3] | 0x20) == 101 && (cArray[n + 4] | 0x20) == 99 && (cArray[n + 5] | 0x20) == 116;
    }

    public static boolean parseAlterKeyword(char[] cArray, int n) {
        if (cArray.length < n + 5) {
            return false;
        }
        return (cArray[n] | 0x20) == 97 && (cArray[n + 1] | 0x20) == 108 && (cArray[n + 2] | 0x20) == 116 && (cArray[n + 3] | 0x20) == 101 && (cArray[n + 4] | 0x20) == 114;
    }

    public static boolean parseCreateKeyword(char[] cArray, int n) {
        if (cArray.length < n + 6) {
            return false;
        }
        return (cArray[n] | 0x20) == 99 && (cArray[n + 1] | 0x20) == 114 && (cArray[n + 2] | 0x20) == 101 && (cArray[n + 3] | 0x20) == 97 && (cArray[n + 4] | 0x20) == 116 && (cArray[n + 5] | 0x20) == 101;
    }

    public static boolean parseUpdateKeyword(char[] cArray, int n) {
        if (cArray.length < n + 6) {
            return false;
        }
        return (cArray[n] | 0x20) == 117 && (cArray[n + 1] | 0x20) == 112 && (cArray[n + 2] | 0x20) == 100 && (cArray[n + 3] | 0x20) == 97 && (cArray[n + 4] | 0x20) == 116 && (cArray[n + 5] | 0x20) == 101;
    }

    public static boolean parseValuesKeyword(char[] cArray, int n) {
        if (cArray.length < n + 6) {
            return false;
        }
        return (cArray[n] | 0x20) == 118 && (cArray[n + 1] | 0x20) == 97 && (cArray[n + 2] | 0x20) == 108 && (cArray[n + 3] | 0x20) == 117 && (cArray[n + 4] | 0x20) == 101 && (cArray[n + 5] | 0x20) == 115;
    }

    public static long parseLong(String string, int n, int n2) {
        if (n2 - n > 16) {
            return Long.parseLong(string.substring(n, n2));
        }
        long l = Parser.digitAt(string, n);
        ++n;
        while (n < n2) {
            l = l * 10L + (long)Parser.digitAt(string, n);
            ++n;
        }
        return l;
    }

    public static boolean parseWithKeyword(char[] cArray, int n) {
        if (cArray.length < n + 4) {
            return false;
        }
        return (cArray[n] | 0x20) == 119 && (cArray[n + 1] | 0x20) == 105 && (cArray[n + 2] | 0x20) == 116 && (cArray[n + 3] | 0x20) == 104;
    }

    public static boolean parseAsKeyword(char[] cArray, int n) {
        if (cArray.length < n + 2) {
            return false;
        }
        return (cArray[n] | 0x20) == 97 && (cArray[n + 1] | 0x20) == 115;
    }

    public static boolean isDigitAt(String string, int n) {
        return n > 0 && n < string.length() && Character.isDigit(string.charAt(n));
    }

    public static int digitAt(String string, int n) {
        int n2 = string.charAt(n) - 48;
        if (n2 < 0 || n2 > 9) {
            throw new NumberFormatException("Input string: \"" + string + "\", position: " + n);
        }
        return n2;
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    public static boolean isArrayWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\u000b';
    }

    public static boolean isOperatorChar(char c) {
        return ",()[].;:+-*/%^<>=~!@#&|`?".indexOf(c) != -1;
    }

    public static boolean isIdentifierStartChar(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isIdentifierContChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean charTerminatesIdentifier(char c) {
        return c == '\"' || Parser.isSpace(c) || Parser.isOperatorChar(c);
    }

    public static boolean isDollarQuoteStartChar(char c) {
        return c != '$' && Parser.isIdentifierStartChar(c);
    }

    public static boolean isDollarQuoteContChar(char c) {
        return c != '$' && Parser.isIdentifierContChar(c);
    }

    private static boolean subArraysEqual(char[] cArray, int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= cArray.length || n2 >= cArray.length || n + n3 > cArray.length || n2 + n3 > cArray.length) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (cArray[n + i] == cArray[n2 + i]) continue;
            return false;
        }
        return true;
    }

    public static JdbcCallParseInfo modifyJdbcCall(String string, boolean bl, int n, int n2, EscapeSyntaxCallMode escapeSyntaxCallMode) {
        String string2;
        String string3;
        char c;
        String string4 = string;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = string.length();
        int n4 = 1;
        boolean bl4 = false;
        boolean bl5 = false;
        int n5 = -1;
        int n6 = -1;
        boolean bl6 = false;
        int n7 = 0;
        block10: while (n7 < n3 && !bl6) {
            c = string.charAt(n7);
            switch (n4) {
                case 1: {
                    if (c == '{') {
                        ++n7;
                        ++n4;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n7;
                        continue block10;
                    }
                    n7 = n3;
                    continue block10;
                }
                case 2: {
                    if (c == '?') {
                        bl2 = true;
                        bl3 = true;
                        ++n7;
                        ++n4;
                        continue block10;
                    }
                    if (c == 'c' || c == 'C') {
                        n4 += 3;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n7;
                        continue block10;
                    }
                    bl6 = true;
                    continue block10;
                }
                case 3: {
                    if (c == '=') {
                        ++n7;
                        ++n4;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n7;
                        continue block10;
                    }
                    bl6 = true;
                    continue block10;
                }
                case 4: {
                    if (c == 'c' || c == 'C') {
                        ++n4;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n7;
                        continue block10;
                    }
                    bl6 = true;
                    continue block10;
                }
                case 5: {
                    if ((c == 'c' || c == 'C') && n7 + 4 <= n3 && string.substring(n7, n7 + 4).equalsIgnoreCase("call")) {
                        bl2 = true;
                        n7 += 4;
                        ++n4;
                        continue block10;
                    }
                    if (Character.isWhitespace(c)) {
                        ++n7;
                        continue block10;
                    }
                    bl6 = true;
                    continue block10;
                }
                case 6: {
                    if (Character.isWhitespace(c)) {
                        ++n4;
                        n5 = ++n7;
                        continue block10;
                    }
                    bl6 = true;
                    continue block10;
                }
                case 7: {
                    if (c == '\'') {
                        bl4 = !bl4;
                        ++n7;
                        continue block10;
                    }
                    if (bl4 && c == '\\' && !bl) {
                        n7 += 2;
                        continue block10;
                    }
                    if (!bl4 && c == '{') {
                        bl5 = !bl5;
                        ++n7;
                        continue block10;
                    }
                    if (!bl4 && c == '}') {
                        if (!bl5) {
                            n6 = n7++;
                            ++n4;
                            continue block10;
                        }
                        bl5 = false;
                        continue block10;
                    }
                    if (!bl4 && c == ';') {
                        bl6 = true;
                        continue block10;
                    }
                    ++n7;
                    continue block10;
                }
                case 8: {
                    if (Character.isWhitespace(c)) {
                        ++n7;
                        continue block10;
                    }
                    bl6 = true;
                    continue block10;
                }
            }
            throw new IllegalStateException("somehow got into bad state " + n4);
        }
        if (n7 == n3 && !bl6) {
            if (n4 == 1) {
                for (n7 = 0; n7 < n3 && Character.isWhitespace(string.charAt(n7)); ++n7) {
                }
                if (n7 < n3 - 5 && ((c = string.charAt(n7)) == 'c' || c == 'C') && string.substring(n7, n7 + 4).equalsIgnoreCase("call") && Character.isWhitespace(string.charAt(n7 + 4))) {
                    bl2 = true;
                }
                return new JdbcCallParseInfo(string4, bl2);
            }
            if (n4 != 8) {
                bl6 = true;
            }
        }
        if (bl6) {
            throw new PSQLException(GT.tr("Malformed function or procedure escape syntax at offset {0}.", n7), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (escapeSyntaxCallMode == EscapeSyntaxCallMode.SELECT || n < 110000 || bl3 && escapeSyntaxCallMode == EscapeSyntaxCallMode.CALL_IF_NO_RETURN) {
            string3 = "select * from ";
            string2 = " as result";
        } else {
            string3 = "call ";
            string2 = "";
        }
        String string5 = string.substring(n5, n6);
        int n8 = string3.length();
        StringBuilder stringBuilder = new StringBuilder(n8 + string.length() + string2.length() + 10);
        stringBuilder.append(string3);
        stringBuilder.append(string5);
        int n9 = string5.indexOf(40) + 1;
        if (n9 == 0) {
            stringBuilder.append(bl3 ? "(?)" : "()");
        } else if (bl3) {
            char c2;
            boolean bl7 = false;
            for (int i = n9 + n8; i < stringBuilder.length() && (c2 = stringBuilder.charAt(i)) != ')'; ++i) {
                if (Character.isWhitespace(c2)) continue;
                bl7 = true;
                break;
            }
            if (bl7) {
                stringBuilder.insert(n9 + n8, "?,");
            } else {
                stringBuilder.insert(n9 + n8, "?");
            }
        }
        string4 = !string2.isEmpty() ? stringBuilder.append(string2).toString() : stringBuilder.toString();
        return new JdbcCallParseInfo(string4, bl2);
    }

    public static String replaceProcessing(String string, boolean bl, boolean bl2) {
        if (bl) {
            int n = string.length();
            char[] cArray = string.toCharArray();
            StringBuilder stringBuilder = new StringBuilder(n);
            int n2 = 0;
            while (n2 < n) {
                if ((n2 = Parser.parseSql(cArray, n2, stringBuilder, false, bl2)) >= n) continue;
                stringBuilder.append(cArray[n2]);
                ++n2;
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static int parseSql(char[] cArray, int n, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        SqlParseState sqlParseState = SqlParseState.IN_SQLCODE;
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl3 = false;
        --n;
        while (!bl3 && ++n < n2) {
            char c = cArray[n];
            block0 : switch (sqlParseState) {
                case IN_SQLCODE: {
                    if (c == '$') {
                        int n4 = n;
                        n = Parser.parseDollarQuotes(cArray, n);
                        Parser.checkParsePosition(n, n2, n4, cArray, "Unterminated dollar quote started at position {0} in SQL {1}. Expected terminating $$");
                        stringBuilder.append(cArray, n4, n - n4 + 1);
                        break;
                    }
                    if (c == '\'') {
                        int n5 = n;
                        n = Parser.parseSingleQuotes(cArray, n, bl2);
                        Parser.checkParsePosition(n, n2, n5, cArray, "Unterminated string literal started at position {0} in SQL {1}. Expected ' char");
                        stringBuilder.append(cArray, n5, n - n5 + 1);
                        break;
                    }
                    if (c == '\"') {
                        int n6 = n;
                        n = Parser.parseDoubleQuotes(cArray, n);
                        Parser.checkParsePosition(n, n2, n6, cArray, "Unterminated identifier started at position {0} in SQL {1}. Expected \" char");
                        stringBuilder.append(cArray, n6, n - n6 + 1);
                        break;
                    }
                    if (c == '/') {
                        int n7 = n;
                        n = Parser.parseBlockComment(cArray, n);
                        Parser.checkParsePosition(n, n2, n7, cArray, "Unterminated block comment started at position {0} in SQL {1}. Expected */ sequence");
                        stringBuilder.append(cArray, n7, n - n7 + 1);
                        break;
                    }
                    if (c == '-') {
                        int n8 = n;
                        n = Parser.parseLineComment(cArray, n);
                        stringBuilder.append(cArray, n8, n - n8 + 1);
                        break;
                    }
                    if (c == '(') {
                        ++n3;
                    } else if (c == ')') {
                        if (--n3 < 0) {
                            bl3 = true;
                            break;
                        }
                    } else {
                        if (bl && c == ',' && n3 == 0) {
                            bl3 = true;
                            break;
                        }
                        if (c == '{' && n + 1 < n2) {
                            SqlParseState[] sqlParseStateArray = SqlParseState.VALUES;
                            for (int i = 1; i < sqlParseStateArray.length; ++i) {
                                SqlParseState sqlParseState2 = sqlParseStateArray[i];
                                int n9 = sqlParseState2.getMatchedPosition(cArray, n + 1);
                                if (n9 == 0) continue;
                                n += n9;
                                if (sqlParseState2.replacementKeyword != null) {
                                    stringBuilder.append(sqlParseState2.replacementKeyword);
                                }
                                sqlParseState = sqlParseState2;
                                break block0;
                            }
                        }
                    }
                    stringBuilder.append(c);
                    break;
                }
                case ESC_FUNCTION: {
                    n = Parser.escapeFunction(cArray, n, stringBuilder, bl2);
                    sqlParseState = SqlParseState.IN_SQLCODE;
                    break;
                }
                case ESC_DATE: 
                case ESC_TIME: 
                case ESC_TIMESTAMP: 
                case ESC_OUTERJOIN: 
                case ESC_ESCAPECHAR: {
                    if (c == '}') {
                        sqlParseState = SqlParseState.IN_SQLCODE;
                        break;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return n;
    }

    private static int findOpenBrace(char[] cArray, int n) {
        int n2;
        for (n2 = n; n2 < cArray.length && cArray[n2] != '('; ++n2) {
        }
        return n2;
    }

    private static void checkParsePosition(int n, int n2, int n3, char[] cArray, String string) {
        if (n < n2) {
            return;
        }
        throw new PSQLException(GT.tr(string, n3, new String(cArray)), PSQLState.SYNTAX_ERROR);
    }

    private static int escapeFunction(char[] cArray, int n, StringBuilder stringBuilder, boolean bl) {
        int n2 = Parser.findOpenBrace(cArray, n);
        if (n2 < cArray.length) {
            String string = new String(cArray, n, n2 - n).trim();
            n = n2 + 1;
            n = Parser.escapeFunctionArguments(stringBuilder, string, cArray, n, bl);
        }
        ++n;
        while (n < cArray.length && cArray[n] != '}') {
            stringBuilder.append(cArray[n++]);
        }
        return n;
    }

    private static int escapeFunctionArguments(StringBuilder stringBuilder, String string, char[] cArray, int n, boolean bl) {
        Object object;
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>(3);
        while (true) {
            object = new StringBuilder();
            int n2 = ++n;
            if ((n = Parser.parseSql(cArray, n, (StringBuilder)object, true, bl)) != n2) {
                arrayList.add((StringBuilder)object);
            }
            if (n >= cArray.length || cArray[n] != ',') break;
        }
        object = EscapedFunctions2.getFunction(string);
        if (object == null) {
            stringBuilder.append(string);
            EscapedFunctions2.appendCall(stringBuilder, "(", ",", ")", arrayList);
            return n;
        }
        try {
            ((Method)object).invoke(null, stringBuilder, arrayList);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            String string2 = throwable == null ? "no message" : throwable.getMessage();
            throw new PSQLException(string2, PSQLState.SYSTEM_ERROR);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PSQLException(illegalAccessException.getMessage(), PSQLState.SYSTEM_ERROR);
        }
        return n;
    }

    static /* synthetic */ char[] access$300() {
        return SINGLE_QUOTE;
    }

    static /* synthetic */ char[] access$400() {
        return QUOTE_OR_ALPHABETIC_MARKER;
    }

    static /* synthetic */ char[] access$500() {
        return QUOTE_OR_ALPHABETIC_MARKER_OR_PARENTHESIS;
    }

    private static enum SqlParseState {
        IN_SQLCODE,
        ESC_DATE("d", Parser.access$300(), "DATE "),
        ESC_TIME("t", Parser.access$300(), "TIME "),
        ESC_TIMESTAMP("ts", Parser.access$300(), "TIMESTAMP "),
        ESC_FUNCTION("fn", Parser.access$400(), null),
        ESC_OUTERJOIN("oj", Parser.access$500(), null),
        ESC_ESCAPECHAR("escape", Parser.access$300(), "ESCAPE ");

        private static final SqlParseState[] VALUES;
        private final char[] escapeKeyword;
        private final char[] allowedValues;
        private final @Nullable String replacementKeyword;

        private SqlParseState() {
            this("", new char[0], null);
        }

        private SqlParseState(@Nullable String string2, char[] cArray, String string3) {
            this.escapeKeyword = string2.toCharArray();
            this.allowedValues = cArray;
            this.replacementKeyword = string3;
        }

        private boolean startMatches(char[] cArray, int n) {
            for (char c : this.escapeKeyword) {
                char c2;
                if (n >= cArray.length) {
                    return false;
                }
                if ((c2 = cArray[n++]) == c || c2 == Character.toUpperCase(c)) continue;
                return false;
            }
            return n < cArray.length;
        }

        private int getMatchedPosition(char[] cArray, int n) {
            if (!this.startMatches(cArray, n)) {
                return 0;
            }
            int n2 = n + this.escapeKeyword.length;
            char c = cArray[n2];
            while (c == ' ') {
                if (++n2 >= cArray.length) {
                    return 0;
                }
                c = cArray[n2];
            }
            for (char c2 : this.allowedValues) {
                if (c != c2 && (c2 != '0' || !Character.isLetter(c))) continue;
                return n2 - n;
            }
            return 0;
        }

        static {
            VALUES = SqlParseState.values();
        }
    }
}

