/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.PGNotification;
import com.hm.postgresql.PGProperty;
import com.hm.postgresql.core.BaseQueryKey;
import com.hm.postgresql.core.CachedQuery;
import com.hm.postgresql.core.CachedQueryCreateAction;
import com.hm.postgresql.core.CallableQueryKey;
import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.core.PGStream;
import com.hm.postgresql.core.QueryExecutor;
import com.hm.postgresql.core.QueryWithReturningColumnsKey;
import com.hm.postgresql.core.TransactionState;
import com.hm.postgresql.core.Utils;
import com.hm.postgresql.jdbc.AutoSave;
import com.hm.postgresql.jdbc.EscapeSyntaxCallMode;
import com.hm.postgresql.jdbc.PreferQueryMode;
import com.hm.postgresql.util.HostSpec;
import com.hm.postgresql.util.LruCache;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.ServerErrorMessage;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class QueryExecutorBase
implements QueryExecutor {
    private static final Logger LOGGER = Logger.getLogger(QueryExecutorBase.class.getName());
    protected final PGStream pgStream;
    private final String user;
    private final String database;
    private final int cancelSignalTimeout;
    private int cancelPid;
    private int cancelKey;
    private boolean closed = false;
    private @MonotonicNonNull String serverVersion;
    private int serverVersionNum = 0;
    private TransactionState transactionState = TransactionState.IDLE;
    private final boolean reWriteBatchedInserts;
    private final boolean columnSanitiserDisabled;
    private final EscapeSyntaxCallMode escapeSyntaxCallMode;
    private final boolean quoteReturningIdentifiers;
    private final PreferQueryMode preferQueryMode;
    private AutoSave autoSave;
    private boolean flushCacheOnDeallocate = true;
    protected final boolean logServerErrorDetail;
    private boolean standardConformingStrings = false;
    private @Nullable SQLWarning warnings;
    private final ArrayList<PGNotification> notifications = new ArrayList();
    private final LruCache<Object, CachedQuery> statementCache;
    private final CachedQueryCreateAction cachedQueryCreateAction;
    private final TreeMap<String, String> parameterStatuses = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    protected QueryExecutorBase(PGStream pGStream, String string, String string2, int n, Properties properties) {
        this.pgStream = pGStream;
        this.user = string;
        this.database = string2;
        this.cancelSignalTimeout = n;
        this.reWriteBatchedInserts = PGProperty.REWRITE_BATCHED_INSERTS.getBoolean(properties);
        this.columnSanitiserDisabled = PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(properties);
        String string3 = PGProperty.ESCAPE_SYNTAX_CALL_MODE.get(properties);
        this.escapeSyntaxCallMode = EscapeSyntaxCallMode.of(string3);
        this.quoteReturningIdentifiers = PGProperty.QUOTE_RETURNING_IDENTIFIERS.getBoolean(properties);
        String string4 = PGProperty.PREFER_QUERY_MODE.get(properties);
        this.preferQueryMode = PreferQueryMode.of(string4);
        this.autoSave = AutoSave.of(PGProperty.AUTOSAVE.get(properties));
        this.logServerErrorDetail = PGProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(properties);
        this.cachedQueryCreateAction = new CachedQueryCreateAction(this);
        this.statementCache = new LruCache<Object, CachedQuery>(Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.getInt(properties)), Math.max(0L, (long)PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getInt(properties) * 1024L * 1024L), false, this.cachedQueryCreateAction, new LruCache.EvictAction<CachedQuery>(){

            @Override
            public void evict(CachedQuery cachedQuery) {
                cachedQuery.query.close();
            }
        });
    }

    protected abstract void sendCloseMessage();

    @Override
    public void setNetworkTimeout(int n) {
        this.pgStream.setNetworkTimeout(n);
    }

    @Override
    public int getNetworkTimeout() {
        return this.pgStream.getNetworkTimeout();
    }

    @Override
    public HostSpec getHostSpec() {
        return this.pgStream.getHostSpec();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    public void setBackendKeyData(int n, int n2) {
        this.cancelPid = n;
        this.cancelKey = n2;
    }

    @Override
    public int getBackendPID() {
        return this.cancelPid;
    }

    @Override
    public void abort() {
        try {
            this.pgStream.getSocket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            LOGGER.log(Level.FINEST, " FE=> Terminate");
            this.sendCloseMessage();
            this.pgStream.flush();
            this.pgStream.close();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINEST, "Discarding IOException on close:", iOException);
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void sendQueryCancel() {
        PGStream pGStream = null;
        try {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, " FE=> CancelRequest(pid={0},ckey={1})", new Object[]{this.cancelPid, this.cancelKey});
            }
            pGStream = new PGStream(this.pgStream.getSocketFactory(), this.pgStream.getHostSpec(), this.cancelSignalTimeout);
            if (this.cancelSignalTimeout > 0) {
                pGStream.setNetworkTimeout(this.cancelSignalTimeout);
            }
            pGStream.sendInteger4(16);
            pGStream.sendInteger2(1234);
            pGStream.sendInteger2(5678);
            pGStream.sendInteger4(this.cancelPid);
            pGStream.sendInteger4(this.cancelKey);
            pGStream.flush();
            pGStream.receiveEOF();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINEST, "Ignoring exception on cancel request:", iOException);
        }
        finally {
            if (pGStream != null) {
                try {
                    pGStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    public synchronized void addNotification(PGNotification pGNotification) {
        this.notifications.add(pGNotification);
    }

    @Override
    public synchronized PGNotification[] getNotifications() {
        PGNotification[] pGNotificationArray = this.notifications.toArray(new PGNotification[0]);
        this.notifications.clear();
        return pGNotificationArray;
    }

    @Override
    public synchronized @Nullable SQLWarning getWarnings() {
        SQLWarning sQLWarning = this.warnings;
        this.warnings = null;
        return sQLWarning;
    }

    @Override
    public String getServerVersion() {
        String string = this.serverVersion;
        if (string == null) {
            throw new IllegalStateException("serverVersion must not be null");
        }
        return string;
    }

    @Override
    public int getServerVersionNum() {
        if (this.serverVersionNum != 0) {
            return this.serverVersionNum;
        }
        this.serverVersionNum = Utils.parseServerVersionStr(this.getServerVersion());
        return this.serverVersionNum;
    }

    public void setServerVersion(String string) {
        this.serverVersion = string;
    }

    public void setServerVersionNum(int n) {
        this.serverVersionNum = n;
    }

    public synchronized void setTransactionState(TransactionState transactionState) {
        this.transactionState = transactionState;
    }

    public synchronized void setStandardConformingStrings(boolean bl) {
        this.standardConformingStrings = bl;
    }

    @Override
    public synchronized boolean getStandardConformingStrings() {
        return this.standardConformingStrings;
    }

    @Override
    public boolean getQuoteReturningIdentifiers() {
        return this.quoteReturningIdentifiers;
    }

    @Override
    public synchronized TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setEncoding(Encoding encoding) {
        this.pgStream.setEncoding(encoding);
    }

    @Override
    public Encoding getEncoding() {
        return this.pgStream.getEncoding();
    }

    @Override
    public boolean isReWriteBatchedInsertsEnabled() {
        return this.reWriteBatchedInserts;
    }

    @Override
    public final CachedQuery borrowQuery(String string) {
        return this.statementCache.borrow(string);
    }

    @Override
    public final CachedQuery borrowCallableQuery(String string) {
        return this.statementCache.borrow(new CallableQueryKey(string));
    }

    @Override
    public final CachedQuery borrowReturningQuery(String string, String @Nullable [] stringArray) {
        return this.statementCache.borrow(new QueryWithReturningColumnsKey(string, true, true, stringArray));
    }

    @Override
    public CachedQuery borrowQueryByKey(Object object) {
        return this.statementCache.borrow(object);
    }

    @Override
    public void releaseQuery(CachedQuery cachedQuery) {
        this.statementCache.put(cachedQuery.key, cachedQuery);
    }

    @Override
    public final Object createQueryKey(String string, boolean bl, boolean bl2, String ... stringArray) {
        Object object = stringArray == null || stringArray.length != 0 ? new QueryWithReturningColumnsKey(string, bl2, bl, stringArray) : (bl2 ? string : new BaseQueryKey(string, false, bl));
        return object;
    }

    @Override
    public CachedQuery createQueryByKey(Object object) {
        return this.cachedQueryCreateAction.create(object);
    }

    @Override
    public final CachedQuery createQuery(String string, boolean bl, boolean bl2, String ... stringArray) {
        Object object = this.createQueryKey(string, bl, bl2, stringArray);
        return this.createQueryByKey(object);
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.columnSanitiserDisabled;
    }

    @Override
    public EscapeSyntaxCallMode getEscapeSyntaxCallMode() {
        return this.escapeSyntaxCallMode;
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return this.preferQueryMode;
    }

    @Override
    public AutoSave getAutoSave() {
        return this.autoSave;
    }

    @Override
    public void setAutoSave(AutoSave autoSave) {
        this.autoSave = autoSave;
    }

    protected boolean willHealViaReparse(SQLException sQLException) {
        if (sQLException == null || sQLException.getSQLState() == null) {
            return false;
        }
        if (PSQLState.INVALID_SQL_STATEMENT_NAME.getState().equals(sQLException.getSQLState())) {
            return true;
        }
        if (!PSQLState.NOT_IMPLEMENTED.getState().equals(sQLException.getSQLState())) {
            return false;
        }
        if (!(sQLException instanceof PSQLException)) {
            return false;
        }
        PSQLException pSQLException = (PSQLException)sQLException;
        ServerErrorMessage serverErrorMessage = pSQLException.getServerErrorMessage();
        if (serverErrorMessage == null) {
            return false;
        }
        String string = serverErrorMessage.getRoutine();
        return "RevalidateCachedQuery".equals(string) || "RevalidateCachedPlan".equals(string);
    }

    @Override
    public boolean willHealOnRetry(SQLException sQLException) {
        if (this.autoSave == AutoSave.NEVER && this.getTransactionState() == TransactionState.FAILED) {
            return false;
        }
        return this.willHealViaReparse(sQLException);
    }

    public boolean isFlushCacheOnDeallocate() {
        return this.flushCacheOnDeallocate;
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean bl) {
        this.flushCacheOnDeallocate = bl;
    }

    protected boolean hasNotifications() {
        return this.notifications.size() > 0;
    }

    @Override
    public final Map<String, String> getParameterStatuses() {
        return Collections.unmodifiableMap(this.parameterStatuses);
    }

    @Override
    public final @Nullable String getParameterStatus(String string) {
        return this.parameterStatuses.get(string);
    }

    protected void onParameterStatus(String string, String string2) {
        if (string == null || string.equals("")) {
            throw new IllegalStateException("attempt to set GUC_REPORT parameter with null or empty-string name");
        }
        this.parameterStatuses.put(string, string2);
    }
}

