/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.BaseQueryKey;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

class QueryWithReturningColumnsKey
extends BaseQueryKey {
    public final String[] columnNames;
    private int size;

    QueryWithReturningColumnsKey(String string, boolean bl, boolean bl2, String @Nullable [] stringArray) {
        super(string, bl, bl2);
        if (stringArray == null) {
            stringArray = new String[]{"*"};
        }
        this.columnNames = stringArray;
    }

    @Override
    public long getSize() {
        int n = this.size;
        if (n != 0) {
            return n;
        }
        n = (int)super.getSize();
        if (this.columnNames != null) {
            n = (int)((long)n + 16L);
            for (String string : this.columnNames) {
                n = (int)((long)n + (long)string.length() * 2L);
            }
        }
        this.size = n;
        return n;
    }

    @Override
    public String toString() {
        return "QueryWithReturningColumnsKey{sql='" + this.sql + '\'' + ", isParameterized=" + this.isParameterized + ", escapeProcessing=" + this.escapeProcessing + ", columnNames=" + Arrays.toString(this.columnNames) + '}';
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        QueryWithReturningColumnsKey queryWithReturningColumnsKey = (QueryWithReturningColumnsKey)object;
        return Arrays.equals(this.columnNames, queryWithReturningColumnsKey.columnNames);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + Arrays.hashCode(this.columnNames);
        return n;
    }
}

