/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.ResultCursor;
import com.hm.postgresql.core.ResultHandler;
import com.hm.postgresql.core.Tuple;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResultHandlerDelegate
implements ResultHandler {
    private final @Nullable ResultHandler delegate;

    public ResultHandlerDelegate(@Nullable ResultHandler resultHandler) {
        this.delegate = resultHandler;
    }

    @Override
    public void handleResultRows(Query query, Field[] fieldArray, List<Tuple> list, @Nullable ResultCursor resultCursor) {
        if (this.delegate != null) {
            this.delegate.handleResultRows(query, fieldArray, list, resultCursor);
        }
    }

    @Override
    public void handleCommandStatus(String string, long l, long l2) {
        if (this.delegate != null) {
            this.delegate.handleCommandStatus(string, l, l2);
        }
    }

    @Override
    public void handleWarning(SQLWarning sQLWarning) {
        if (this.delegate != null) {
            this.delegate.handleWarning(sQLWarning);
        }
    }

    @Override
    public void handleError(SQLException sQLException) {
        if (this.delegate != null) {
            this.delegate.handleError(sQLException);
        }
    }

    @Override
    public void handleCompletion() {
        if (this.delegate != null) {
            this.delegate.handleCompletion();
        }
    }

    @Override
    public void secureProgress() {
        if (this.delegate != null) {
            this.delegate.secureProgress();
        }
    }

    @Override
    public @Nullable SQLException getException() {
        if (this.delegate != null) {
            return this.delegate.getException();
        }
        return null;
    }

    @Override
    public @Nullable SQLWarning getWarning() {
        if (this.delegate != null) {
            return this.delegate.getWarning();
        }
        return null;
    }
}

