/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core;

import com.hm.postgresql.core.SqlCommandType;

public class SqlCommand {
    public static final SqlCommand BLANK = SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK);
    private final SqlCommandType commandType;
    private final boolean parsedSQLhasRETURNINGKeyword;
    private final int valuesBraceOpenPosition;
    private final int valuesBraceClosePosition;

    public boolean isBatchedReWriteCompatible() {
        return this.valuesBraceOpenPosition >= 0;
    }

    public int getBatchRewriteValuesBraceOpenPosition() {
        return this.valuesBraceOpenPosition;
    }

    public int getBatchRewriteValuesBraceClosePosition() {
        return this.valuesBraceClosePosition;
    }

    public SqlCommandType getType() {
        return this.commandType;
    }

    public boolean isReturningKeywordPresent() {
        return this.parsedSQLhasRETURNINGKeyword;
    }

    public boolean returnsRows() {
        return this.parsedSQLhasRETURNINGKeyword || this.commandType == SqlCommandType.SELECT || this.commandType == SqlCommandType.WITH;
    }

    public static SqlCommand createStatementTypeInfo(SqlCommandType sqlCommandType, boolean bl, int n, int n2, boolean bl2, int n3) {
        return new SqlCommand(sqlCommandType, bl, n, n2, bl2, n3);
    }

    public static SqlCommand createStatementTypeInfo(SqlCommandType sqlCommandType) {
        return new SqlCommand(sqlCommandType, false, -1, -1, false, 0);
    }

    public static SqlCommand createStatementTypeInfo(SqlCommandType sqlCommandType, boolean bl) {
        return new SqlCommand(sqlCommandType, false, -1, -1, bl, 0);
    }

    private SqlCommand(SqlCommandType sqlCommandType, boolean bl, int n, int n2, boolean bl2, int n3) {
        this.commandType = sqlCommandType;
        this.parsedSQLhasRETURNINGKeyword = bl2;
        boolean bl3 = sqlCommandType == SqlCommandType.INSERT && bl && n >= 0 && n2 > n && !bl2 && n3 == 0;
        this.valuesBraceOpenPosition = bl3 ? n : -1;
        this.valuesBraceClosePosition = bl3 ? n2 : -1;
    }
}

