/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3;

import com.hm.postgresql.core.NativeQuery;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.v3.SimpleQuery;
import com.hm.postgresql.core.v3.TypeTransferModeRegistry;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BatchedQuery
extends SimpleQuery {
    private @Nullable String sql;
    private final int valuesBraceOpenPosition;
    private final int valuesBraceClosePosition;
    private final int batchSize;
    private BatchedQuery @Nullable [] blocks;

    public BatchedQuery(NativeQuery nativeQuery, TypeTransferModeRegistry typeTransferModeRegistry, int n, int n2, boolean bl) {
        super(nativeQuery, typeTransferModeRegistry, bl);
        this.valuesBraceOpenPosition = n;
        this.valuesBraceClosePosition = n2;
        this.batchSize = 1;
    }

    private BatchedQuery(BatchedQuery batchedQuery, int n) {
        super(batchedQuery);
        this.valuesBraceOpenPosition = batchedQuery.valuesBraceOpenPosition;
        this.valuesBraceClosePosition = batchedQuery.valuesBraceClosePosition;
        this.batchSize = n;
    }

    public BatchedQuery deriveForMultiBatch(int n) {
        BatchedQuery batchedQuery;
        if (this.getBatchSize() != 1) {
            throw new IllegalStateException("Only the original decorator can be derived.");
        }
        if (n == 1) {
            return this;
        }
        int n2 = Integer.numberOfTrailingZeros(n) - 1;
        if (n > 128 || n != 1 << n2 + 1) {
            throw new IllegalArgumentException("Expected value block should be a power of 2 smaller or equal to 128. Actual block is " + n);
        }
        if (this.blocks == null) {
            this.blocks = new BatchedQuery[7];
        }
        if ((batchedQuery = this.blocks[n2]) == null) {
            this.blocks[n2] = batchedQuery = new BatchedQuery(this, n);
        }
        return batchedQuery;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String getNativeSql() {
        if (this.sql != null) {
            return this.sql;
        }
        this.sql = this.buildNativeSql(null);
        return this.sql;
    }

    private String buildNativeSql(@Nullable ParameterList parameterList) {
        int n;
        int n2;
        String string = null;
        String string2 = super.getNativeSql();
        int n3 = this.getBatchSize();
        if (n3 < 2) {
            string = string2;
            return string;
        }
        if (string2 == null) {
            string = "";
            return string;
        }
        int n4 = 0;
        int[] nArray = this.getNativeQuery().bindPositions;
        int[] nArray2 = new int[1 + nArray.length];
        int[] nArray3 = new int[1 + nArray.length];
        nArray2[0] = this.valuesBraceOpenPosition;
        if (nArray.length == 0) {
            n4 = this.valuesBraceClosePosition - this.valuesBraceOpenPosition + 1;
            nArray3[0] = this.valuesBraceClosePosition + 1;
        } else {
            nArray3[0] = nArray[0];
            n4 += nArray3[0] - nArray2[0];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n5;
                int n6 = n = n2 < nArray.length - 1 ? nArray[n2 + 1] : this.valuesBraceClosePosition + 1;
                for (n5 = nArray[n2] + 2; n5 < n && Character.isDigit(string2.charAt(n5)); ++n5) {
                }
                nArray2[n2 + 1] = n5;
                nArray3[n2 + 1] = n;
                n4 += nArray3[n2 + 1] - nArray2[n2 + 1];
            }
        }
        n2 = string2.length();
        n2 += NativeQuery.calculateBindLength(nArray.length * n3);
        n2 -= NativeQuery.calculateBindLength(nArray.length);
        StringBuilder stringBuilder = new StringBuilder(n2 += (n4 + 1) * (n3 - 1));
        if (nArray.length > 0 && parameterList == null) {
            stringBuilder.append(string2, 0, this.valuesBraceClosePosition + 1);
            n = nArray.length + 1;
        } else {
            n = 1;
            ++n3;
            stringBuilder.append(string2, 0, this.valuesBraceOpenPosition);
        }
        for (int i = 2; i <= n3; ++i) {
            if (i > 2 || n != 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string2, nArray2[0], nArray3[0]);
            for (int j = 1; j < nArray2.length; ++j) {
                if (parameterList == null) {
                    NativeQuery.appendBindName(stringBuilder, n++);
                } else {
                    stringBuilder.append(parameterList.toString(n++, true));
                }
                stringBuilder.append(string2, nArray2[j], nArray3[j]);
            }
        }
        stringBuilder.append(string2, this.valuesBraceClosePosition + 1, string2.length());
        string = stringBuilder.toString();
        assert (parameterList != null || stringBuilder.length() == n2) : "Predicted length != actual: " + n2 + " !=" + stringBuilder.length();
        return string;
    }

    @Override
    public String toString(@Nullable ParameterList parameterList) {
        if (this.getBatchSize() < 2) {
            return super.toString(parameterList);
        }
        return this.buildNativeSql(parameterList);
    }
}

