/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3;

import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.NativeQuery;
import com.hm.postgresql.core.Oid;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.SqlCommand;
import com.hm.postgresql.core.v3.SimpleParameterList;
import com.hm.postgresql.core.v3.TypeTransferModeRegistry;
import com.hm.postgresql.jdbc.PgResultSet;
import java.lang.ref.PhantomReference;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

class SimpleQuery
implements Query {
    private static final Logger LOGGER = Logger.getLogger(SimpleQuery.class.getName());
    private @Nullable Map<String, Integer> resultSetColumnNameIndexMap;
    private final NativeQuery nativeQuery;
    private final @Nullable TypeTransferModeRegistry transferModeRegistry;
    private @Nullable String statementName;
    private byte @Nullable [] encodedStatementName;
    private Field @Nullable [] fields;
    private boolean needUpdateFieldFormats;
    private boolean hasBinaryFields;
    private boolean portalDescribed;
    private boolean statementDescribed;
    private final boolean sanitiserDisabled;
    private @Nullable PhantomReference<?> cleanupRef;
    private int @Nullable [] preparedTypes;
    private @Nullable BitSet unspecifiedParams;
    private short deallocateEpoch;
    private @Nullable Integer cachedMaxResultRowSize;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0, null);

    SimpleQuery(SimpleQuery simpleQuery) {
        this(simpleQuery.nativeQuery, simpleQuery.transferModeRegistry, simpleQuery.sanitiserDisabled);
    }

    SimpleQuery(NativeQuery nativeQuery, @Nullable TypeTransferModeRegistry typeTransferModeRegistry, boolean bl) {
        this.nativeQuery = nativeQuery;
        this.transferModeRegistry = typeTransferModeRegistry;
        this.sanitiserDisabled = bl;
    }

    @Override
    public ParameterList createParameterList() {
        if (this.nativeQuery.bindPositions.length == 0) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.getBindCount(), this.transferModeRegistry);
    }

    @Override
    public String toString(@Nullable ParameterList parameterList) {
        return this.nativeQuery.toString(parameterList);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void close() {
        this.unprepare();
    }

    public SimpleQuery @Nullable [] getSubqueries() {
        return null;
    }

    public int getMaxResultRowSize() {
        if (this.cachedMaxResultRowSize != null) {
            return this.cachedMaxResultRowSize;
        }
        if (!this.statementDescribed) {
            throw new IllegalStateException("Cannot estimate result row size on a statement that is not described");
        }
        int n = 0;
        if (this.fields != null) {
            for (Field field : this.fields) {
                int n2 = field.getLength();
                if (n2 < 1 || n2 >= 65535) {
                    n = -1;
                    break;
                }
                n += n2;
            }
        }
        this.cachedMaxResultRowSize = n;
        return n;
    }

    @Override
    public String getNativeSql() {
        return this.nativeQuery.nativeSql;
    }

    void setStatementName(String string, short s) {
        assert (string != null) : "statement name should not be null";
        this.statementName = string;
        this.encodedStatementName = string.getBytes(StandardCharsets.UTF_8);
        this.deallocateEpoch = s;
    }

    void setPrepareTypes(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n != 0) continue;
            if (this.unspecifiedParams == null) {
                this.unspecifiedParams = new BitSet();
            }
            this.unspecifiedParams.set(i);
        }
        if (this.preparedTypes == null) {
            this.preparedTypes = (int[])nArray.clone();
            return;
        }
        System.arraycopy(nArray, 0, this.preparedTypes, 0, nArray.length);
    }

    int @Nullable [] getPrepareTypes() {
        return this.preparedTypes;
    }

    @Nullable String getStatementName() {
        return this.statementName;
    }

    boolean isPreparedFor(int[] nArray, short s) {
        if (this.statementName == null || this.preparedTypes == null) {
            return false;
        }
        if (this.deallocateEpoch != s) {
            return false;
        }
        assert (nArray.length == this.preparedTypes.length) : String.format("paramTypes:%1$d preparedTypes:%2$d", nArray.length, this.preparedTypes.length);
        BitSet bitSet = this.unspecifiedParams;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = this.preparedTypes[i];
            if (n == n2 || n == 0 && bitSet != null && bitSet.get(i)) continue;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Statement {0} does not match new parameter types. Will have to un-prepare it and parse once again. To avoid performance issues, use the same data type for the same bind position. Bind index (1-based) is {1}, preparedType was {2} (after describe {3}), current bind type is {4}", new Object[]{this.statementName, i + 1, Oid.toString(bitSet != null && bitSet.get(i) ? 0 : n2), Oid.toString(n2), Oid.toString(n)});
            }
            return false;
        }
        return true;
    }

    boolean hasUnresolvedTypes() {
        if (this.preparedTypes == null) {
            return true;
        }
        return this.unspecifiedParams != null && !this.unspecifiedParams.isEmpty();
    }

    byte @Nullable [] getEncodedStatementName() {
        return this.encodedStatementName;
    }

    void setFields(Field @Nullable [] fieldArray) {
        this.fields = fieldArray;
        this.resultSetColumnNameIndexMap = null;
        this.cachedMaxResultRowSize = null;
        this.needUpdateFieldFormats = fieldArray != null;
        this.hasBinaryFields = false;
    }

    Field @Nullable [] getFields() {
        return this.fields;
    }

    boolean needUpdateFieldFormats() {
        if (this.needUpdateFieldFormats) {
            this.needUpdateFieldFormats = false;
            return true;
        }
        return false;
    }

    public void resetNeedUpdateFieldFormats() {
        this.needUpdateFieldFormats = this.fields != null;
    }

    public boolean hasBinaryFields() {
        return this.hasBinaryFields;
    }

    public void setHasBinaryFields(boolean bl) {
        this.hasBinaryFields = bl;
    }

    boolean isPortalDescribed() {
        return this.portalDescribed;
    }

    void setPortalDescribed(boolean bl) {
        this.portalDescribed = bl;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public boolean isStatementDescribed() {
        return this.statementDescribed;
    }

    void setStatementDescribed(boolean bl) {
        this.statementDescribed = bl;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public boolean isEmpty() {
        return this.getNativeSql().isEmpty();
    }

    void setCleanupRef(PhantomReference<?> phantomReference) {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
        }
        this.cleanupRef = phantomReference;
    }

    void unprepare() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
        if (this.unspecifiedParams != null) {
            this.unspecifiedParams.clear();
        }
        this.statementName = null;
        this.encodedStatementName = null;
        this.fields = null;
        this.resultSetColumnNameIndexMap = null;
        this.portalDescribed = false;
        this.statementDescribed = false;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public int getBatchSize() {
        return 1;
    }

    NativeQuery getNativeQuery() {
        return this.nativeQuery;
    }

    public final int getBindCount() {
        return this.nativeQuery.bindPositions.length * this.getBatchSize();
    }

    @Override
    public @Nullable Map<String, Integer> getResultSetColumnNameIndexMap() {
        Map<String, Integer> map = this.resultSetColumnNameIndexMap;
        if (map == null && this.fields != null) {
            map = PgResultSet.createColumnNameIndexMap(this.fields, this.sanitiserDisabled);
            if (this.statementName != null) {
                this.resultSetColumnNameIndexMap = map;
            }
        }
        return map;
    }

    @Override
    public SqlCommand getSqlCommand() {
        return this.nativeQuery.getCommand();
    }
}

