/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.core.v3.replication;

import com.hm.postgresql.copy.CopyDual;
import com.hm.postgresql.core.PGStream;
import com.hm.postgresql.core.QueryExecutor;
import com.hm.postgresql.core.ReplicationProtocol;
import com.hm.postgresql.core.v3.replication.V3PGReplicationStream;
import com.hm.postgresql.replication.PGReplicationStream;
import com.hm.postgresql.replication.ReplicationType;
import com.hm.postgresql.replication.fluent.CommonOptions;
import com.hm.postgresql.replication.fluent.logical.LogicalReplicationOptions;
import com.hm.postgresql.replication.fluent.physical.PhysicalReplicationOptions;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class V3ReplicationProtocol
implements ReplicationProtocol {
    private static final Logger LOGGER = Logger.getLogger(V3ReplicationProtocol.class.getName());
    private final QueryExecutor queryExecutor;
    private final PGStream pgStream;

    public V3ReplicationProtocol(QueryExecutor queryExecutor, PGStream pGStream) {
        this.queryExecutor = queryExecutor;
        this.pgStream = pGStream;
    }

    @Override
    public PGReplicationStream startLogical(LogicalReplicationOptions logicalReplicationOptions) {
        String string = this.createStartLogicalQuery(logicalReplicationOptions);
        return this.initializeReplication(string, logicalReplicationOptions, ReplicationType.LOGICAL);
    }

    @Override
    public PGReplicationStream startPhysical(PhysicalReplicationOptions physicalReplicationOptions) {
        String string = this.createStartPhysicalQuery(physicalReplicationOptions);
        return this.initializeReplication(string, physicalReplicationOptions, ReplicationType.PHYSICAL);
    }

    private PGReplicationStream initializeReplication(String string, CommonOptions commonOptions, ReplicationType replicationType) {
        LOGGER.log(Level.FINEST, " FE=> StartReplication(query: {0})", string);
        this.configureSocketTimeout(commonOptions);
        CopyDual copyDual = (CopyDual)this.queryExecutor.startCopy(string, true);
        return new V3PGReplicationStream(Nullness.castNonNull(copyDual), commonOptions.getStartLSNPosition(), commonOptions.getStatusInterval(), replicationType);
    }

    private String createStartPhysicalQuery(PhysicalReplicationOptions physicalReplicationOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("START_REPLICATION");
        if (physicalReplicationOptions.getSlotName() != null) {
            stringBuilder.append(" SLOT ").append(physicalReplicationOptions.getSlotName());
        }
        stringBuilder.append(" PHYSICAL ").append(physicalReplicationOptions.getStartLSNPosition().asString());
        return stringBuilder.toString();
    }

    private String createStartLogicalQuery(LogicalReplicationOptions logicalReplicationOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("START_REPLICATION SLOT ").append(logicalReplicationOptions.getSlotName()).append(" LOGICAL ").append(logicalReplicationOptions.getStartLSNPosition().asString());
        Properties properties = logicalReplicationOptions.getSlotOptions();
        if (properties.isEmpty()) {
            return stringBuilder.toString();
        }
        stringBuilder.append(" (");
        boolean bl = true;
        for (String string : properties.stringPropertyNames()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append('\"').append(string).append('\"').append(" ").append('\'').append(properties.getProperty(string)).append('\'');
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void configureSocketTimeout(CommonOptions commonOptions) {
        if (commonOptions.getStatusInterval() == 0) {
            return;
        }
        try {
            int n = this.pgStream.getSocket().getSoTimeout();
            int n2 = n > 0 ? Math.min(n, commonOptions.getStatusInterval()) : commonOptions.getStatusInterval();
            this.pgStream.getSocket().setSoTimeout(n2);
            this.pgStream.setMinStreamAvailableCheckDelay(0);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("The connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)iOException);
        }
    }
}

