/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.geometric;

import com.hm.postgresql.geometric.PGpoint;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PGtokenizer;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGpath
extends PGobject
implements Serializable,
Cloneable {
    public boolean open;
    public PGpoint @Nullable [] points;

    public PGpath(PGpoint @Nullable [] pGpointArray, boolean bl) {
        this();
        this.points = pGpointArray;
        this.open = bl;
    }

    public PGpath() {
        this.type = "path";
    }

    public PGpath(String string) {
        this();
        this.setValue(string);
    }

    @Override
    public void setValue(@Nullable String string) {
        if (string == null) {
            this.points = null;
            return;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            this.open = true;
            string = PGtokenizer.removeBox(string);
        } else if (string.startsWith("(") && string.endsWith(")")) {
            this.open = false;
            string = PGtokenizer.removePara(string);
        } else {
            throw new PSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", string), PSQLState.DATA_TYPE_MISMATCH);
        }
        PGtokenizer pGtokenizer = new PGtokenizer(string, ',');
        int n = pGtokenizer.getSize();
        PGpoint[] pGpointArray = new PGpoint[n];
        this.points = pGpointArray;
        for (int i = 0; i < n; ++i) {
            pGpointArray[i] = new PGpoint(pGtokenizer.getToken(i));
        }
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof PGpath) {
            PGpath pGpath = (PGpath)object;
            PGpoint[] pGpointArray = this.points;
            PGpoint[] pGpointArray2 = pGpath.points;
            if (pGpointArray == null) {
                return pGpointArray2 == null;
            }
            if (pGpointArray2 == null) {
                return false;
            }
            if (pGpath.open != this.open) {
                return false;
            }
            if (pGpointArray2.length != pGpointArray.length) {
                return false;
            }
            for (int i = 0; i < pGpointArray.length; ++i) {
                if (pGpointArray[i].equals(pGpointArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        PGpoint[] pGpointArray = this.points;
        if (pGpointArray == null) {
            return 0;
        }
        int n = this.open ? 1231 : 1237;
        for (int i = 0; i < pGpointArray.length && i < 5; ++i) {
            n = n * 31 + pGpointArray[i].hashCode();
        }
        return n;
    }

    @Override
    public Object clone() {
        PGpath pGpath = (PGpath)super.clone();
        if (pGpath.points != null) {
            PGpoint[] pGpointArray = (PGpoint[])pGpath.points.clone();
            pGpath.points = pGpointArray;
            for (int i = 0; i < pGpath.points.length; ++i) {
                pGpointArray[i] = (PGpoint)pGpath.points[i].clone();
            }
        }
        return pGpath;
    }

    @Override
    public @Nullable String getValue() {
        PGpoint[] pGpointArray = this.points;
        if (pGpointArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.open ? "[" : "(");
        for (int i = 0; i < pGpointArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(pGpointArray[i].toString());
        }
        stringBuilder.append(this.open ? "]" : ")");
        return stringBuilder.toString();
    }

    public boolean isOpen() {
        return this.open && this.points != null;
    }

    public boolean isClosed() {
        return !this.open && this.points != null;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

