/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.geometric;

import com.hm.postgresql.geometric.PGpoint;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PGtokenizer;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint @Nullable [] points;

    public PGpolygon(PGpoint[] pGpointArray) {
        this();
        this.points = pGpointArray;
    }

    public PGpolygon(String string) {
        this();
        this.setValue(string);
    }

    public PGpolygon() {
        this.type = "polygon";
    }

    @Override
    public void setValue(@Nullable String string) {
        if (string == null) {
            this.points = null;
            return;
        }
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara(string), ',');
        int n = pGtokenizer.getSize();
        PGpoint[] pGpointArray = this.points;
        if (pGpointArray == null || pGpointArray.length != n) {
            this.points = pGpointArray = new PGpoint[n];
        }
        for (int i = 0; i < n; ++i) {
            pGpointArray[i] = new PGpoint(pGtokenizer.getToken(i));
        }
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof PGpolygon) {
            PGpolygon pGpolygon = (PGpolygon)object;
            PGpoint[] pGpointArray = this.points;
            PGpoint[] pGpointArray2 = pGpolygon.points;
            if (pGpointArray == null) {
                return pGpointArray2 == null;
            }
            if (pGpointArray2 == null) {
                return false;
            }
            if (pGpointArray2.length != pGpointArray.length) {
                return false;
            }
            for (int i = 0; i < pGpointArray.length; ++i) {
                if (pGpointArray[i].equals(pGpointArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        PGpoint[] pGpointArray = this.points;
        if (pGpointArray == null) {
            return n;
        }
        for (int i = 0; i < pGpointArray.length && i < 5; ++i) {
            n = n * 31 + pGpointArray[i].hashCode();
        }
        return n;
    }

    @Override
    public Object clone() {
        PGpolygon pGpolygon = (PGpolygon)super.clone();
        if (pGpolygon.points != null) {
            PGpoint[] pGpointArray = (PGpoint[])pGpolygon.points.clone();
            pGpolygon.points = pGpointArray;
            for (int i = 0; i < pGpolygon.points.length; ++i) {
                if (pGpolygon.points[i] == null) continue;
                pGpointArray[i] = (PGpoint)pGpolygon.points[i].clone();
            }
        }
        return pGpolygon;
    }

    @Override
    public @Nullable String getValue() {
        PGpoint[] pGpointArray = this.points;
        if (pGpointArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < pGpointArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(pGpointArray[i].toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

