/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.gss;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GSSCallbackHandler
implements CallbackHandler {
    private final String user;
    private final @Nullable String password;

    public GSSCallbackHandler(String string, @Nullable String string2) {
        this.user = string;
        this.password = string2;
    }

    @Override
    public void handle(Callback[] callbackArray) {
        for (Callback callback : callbackArray) {
            Callback callback2;
            if (callback instanceof TextOutputCallback) {
                callback2 = (TextOutputCallback)callback;
                switch (((TextOutputCallback)callback2).getMessageType()) {
                    case 0: {
                        System.out.println("INFO: " + ((TextOutputCallback)callback2).getMessage());
                        break;
                    }
                    case 2: {
                        System.out.println("ERROR: " + ((TextOutputCallback)callback2).getMessage());
                        break;
                    }
                    case 1: {
                        System.out.println("WARNING: " + ((TextOutputCallback)callback2).getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + ((TextOutputCallback)callback2).getMessageType());
                    }
                }
                continue;
            }
            if (callback instanceof NameCallback) {
                callback2 = (NameCallback)callback;
                ((NameCallback)callback2).setName(this.user);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                callback2 = (PasswordCallback)callback;
                if (this.password == null) {
                    throw new IOException("No cached kerberos ticket found and no password supplied.");
                }
                ((PasswordCallback)callback2).setPassword(this.password.toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }
}

