/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.gss;

import com.hm.postgresql.util.internal.Nullness;
import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class GSSInputStream
extends InputStream {
    private GSSContext gssContext;
    private MessageProp messageProp;
    private InputStream wrapped;
    byte @Nullable [] unencrypted;
    int unencryptedPos;
    int unencryptedLength;

    public GSSInputStream(InputStream inputStream, GSSContext gSSContext, MessageProp messageProp) {
        this.wrapped = inputStream;
        this.gssContext = gSSContext;
        this.messageProp = messageProp;
    }

    @Override
    public int read() {
        return 0;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[4];
        int n3 = 0;
        if (this.unencryptedLength > 0) {
            n3 = Math.min(n2, this.unencryptedLength);
            System.arraycopy(Nullness.castNonNull(this.unencrypted), this.unencryptedPos, byArray, n, n3);
            this.unencryptedLength -= n3;
            this.unencryptedPos += n3;
        } else if (this.wrapped.read(byArray2, 0, 4) == 4) {
            int n4 = (byArray2[0] & 0xFF) << 24 | (byArray2[1] & 0xFF) << 16 | (byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF;
            byte[] byArray3 = new byte[n4];
            this.wrapped.read(byArray3, 0, n4);
            try {
                byte[] byArray4 = this.gssContext.unwrap(byArray3, 0, n4, this.messageProp);
                this.unencrypted = byArray4;
                this.unencryptedLength = byArray4.length;
                this.unencryptedPos = 0;
                n3 = Math.min(n2, byArray4.length);
                System.arraycopy(byArray4, this.unencryptedPos, byArray, n, n3);
                this.unencryptedLength -= n3;
                this.unencryptedPos += n3;
            }
            catch (GSSException gSSException) {
                throw new IOException(gSSException);
            }
            return n3;
        }
        return n3;
    }
}

