/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.gss;

import com.hm.postgresql.core.PGStream;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.ServerErrorMessage;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GssAction
implements PrivilegedAction<Exception> {
    private static final Logger LOGGER = Logger.getLogger(GssAction.class.getName());
    private final PGStream pgStream;
    private final String host;
    private final String user;
    private final String kerberosServerName;
    private final boolean useSpnego;
    private final @Nullable GSSCredential clientCredentials;
    private final boolean logServerErrorDetail;

    GssAction(PGStream pGStream, @Nullable GSSCredential gSSCredential, String string, String string2, String string3, boolean bl, boolean bl2) {
        this.pgStream = pGStream;
        this.clientCredentials = gSSCredential;
        this.host = string;
        this.user = string2;
        this.kerberosServerName = string3;
        this.useSpnego = bl;
        this.logServerErrorDetail = bl2;
    }

    private static boolean hasSpnegoSupport(GSSManager gSSManager) {
        Oid[] oidArray;
        Oid oid = new Oid("1.3.6.1.5.5.2");
        for (Oid oid2 : oidArray = gSSManager.getMechs()) {
            if (!oid2.equals(oid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable Exception run() {
        try {
            GSSName gSSName;
            GSSManager gSSManager = GSSManager.getInstance();
            GSSCredential gSSCredential = null;
            Oid[] oidArray = new Oid[1];
            if (this.clientCredentials == null) {
                oidArray[0] = this.useSpnego && GssAction.hasSpnegoSupport(gSSManager) ? new Oid("1.3.6.1.5.5.2") : new Oid("1.2.840.113554.1.2.2");
                gSSName = gSSManager.createName(this.user, GSSName.NT_USER_NAME);
                gSSCredential = gSSManager.createCredential(gSSName, 28800, oidArray, 1);
            } else {
                oidArray[0] = new Oid("1.2.840.113554.1.2.2");
                gSSCredential = this.clientCredentials;
            }
            gSSName = gSSManager.createName(this.kerberosServerName + "@" + this.host, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext gSSContext = gSSManager.createContext(gSSName, oidArray[0], gSSCredential, 0);
            gSSContext.requestMutualAuth(true);
            byte[] byArray = new byte[]{};
            byte[] byArray2 = null;
            boolean bl = false;
            block7: while (!bl) {
                byArray2 = gSSContext.initSecContext(byArray, 0, byArray.length);
                if (byArray2 != null) {
                    LOGGER.log(Level.FINEST, " FE=> Password(GSS Authentication Token)");
                    this.pgStream.sendChar(112);
                    this.pgStream.sendInteger4(4 + byArray2.length);
                    this.pgStream.send(byArray2);
                    this.pgStream.flush();
                }
                if (!gSSContext.isEstablished()) {
                    int n = this.pgStream.receiveChar();
                    switch (n) {
                        case 69: {
                            int n2 = this.pgStream.receiveInteger4();
                            ServerErrorMessage serverErrorMessage = new ServerErrorMessage(this.pgStream.receiveErrorString(n2 - 4));
                            LOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", serverErrorMessage);
                            return new PSQLException(serverErrorMessage, this.logServerErrorDetail);
                        }
                        case 82: {
                            LOGGER.log(Level.FINEST, " <=BE AuthenticationGSSContinue");
                            int n3 = this.pgStream.receiveInteger4();
                            int n4 = this.pgStream.receiveInteger4();
                            byArray = this.pgStream.receive(n3 - 8);
                            continue block7;
                        }
                    }
                    return new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
            return iOException;
        }
        catch (GSSException gSSException) {
            return new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)gSSException);
        }
        return null;
    }
}

