/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.hostchooser;

import com.hm.postgresql.hostchooser.HostRequirement;
import com.hm.postgresql.hostchooser.HostStatus;
import com.hm.postgresql.util.HostSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GlobalHostStatusTracker {
    private static final Map<HostSpec, HostSpecStatus> hostStatusMap = new HashMap<HostSpec, HostSpecStatus>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportHostStatus(HostSpec hostSpec, HostStatus hostStatus) {
        long l = System.nanoTime() / 1000000L;
        Map<HostSpec, HostSpecStatus> map = hostStatusMap;
        synchronized (map) {
            HostSpecStatus hostSpecStatus = hostStatusMap.get(hostSpec);
            if (hostSpecStatus == null) {
                hostSpecStatus = new HostSpecStatus(hostSpec);
                hostStatusMap.put(hostSpec, hostSpecStatus);
            }
            hostSpecStatus.status = hostStatus;
            hostSpecStatus.lastUpdated = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<HostSpec> getCandidateHosts(HostSpec[] hostSpecArray, HostRequirement hostRequirement, long l) {
        ArrayList<HostSpec> arrayList = new ArrayList<HostSpec>(hostSpecArray.length);
        long l2 = System.nanoTime() / 1000000L - l;
        Map<HostSpec, HostSpecStatus> map = hostStatusMap;
        synchronized (map) {
            for (HostSpec hostSpec : hostSpecArray) {
                HostSpecStatus hostSpecStatus = hostStatusMap.get(hostSpec);
                if (hostSpecStatus != null && hostSpecStatus.lastUpdated >= l2 && !hostRequirement.allowConnectingTo(hostSpecStatus.status)) continue;
                arrayList.add(hostSpec);
            }
        }
        return arrayList;
    }

    static class HostSpecStatus {
        final HostSpec host;
        @Nullable HostStatus status;
        long lastUpdated;

        HostSpecStatus(HostSpec hostSpec) {
            this.host = hostSpec;
        }

        public String toString() {
            return this.host.toString() + '=' + (Object)((Object)this.status);
        }
    }
}

