/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.hostchooser;

import com.hm.postgresql.hostchooser.HostStatus;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum HostRequirement {
    any{

        @Override
        public boolean allowConnectingTo(@Nullable HostStatus hostStatus) {
            return hostStatus != HostStatus.ConnectFail;
        }
    }
    ,
    master{

        @Override
        public boolean allowConnectingTo(@Nullable HostStatus hostStatus) {
            return primary.allowConnectingTo(hostStatus);
        }
    }
    ,
    primary{

        @Override
        public boolean allowConnectingTo(@Nullable HostStatus hostStatus) {
            return hostStatus == HostStatus.Primary || hostStatus == HostStatus.ConnectOK;
        }
    }
    ,
    secondary{

        @Override
        public boolean allowConnectingTo(@Nullable HostStatus hostStatus) {
            return hostStatus == HostStatus.Secondary || hostStatus == HostStatus.ConnectOK;
        }
    }
    ,
    preferSecondary{

        @Override
        public boolean allowConnectingTo(@Nullable HostStatus hostStatus) {
            return hostStatus != HostStatus.ConnectFail;
        }
    };


    public abstract boolean allowConnectingTo(@Nullable HostStatus var1);

    public static HostRequirement getTargetServerType(String string) {
        String string2 = string.replace("lave", "econdary").replace("master", "primary");
        return HostRequirement.valueOf(string2);
    }
}

