/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.ParameterList;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.ResultCursor;
import com.hm.postgresql.core.ResultHandlerBase;
import com.hm.postgresql.core.Tuple;
import com.hm.postgresql.core.v3.BatchedQuery;
import com.hm.postgresql.jdbc.PgResultSet;
import com.hm.postgresql.jdbc.PgStatement;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BatchResultHandler
extends ResultHandlerBase {
    private final PgStatement pgStatement;
    private int resultIndex = 0;
    private final Query[] queries;
    private final long[] longUpdateCounts;
    private final @Nullable ParameterList @Nullable [] parameterLists;
    private final boolean expectGeneratedKeys;
    private @Nullable PgResultSet generatedKeys;
    private int committedRows;
    private final @Nullable List<List<Tuple>> allGeneratedRows;
    private @Nullable List<Tuple> latestGeneratedRows;
    private @Nullable PgResultSet latestGeneratedKeysRs;

    BatchResultHandler(PgStatement pgStatement, Query[] queryArray, @Nullable ParameterList @Nullable [] parameterListArray, boolean bl) {
        this.pgStatement = pgStatement;
        this.queries = queryArray;
        this.parameterLists = parameterListArray;
        this.longUpdateCounts = new long[queryArray.length];
        this.expectGeneratedKeys = bl;
        this.allGeneratedRows = !bl ? null : new ArrayList();
    }

    @Override
    public void handleResultRows(Query query, Field[] fieldArray, List<Tuple> list, @Nullable ResultCursor resultCursor) {
        ++this.resultIndex;
        if (!this.expectGeneratedKeys) {
            return;
        }
        if (this.generatedKeys == null) {
            try {
                this.latestGeneratedKeysRs = (PgResultSet)this.pgStatement.createResultSet(query, fieldArray, new ArrayList<Tuple>(), resultCursor);
            }
            catch (SQLException sQLException) {
                this.handleError(sQLException);
            }
        }
        this.latestGeneratedRows = list;
    }

    @Override
    public void handleCommandStatus(String string, long l, long l2) {
        List<Tuple> list = this.latestGeneratedRows;
        if (list != null) {
            --this.resultIndex;
            if (l > 0L && (this.getException() == null || this.isAutoCommit())) {
                List<List<Tuple>> list2 = Nullness.castNonNull(this.allGeneratedRows, "allGeneratedRows");
                list2.add(list);
                if (this.generatedKeys == null) {
                    this.generatedKeys = this.latestGeneratedKeysRs;
                }
            }
            this.latestGeneratedRows = null;
        }
        if (this.resultIndex >= this.queries.length) {
            this.handleError(new PSQLException(GT.tr("Too many update results were returned.", new Object[0]), PSQLState.TOO_MANY_RESULTS));
            return;
        }
        this.latestGeneratedKeysRs = null;
        this.longUpdateCounts[this.resultIndex++] = l;
    }

    private boolean isAutoCommit() {
        try {
            return this.pgStatement.getConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            assert (false) : "pgStatement.getConnection().getAutoCommit() should not throw";
            return false;
        }
    }

    @Override
    public void secureProgress() {
        if (this.isAutoCommit()) {
            this.committedRows = this.resultIndex;
            this.updateGeneratedKeys();
        }
    }

    private void updateGeneratedKeys() {
        List<List<Tuple>> list = this.allGeneratedRows;
        if (list == null || list.isEmpty()) {
            return;
        }
        PgResultSet pgResultSet = Nullness.castNonNull(this.generatedKeys, "generatedKeys");
        for (List<Tuple> list2 : list) {
            pgResultSet.addRows(list2);
        }
        list.clear();
    }

    @Override
    public void handleWarning(SQLWarning sQLWarning) {
        this.pgStatement.addWarning(sQLWarning);
    }

    @Override
    public void handleError(SQLException sQLException) {
        if (this.getException() == null) {
            Arrays.fill(this.longUpdateCounts, this.committedRows, this.longUpdateCounts.length, -3L);
            if (this.allGeneratedRows != null) {
                this.allGeneratedRows.clear();
            }
            String string = "<unknown>";
            if (this.pgStatement.getPGConnection().getLogServerErrorDetail() && this.resultIndex < this.queries.length) {
                string = this.queries[this.resultIndex].toString(this.parameterLists == null ? null : this.parameterLists[this.resultIndex]);
            }
            BatchUpdateException batchUpdateException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted: {2}  Call getNextException to see other errors in the batch.", this.resultIndex, string, sQLException.getMessage()), sQLException.getSQLState(), 0, this.uncompressLongUpdateCount(), (Throwable)sQLException);
            super.handleError(batchUpdateException);
        }
        ++this.resultIndex;
        super.handleError(sQLException);
    }

    @Override
    public void handleCompletion() {
        this.updateGeneratedKeys();
        SQLException sQLException = this.getException();
        if (sQLException != null) {
            if (this.isAutoCommit()) {
                BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), 0, this.uncompressLongUpdateCount(), sQLException.getCause());
                SQLException sQLException2 = sQLException.getNextException();
                if (sQLException2 != null) {
                    batchUpdateException.setNextException(sQLException2);
                }
                sQLException = batchUpdateException;
            }
            throw sQLException;
        }
    }

    public @Nullable ResultSet getGeneratedKeys() {
        return this.generatedKeys;
    }

    private int[] uncompressUpdateCount() {
        long[] lArray = this.uncompressLongUpdateCount();
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = lArray[i] > Integer.MAX_VALUE ? -2 : (int)lArray[i];
        }
        return nArray;
    }

    public int[] getUpdateCount() {
        return this.uncompressUpdateCount();
    }

    private long[] uncompressLongUpdateCount() {
        int n;
        if (!(this.queries[0] instanceof BatchedQuery)) {
            return this.longUpdateCounts;
        }
        int n2 = 0;
        boolean bl = false;
        for (Query query : this.queries) {
            n = query.getBatchSize();
            n2 += n;
            bl |= n > 1;
        }
        if (!bl) {
            return this.longUpdateCounts;
        }
        long[] lArray = new long[n2];
        int n3 = 0;
        for (int i = 0; i < this.queries.length; ++i) {
            Query query;
            query = this.queries[i];
            n = query.getBatchSize();
            long l = this.longUpdateCounts[i];
            if (n == 1) {
                lArray[n3++] = l;
                continue;
            }
            if (l > 0L) {
                l = -2L;
            }
            Arrays.fill(lArray, n3, n3 + n, l);
            n3 += n;
        }
        return lArray;
    }

    public long[] getLargeUpdateCount() {
        return this.uncompressLongUpdateCount();
    }
}

