/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.util.logging.Level;
import java.util.logging.Logger;

class BooleanTypeUtil {
    private static final Logger LOGGER = Logger.getLogger(BooleanTypeUtil.class.getName());

    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object object) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cast to boolean: \"{0}\"", String.valueOf(object));
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return BooleanTypeUtil.fromString((String)object);
        }
        if (object instanceof Character) {
            return BooleanTypeUtil.fromCharacter((Character)object);
        }
        if (object instanceof Number) {
            return BooleanTypeUtil.fromNumber((Number)object);
        }
        throw new PSQLException("Cannot cast to boolean", PSQLState.CANNOT_COERCE);
    }

    static boolean fromString(String string) {
        String string2 = string.trim();
        if ("1".equals(string2) || "true".equalsIgnoreCase(string2) || "t".equalsIgnoreCase(string2) || "yes".equalsIgnoreCase(string2) || "y".equalsIgnoreCase(string2) || "on".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("0".equals(string2) || "false".equalsIgnoreCase(string2) || "f".equalsIgnoreCase(string2) || "no".equalsIgnoreCase(string2) || "n".equalsIgnoreCase(string2) || "off".equalsIgnoreCase(string2)) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(string);
    }

    private static boolean fromCharacter(Character c) {
        if ('1' == c.charValue() || 't' == c.charValue() || 'T' == c.charValue() || 'y' == c.charValue() || 'Y' == c.charValue()) {
            return true;
        }
        if ('0' == c.charValue() || 'f' == c.charValue() || 'F' == c.charValue() || 'n' == c.charValue() || 'N' == c.charValue()) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(c);
    }

    private static boolean fromNumber(Number number) {
        double d = number.doubleValue();
        if (d == 1.0) {
            return true;
        }
        if (d == 0.0) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(number);
    }

    private static PSQLException cannotCoerceException(Object object) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Cannot cast to boolean: \"{0}\"", String.valueOf(object));
        }
        return new PSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(object)), PSQLState.CANNOT_COERCE);
    }
}

