/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EscapedFunctions2 {
    private static final String SQL_TSI_ROOT = "SQL_TSI_";
    private static final String SQL_TSI_DAY = "SQL_TSI_DAY";
    private static final String SQL_TSI_FRAC_SECOND = "SQL_TSI_FRAC_SECOND";
    private static final String SQL_TSI_HOUR = "SQL_TSI_HOUR";
    private static final String SQL_TSI_MINUTE = "SQL_TSI_MINUTE";
    private static final String SQL_TSI_MONTH = "SQL_TSI_MONTH";
    private static final String SQL_TSI_QUARTER = "SQL_TSI_QUARTER";
    private static final String SQL_TSI_SECOND = "SQL_TSI_SECOND";
    private static final String SQL_TSI_WEEK = "SQL_TSI_WEEK";
    private static final String SQL_TSI_YEAR = "SQL_TSI_YEAR";
    private static final ConcurrentMap<String, Method> FUNCTION_MAP = EscapedFunctions2.createFunctionMap("sql");

    private static ConcurrentMap<String, Method> createFunctionMap(String string) {
        Method[] methodArray = EscapedFunctions2.class.getMethods();
        ConcurrentHashMap<String, Method> concurrentHashMap = new ConcurrentHashMap<String, Method>(methodArray.length * 2);
        for (Method method : methodArray) {
            if (!method.getName().startsWith(string)) continue;
            concurrentHashMap.put(method.getName().substring(string.length()).toLowerCase(Locale.US), method);
        }
        return concurrentHashMap;
    }

    public static @Nullable Method getFunction(String string) {
        Method method = (Method)FUNCTION_MAP.get(string);
        if (method != null) {
            return method;
        }
        String string2 = string.toLowerCase(Locale.US);
        if (string2.equals(string)) {
            return null;
        }
        method = (Method)FUNCTION_MAP.get(string2);
        if (method != null && FUNCTION_MAP.size() < 1000) {
            FUNCTION_MAP.putIfAbsent(string, method);
        }
        return method;
    }

    public static void sqlceiling(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "ceil(", "ceiling", list);
    }

    public static void sqllog(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "ln(", "log", list);
    }

    public static void sqllog10(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "log(", "log10", list);
    }

    public static void sqlpower(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.twoArgumentsFunctionCall(stringBuilder, "pow(", "power", list);
    }

    public static void sqltruncate(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.twoArgumentsFunctionCall(stringBuilder, "trunc(", "truncate", list);
    }

    public static void sqlchar(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "chr(", "char", list);
    }

    public static void sqlconcat(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.appendCall(stringBuilder, "(", "||", ")", list);
    }

    public static void sqlinsert(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 4) {
            throw new PSQLException(GT.tr("{0} function takes four and only four argument.", "insert"), PSQLState.SYNTAX_ERROR);
        }
        stringBuilder.append("overlay(");
        stringBuilder.append(list.get(0)).append(" placing ").append(list.get(3));
        stringBuilder.append(" from ").append(list.get(1)).append(" for ").append(list.get(2));
        stringBuilder.append(')');
    }

    public static void sqllcase(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "lower(", "lcase", list);
    }

    public static void sqlleft(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", "left"), PSQLState.SYNTAX_ERROR);
        }
        EscapedFunctions2.appendCall(stringBuilder, "substring(", " for ", ")", list);
    }

    public static void sqllength(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", "length"), PSQLState.SYNTAX_ERROR);
        }
        EscapedFunctions2.appendCall(stringBuilder, "length(trim(trailing from ", "", "))", list);
    }

    public static void sqllocate(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() == 2) {
            EscapedFunctions2.appendCall(stringBuilder, "position(", " in ", ")", list);
        } else if (list.size() == 3) {
            String string = "position(" + list.get(0) + " in substring(" + list.get(1) + " from " + list.get(2) + "))";
            stringBuilder.append("(").append(list.get(2)).append("*sign(").append(string).append(")+").append(string).append(")");
        } else {
            throw new PSQLException(GT.tr("{0} function takes two or three arguments.", "locate"), PSQLState.SYNTAX_ERROR);
        }
    }

    public static void sqlltrim(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "trim(leading from ", "ltrim", list);
    }

    public static void sqlright(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", "right"), PSQLState.SYNTAX_ERROR);
        }
        stringBuilder.append("substring(");
        stringBuilder.append(list.get(0)).append(" from (length(").append(list.get(0)).append(")+1-").append(list.get(1));
        stringBuilder.append("))");
    }

    public static void sqlrtrim(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "trim(trailing from ", "rtrim", list);
    }

    public static void sqlspace(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "repeat(' ',", "space", list);
    }

    public static void sqlsubstring(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        int n = list.size();
        if (n != 2 && n != 3) {
            throw new PSQLException(GT.tr("{0} function takes two or three arguments.", "substring"), PSQLState.SYNTAX_ERROR);
        }
        EscapedFunctions2.appendCall(stringBuilder, "substr(", ",", ")", list);
    }

    public static void sqlucase(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "upper(", "ucase", list);
    }

    public static void sqlcurdate(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.zeroArgumentFunctionCall(stringBuilder, "current_date", "curdate", list);
    }

    public static void sqlcurtime(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.zeroArgumentFunctionCall(stringBuilder, "current_time", "curtime", list);
    }

    public static void sqldayname(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", "dayname"), PSQLState.SYNTAX_ERROR);
        }
        EscapedFunctions2.appendCall(stringBuilder, "to_char(", ",", ",'Day')", list);
    }

    public static void sqldayofmonth(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(day from ", "dayofmonth", list);
    }

    public static void sqldayofweek(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", "dayofweek"), PSQLState.SYNTAX_ERROR);
        }
        EscapedFunctions2.appendCall(stringBuilder, "extract(dow from ", ",", ")+1", list);
    }

    public static void sqldayofyear(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(doy from ", "dayofyear", list);
    }

    public static void sqlhour(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(hour from ", "hour", list);
    }

    public static void sqlminute(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(minute from ", "minute", list);
    }

    public static void sqlmonth(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(month from ", "month", list);
    }

    public static void sqlmonthname(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", "monthname"), PSQLState.SYNTAX_ERROR);
        }
        EscapedFunctions2.appendCall(stringBuilder, "to_char(", ",", ",'Month')", list);
    }

    public static void sqlquarter(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(quarter from ", "quarter", list);
    }

    public static void sqlsecond(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(second from ", "second", list);
    }

    public static void sqlweek(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(week from ", "week", list);
    }

    public static void sqlyear(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.singleArgumentFunctionCall(stringBuilder, "extract(year from ", "year", list);
    }

    public static void sqltimestampadd(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 3) {
            throw new PSQLException(GT.tr("{0} function takes three and only three arguments.", "timestampadd"), PSQLState.SYNTAX_ERROR);
        }
        stringBuilder.append('(');
        EscapedFunctions2.appendInterval(stringBuilder, list.get(0).toString(), list.get(1).toString());
        stringBuilder.append('+').append(list.get(2)).append(')');
    }

    private static void appendInterval(StringBuilder stringBuilder, String string, String string2) {
        if (!EscapedFunctions2.isTsi(string)) {
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", string), PSQLState.SYNTAX_ERROR);
        }
        if (EscapedFunctions2.appendSingleIntervalCast(stringBuilder, SQL_TSI_DAY, string, string2, "day") || EscapedFunctions2.appendSingleIntervalCast(stringBuilder, SQL_TSI_SECOND, string, string2, "second") || EscapedFunctions2.appendSingleIntervalCast(stringBuilder, SQL_TSI_HOUR, string, string2, "hour") || EscapedFunctions2.appendSingleIntervalCast(stringBuilder, SQL_TSI_MINUTE, string, string2, "minute") || EscapedFunctions2.appendSingleIntervalCast(stringBuilder, SQL_TSI_MONTH, string, string2, "month") || EscapedFunctions2.appendSingleIntervalCast(stringBuilder, SQL_TSI_WEEK, string, string2, "week") || EscapedFunctions2.appendSingleIntervalCast(stringBuilder, SQL_TSI_YEAR, string, string2, "year")) {
            return;
        }
        if (EscapedFunctions2.areSameTsi(SQL_TSI_QUARTER, string)) {
            stringBuilder.append("CAST((").append(string2).append("::int * 3) || ' month' as interval)");
            return;
        }
        throw new PSQLException(GT.tr("Interval {0} not yet implemented", string), PSQLState.NOT_IMPLEMENTED);
    }

    private static boolean appendSingleIntervalCast(StringBuilder stringBuilder, String string, String string2, String string3, String string4) {
        if (!EscapedFunctions2.areSameTsi(string2, string)) {
            return false;
        }
        stringBuilder.ensureCapacity(stringBuilder.length() + 5 + 4 + 14 + string3.length() + string4.length());
        stringBuilder.append("CAST(").append(string3).append("||' ").append(string4).append("' as interval)");
        return true;
    }

    private static boolean areSameTsi(String string, String string2) {
        return string.length() == string2.length() && string2.length() > SQL_TSI_ROOT.length() && string.regionMatches(true, SQL_TSI_ROOT.length(), string2, SQL_TSI_ROOT.length(), string2.length() - SQL_TSI_ROOT.length());
    }

    private static boolean isTsi(String string) {
        return string.regionMatches(true, 0, SQL_TSI_ROOT, 0, SQL_TSI_ROOT.length());
    }

    public static void sqltimestampdiff(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        if (list.size() != 3) {
            throw new PSQLException(GT.tr("{0} function takes three and only three arguments.", "timestampdiff"), PSQLState.SYNTAX_ERROR);
        }
        stringBuilder.append("extract( ").append(EscapedFunctions2.constantToDatePart(stringBuilder, list.get(0).toString())).append(" from (").append(list.get(2)).append("-").append(list.get(1)).append("))");
    }

    private static String constantToDatePart(StringBuilder stringBuilder, String string) {
        if (!EscapedFunctions2.isTsi(string)) {
            throw new PSQLException(GT.tr("Interval {0} not yet implemented", string), PSQLState.SYNTAX_ERROR);
        }
        if (EscapedFunctions2.areSameTsi(SQL_TSI_DAY, string)) {
            return "day";
        }
        if (EscapedFunctions2.areSameTsi(SQL_TSI_SECOND, string)) {
            return "second";
        }
        if (EscapedFunctions2.areSameTsi(SQL_TSI_HOUR, string)) {
            return "hour";
        }
        if (EscapedFunctions2.areSameTsi(SQL_TSI_MINUTE, string)) {
            return "minute";
        }
        throw new PSQLException(GT.tr("Interval {0} not yet implemented", string), PSQLState.SYNTAX_ERROR);
    }

    public static void sqldatabase(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.zeroArgumentFunctionCall(stringBuilder, "current_database()", "database", list);
    }

    public static void sqlifnull(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.twoArgumentsFunctionCall(stringBuilder, "coalesce(", "ifnull", list);
    }

    public static void sqluser(StringBuilder stringBuilder, List<? extends CharSequence> list) {
        EscapedFunctions2.zeroArgumentFunctionCall(stringBuilder, "user", "user", list);
    }

    private static void zeroArgumentFunctionCall(StringBuilder stringBuilder, String string, String string2, List<? extends CharSequence> list) {
        if (!list.isEmpty()) {
            throw new PSQLException(GT.tr("{0} function doesn''t take any argument.", string2), PSQLState.SYNTAX_ERROR);
        }
        stringBuilder.append(string);
    }

    private static void singleArgumentFunctionCall(StringBuilder stringBuilder, String string, String string2, List<? extends CharSequence> list) {
        if (list.size() != 1) {
            throw new PSQLException(GT.tr("{0} function takes one and only one argument.", string2), PSQLState.SYNTAX_ERROR);
        }
        CharSequence charSequence = list.get(0);
        stringBuilder.ensureCapacity(stringBuilder.length() + string.length() + charSequence.length() + 1);
        stringBuilder.append(string).append(charSequence).append(')');
    }

    private static void twoArgumentsFunctionCall(StringBuilder stringBuilder, String string, String string2, List<? extends CharSequence> list) {
        if (list.size() != 2) {
            throw new PSQLException(GT.tr("{0} function takes two and only two arguments.", string2), PSQLState.SYNTAX_ERROR);
        }
        EscapedFunctions2.appendCall(stringBuilder, string, ",", ")", list);
    }

    public static void appendCall(StringBuilder stringBuilder, String string, String string2, String string3, List<? extends CharSequence> list) {
        int n;
        int n2 = string.length();
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            n2 += list.get(n).length();
        }
        stringBuilder.ensureCapacity(stringBuilder.length() + (n2 += string2.length() * (n3 - 1)) + 1);
        stringBuilder.append(string);
        for (n = 0; n < n3; ++n) {
            if (n > 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(list.get(n));
        }
        stringBuilder.append(string3);
    }
}

