/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.core.Utils;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.sql.Savepoint;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PSQLSavepoint
implements Savepoint {
    private boolean isValid = true;
    private final boolean isNamed;
    private int id;
    private @Nullable String name;

    public PSQLSavepoint(int n) {
        this.isNamed = false;
        this.id = n;
    }

    public PSQLSavepoint(String string) {
        this.isNamed = true;
        this.name = string;
    }

    @Override
    public int getSavepointId() {
        if (!this.isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            throw new PSQLException(GT.tr("Cannot retrieve the id of a named savepoint.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this.id;
    }

    @Override
    public String getSavepointName() {
        if (!this.isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (!this.isNamed || this.name == null) {
            throw new PSQLException(GT.tr("Cannot retrieve the name of an unnamed savepoint.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this.name;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public String getPGName() {
        if (!this.isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed && this.name != null) {
            return Utils.escapeIdentifier(null, this.name).toString();
        }
        return "JDBC_SAVEPOINT_" + this.id;
    }
}

