/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.checkerframework.checker.index.qual.Positive;

public class PgParameterMetaData
implements ParameterMetaData {
    private final BaseConnection connection;
    private final int[] oids;

    public PgParameterMetaData(BaseConnection baseConnection, int[] nArray) {
        this.connection = baseConnection;
        this.oids = nArray;
    }

    @Override
    public String getParameterClassName(@Positive int n) {
        this.checkParamIndex(n);
        return this.connection.getTypeInfo().getJavaClass(this.oids[n - 1]);
    }

    @Override
    public int getParameterCount() {
        return this.oids.length;
    }

    @Override
    public int getParameterMode(int n) {
        this.checkParamIndex(n);
        return 1;
    }

    @Override
    public int getParameterType(int n) {
        this.checkParamIndex(n);
        return this.connection.getTypeInfo().getSQLType(this.oids[n - 1]);
    }

    @Override
    public String getParameterTypeName(int n) {
        this.checkParamIndex(n);
        return Nullness.castNonNull(this.connection.getTypeInfo().getPGType(this.oids[n - 1]));
    }

    @Override
    public int getPrecision(int n) {
        this.checkParamIndex(n);
        return 0;
    }

    @Override
    public int getScale(int n) {
        this.checkParamIndex(n);
        return 0;
    }

    @Override
    public int isNullable(int n) {
        this.checkParamIndex(n);
        return 2;
    }

    @Override
    public boolean isSigned(int n) {
        this.checkParamIndex(n);
        return this.connection.getTypeInfo().isSigned(this.oids[n - 1]);
    }

    private void checkParamIndex(int n) {
        if (n < 1 || n > this.oids.length) {
            throw new PSQLException(GT.tr("The parameter index is out of range: {0}, number of parameters: {1}.", n, this.oids.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }
}

