/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.Driver;
import com.hm.postgresql.PGRefCursorResultSet;
import com.hm.postgresql.PGResultSetMetaData;
import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.BaseStatement;
import com.hm.postgresql.core.Encoding;
import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.Oid;
import com.hm.postgresql.core.Query;
import com.hm.postgresql.core.ResultCursor;
import com.hm.postgresql.core.ResultHandlerBase;
import com.hm.postgresql.core.Tuple;
import com.hm.postgresql.core.TypeInfo;
import com.hm.postgresql.core.Utils;
import com.hm.postgresql.jdbc.BooleanTypeUtil;
import com.hm.postgresql.jdbc.PgArray;
import com.hm.postgresql.jdbc.PgBlob;
import com.hm.postgresql.jdbc.PgClob;
import com.hm.postgresql.jdbc.PgDatabaseMetaData;
import com.hm.postgresql.jdbc.PgResultSetMetaData;
import com.hm.postgresql.jdbc.PgSQLXML;
import com.hm.postgresql.jdbc.PgStatement;
import com.hm.postgresql.jdbc.TimestampUtils;
import com.hm.postgresql.util.ByteConverter;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.HStoreConverter;
import com.hm.postgresql.util.JdbcBlackHole;
import com.hm.postgresql.util.PGbytea;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PGtokenizer;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.dataflow.qual.Pure;

public class PgResultSet
implements ResultSet,
PGRefCursorResultSet {
    private boolean updateable = false;
    private boolean doingUpdates = false;
    private @Nullable HashMap<String, Object> updateValues = null;
    private boolean usingOID = false;
    private @Nullable List<PrimaryKey> primaryKeys;
    private boolean singleTable = false;
    private String onlyTable = "";
    private @Nullable String tableName = null;
    private @Nullable PreparedStatement deleteStatement = null;
    private final int resultsettype;
    private final int resultsetconcurrency;
    private int fetchdirection = 1002;
    private @Nullable TimeZone defaultTimeZone;
    protected final BaseConnection connection;
    protected final BaseStatement statement;
    protected final Field[] fields;
    protected final @Nullable Query originalQuery;
    protected final int maxRows;
    protected final int maxFieldSize;
    protected @Nullable List<Tuple> rows;
    protected int currentRow = -1;
    protected int rowOffset;
    protected @Nullable Tuple thisRow;
    protected @Nullable SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected boolean onInsertRow = false;
    private @Nullable Tuple rowBuffer = null;
    protected int fetchSize;
    protected int lastUsedFetchSize;
    protected boolean adaptiveFetch = false;
    protected @Nullable ResultCursor cursor;
    private @Nullable Map<String, Integer> columnNameIndexMap;
    private @Nullable ResultSetMetaData rsMetaData;
    private @Nullable String refCursorName;
    private static final BigInteger BYTEMAX = new BigInteger(Byte.toString((byte)127));
    private static final BigInteger BYTEMIN = new BigInteger(Byte.toString((byte)-128));
    private static final NumberFormatException FAST_NUMBER_FAILED = new NumberFormatException(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private static final BigInteger SHORTMAX = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    private static final BigInteger SHORTMIN = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    private static final BigInteger INTMAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger INTMIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private static final BigInteger LONGMAX = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger LONGMIN = new BigInteger(Long.toString(Long.MIN_VALUE));

    protected ResultSetMetaData createMetaData() {
        return new PgResultSetMetaData(this.connection, this.fields);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        this.checkClosed();
        if (this.rsMetaData == null) {
            this.rsMetaData = this.createMetaData();
        }
        return this.rsMetaData;
    }

    PgResultSet(@Nullable Query query, BaseStatement baseStatement, Field[] fieldArray, List<Tuple> list, @Nullable ResultCursor resultCursor, int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (list == null) {
            throw new NullPointerException("tuples must be non-null");
        }
        if (fieldArray == null) {
            throw new NullPointerException("fields must be non-null");
        }
        this.originalQuery = query;
        this.connection = (BaseConnection)baseStatement.getConnection();
        this.statement = baseStatement;
        this.fields = fieldArray;
        this.rows = list;
        this.cursor = resultCursor;
        this.maxRows = n;
        this.maxFieldSize = n2;
        this.resultsettype = n3;
        this.resultsetconcurrency = n4;
        this.adaptiveFetch = bl;
        this.lastUsedFetchSize = list.size();
    }

    @Override
    public URL getURL(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getURL columnIndex: {0}", n);
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    @Override
    public URL getURL(String string) {
        return this.getURL(this.findColumn(string));
    }

    @RequiresNonNull(value={"thisRow"})
    protected @Nullable Object internalGetObject(@Positive int n, Field field) {
        Nullness.castNonNull(this.thisRow, "thisRow");
        switch (this.getSQLType(n)) {
            case -7: 
            case 16: {
                byte[] byArray;
                if (field.getOID() == 16) {
                    return this.getBoolean(n);
                }
                if (field.getOID() == 1560 && ((byArray = this.getRawValue(n)) == null || byArray.length == 1)) {
                    return this.getBoolean(n);
                }
                return null;
            }
            case 2009: {
                return this.getSQLXML(n);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(n);
            }
            case -5: {
                return this.getLong(n);
            }
            case 2: 
            case 3: {
                return this.getNumeric(n, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF, true);
            }
            case 7: {
                return Float.valueOf(this.getFloat(n));
            }
            case 6: 
            case 8: {
                return this.getDouble(n);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 2003: {
                return this.getArray(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
        }
        String string = this.getPGType(n);
        if (string.equals("unknown")) {
            return this.getString(n);
        }
        if (string.equals("uuid")) {
            if (this.isBinary(n)) {
                return this.getUUID(Nullness.castNonNull(this.thisRow.get(n - 1)));
            }
            return this.getUUID(Nullness.castNonNull(this.getString(n)));
        }
        if (string.equals("refcursor")) {
            String string2 = Nullness.castNonNull(this.getString(n));
            StringBuilder stringBuilder = new StringBuilder("FETCH ALL IN ");
            Utils.escapeIdentifier(stringBuilder, string2);
            ResultSet resultSet = this.connection.execSQLQuery(stringBuilder.toString(), this.resultsettype, 1007);
            stringBuilder.setLength(0);
            stringBuilder.append("CLOSE ");
            Utils.escapeIdentifier(stringBuilder, string2);
            this.connection.execSQLUpdate(stringBuilder.toString());
            ((PgResultSet)resultSet).setRefCursor(string2);
            return resultSet;
        }
        if ("hstore".equals(string)) {
            if (this.isBinary(n)) {
                return HStoreConverter.fromBytes(Nullness.castNonNull(this.thisRow.get(n - 1)), this.connection.getEncoding());
            }
            return HStoreConverter.fromString(Nullness.castNonNull(this.getString(n)));
        }
        return null;
    }

    @Pure
    @EnsuresNonNull(value={"rows"})
    private void checkScrollable() {
        this.checkClosed();
        if (this.resultsettype == 1003) {
            throw new PSQLException(GT.tr("Operation requires a scrollable ResultSet, but this ResultSet is FORWARD_ONLY.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean absolute(int n) {
        int n2;
        this.checkScrollable();
        if (n == 0) {
            this.beforeFirst();
            return false;
        }
        int n3 = this.rows.size();
        if (n < 0) {
            if (n < -n3) {
                this.beforeFirst();
                return false;
            }
            n2 = n3 + n;
        } else {
            if (n > n3) {
                this.afterLast();
                return false;
            }
            n2 = n - 1;
        }
        this.currentRow = n2;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public void afterLast() {
        this.checkScrollable();
        int n = this.rows.size();
        if (n > 0) {
            this.currentRow = n;
        }
        this.onInsertRow = false;
        this.thisRow = null;
        this.rowBuffer = null;
    }

    @Override
    public void beforeFirst() {
        this.checkScrollable();
        if (!this.rows.isEmpty()) {
            this.currentRow = -1;
        }
        this.onInsertRow = false;
        this.thisRow = null;
        this.rowBuffer = null;
    }

    @Override
    public boolean first() {
        this.checkScrollable();
        if (this.rows.size() <= 0) {
            return false;
        }
        this.currentRow = 0;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public @Nullable Array getArray(String string) {
        return this.getArray(this.findColumn(string));
    }

    protected Array makeArray(int n, byte[] byArray) {
        return new PgArray(this.connection, n, byArray);
    }

    protected Array makeArray(int n, String string) {
        return new PgArray(this.connection, n, string);
    }

    @Override
    @Pure
    public @Nullable Array getArray(int n) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        int n2 = this.fields[n - 1].getOID();
        if (this.isBinary(n)) {
            return this.makeArray(n2, byArray);
        }
        return this.makeArray(n2, Nullness.castNonNull(this.getFixedString(n)));
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(@Positive int n) {
        return this.getBigDecimal(n, -1);
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public @Nullable Blob getBlob(String string) {
        return this.getBlob(this.findColumn(string));
    }

    protected Blob makeBlob(long l) {
        return new PgBlob(this.connection, l);
    }

    @Override
    @Pure
    public @Nullable Blob getBlob(int n) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        return this.makeBlob(this.getLong(n));
    }

    @Override
    public @Nullable Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public @Nullable Reader getCharacterStream(int n) {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new CharArrayReader(string.toCharArray());
    }

    @Override
    public @Nullable Clob getClob(String string) {
        return this.getClob(this.findColumn(string));
    }

    protected Clob makeClob(long l) {
        return new PgClob(this.connection, l);
    }

    @Override
    @Pure
    public @Nullable Clob getClob(int n) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        return this.makeClob(this.getLong(n));
    }

    @Override
    public int getConcurrency() {
        this.checkClosed();
        return this.resultsetconcurrency;
    }

    @Override
    public @Nullable java.sql.Date getDate(int n, @Nullable Calendar calendar) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        if (calendar == null) {
            calendar = this.getDefaultCalendar();
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            TimeZone timeZone = calendar.getTimeZone();
            if (n3 == 1082) {
                return this.connection.getTimestampUtils().toDateBin(timeZone, byArray);
            }
            if (n3 == 1114 || n3 == 1184) {
                Timestamp timestamp = Nullness.castNonNull(this.getTimestamp(n, calendar));
                return this.connection.getTimestampUtils().convertToDate(timestamp.getTime(), timeZone);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(n3), "date"), PSQLState.DATA_TYPE_MISMATCH);
        }
        return this.connection.getTimestampUtils().toDate(calendar, Nullness.castNonNull(this.getString(n)));
    }

    @Override
    public @Nullable Time getTime(int n, @Nullable Calendar calendar) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        if (calendar == null) {
            calendar = this.getDefaultCalendar();
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            TimeZone timeZone = calendar.getTimeZone();
            if (n3 == 1083 || n3 == 1266) {
                return this.connection.getTimestampUtils().toTimeBin(timeZone, byArray);
            }
            if (n3 == 1114 || n3 == 1184) {
                Timestamp timestamp = this.getTimestamp(n, calendar);
                if (timestamp == null) {
                    return null;
                }
                long l = timestamp.getTime();
                if (n3 == 1184) {
                    return new Time(l % TimeUnit.DAYS.toMillis(1L));
                }
                return this.connection.getTimestampUtils().convertToTime(l, timeZone);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(n3), "time"), PSQLState.DATA_TYPE_MISMATCH);
        }
        String string = this.getString(n);
        return this.connection.getTimestampUtils().toTime(calendar, string);
    }

    private @Nullable LocalTime getLocalTime(int n) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            if (n3 == 1083) {
                return this.connection.getTimestampUtils().toLocalTimeBin(byArray);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(n3), "time"), PSQLState.DATA_TYPE_MISMATCH);
        }
        String string = this.getString(n);
        return this.connection.getTimestampUtils().toLocalTime(string);
    }

    @Override
    @Pure
    public @Nullable Timestamp getTimestamp(int n, @Nullable Calendar calendar) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        if (calendar == null) {
            calendar = this.getDefaultCalendar();
        }
        int n2 = n - 1;
        int n3 = this.fields[n2].getOID();
        if (this.isBinary(n)) {
            long l;
            if (n3 == 1184 || n3 == 1114) {
                boolean bl = n3 == 1184;
                TimeZone timeZone = calendar.getTimeZone();
                return this.connection.getTimestampUtils().toTimestampBin(timeZone, byArray, bl);
            }
            if (n3 == 1083 || n3 == 1266) {
                Time time = this.getTime(n, calendar);
                if (time == null) {
                    return null;
                }
                l = time.getTime();
            } else if (n3 == 1082) {
                java.sql.Date date = this.getDate(n, calendar);
                if (date == null) {
                    return null;
                }
                l = date.getTime();
            } else {
                throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(n3), "timestamp"), PSQLState.DATA_TYPE_MISMATCH);
            }
            return new Timestamp(l);
        }
        String string = Nullness.castNonNull(this.getString(n));
        if (n3 == 1083 || n3 == 1266) {
            return new Timestamp(this.connection.getTimestampUtils().toTime(calendar, string).getTime());
        }
        return this.connection.getTimestampUtils().toTimestamp(calendar, string);
    }

    private @Nullable OffsetDateTime getOffsetDateTime(int n) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        int n2 = n - 1;
        int n3 = this.fields[n2].getOID();
        if (this.isBinary(n)) {
            if (n3 == 1184 || n3 == 1114) {
                return this.connection.getTimestampUtils().toOffsetDateTimeBin(byArray);
            }
            if (n3 == 1266) {
                Time time = this.getTime(n);
                if (time == null) {
                    return null;
                }
                return this.connection.getTimestampUtils().toOffsetDateTime(time);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(n3), "timestamptz"), PSQLState.DATA_TYPE_MISMATCH);
        }
        String string = Nullness.castNonNull(this.getString(n));
        if (n3 == 1266) {
            Calendar calendar = this.getDefaultCalendar();
            Time time = this.connection.getTimestampUtils().toTime(calendar, string);
            return this.connection.getTimestampUtils().toOffsetDateTime(time);
        }
        return this.connection.getTimestampUtils().toOffsetDateTime(string);
    }

    private @Nullable LocalDateTime getLocalDateTime(int n) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        int n2 = n - 1;
        int n3 = this.fields[n2].getOID();
        if (n3 != 1114) {
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(n3), "timestamp"), PSQLState.DATA_TYPE_MISMATCH);
        }
        if (this.isBinary(n)) {
            return this.connection.getTimestampUtils().toLocalDateTimeBin(byArray);
        }
        String string = Nullness.castNonNull(this.getString(n));
        return this.connection.getTimestampUtils().toLocalDateTime(string);
    }

    @Override
    public @Nullable java.sql.Date getDate(String string, @Nullable Calendar calendar) {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public @Nullable Time getTime(String string, @Nullable Calendar calendar) {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public @Nullable Timestamp getTimestamp(String string, @Nullable Calendar calendar) {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public int getFetchDirection() {
        this.checkClosed();
        return this.fetchdirection;
    }

    public @Nullable Object getObjectImpl(String string, @Nullable Map<String, Class<?>> map) {
        return this.getObjectImpl(this.findColumn(string), map);
    }

    public @Nullable Object getObjectImpl(int n, @Nullable Map<String, Class<?>> map) {
        this.checkClosed();
        if (map == null || map.isEmpty()) {
            return this.getObject(n);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public @Nullable Ref getRef(String string) {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public @Nullable Ref getRef(int n) {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public int getRow() {
        this.checkClosed();
        if (this.onInsertRow) {
            return 0;
        }
        int n = this.rows.size();
        if (this.currentRow < 0 || this.currentRow >= n) {
            return 0;
        }
        return this.rowOffset + this.currentRow + 1;
    }

    @Override
    public Statement getStatement() {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public int getType() {
        this.checkClosed();
        return this.resultsettype;
    }

    @Override
    @Pure
    public boolean isAfterLast() {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        Nullness.castNonNull(this.rows, "rows");
        int n = this.rows.size();
        if (this.rowOffset + n == 0) {
            return false;
        }
        return this.currentRow >= n;
    }

    @Override
    @Pure
    public boolean isBeforeFirst() {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        return this.rowOffset + this.currentRow < 0 && !Nullness.castNonNull(this.rows, "rows").isEmpty();
    }

    @Override
    public boolean isFirst() {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int n = this.rows.size();
        if (this.rowOffset + n == 0) {
            return false;
        }
        return this.rowOffset + this.currentRow == 0;
    }

    @Override
    public boolean isLast() {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        List<Tuple> list = Nullness.castNonNull(this.rows, "rows");
        int n = list.size();
        if (n == 0) {
            return false;
        }
        if (this.currentRow != n - 1) {
            return false;
        }
        ResultCursor resultCursor = this.cursor;
        if (resultCursor == null) {
            return true;
        }
        if (this.maxRows > 0 && this.rowOffset + this.currentRow == this.maxRows) {
            return true;
        }
        this.rowOffset += n - 1;
        int n2 = this.fetchSize;
        int n3 = this.connection.getQueryExecutor().getAdaptiveFetchSize(this.adaptiveFetch, resultCursor);
        if (n3 != -1) {
            n2 = n3;
        }
        if (this.maxRows != 0 && (n2 == 0 || this.rowOffset + n2 > this.maxRows)) {
            n2 = this.maxRows - this.rowOffset;
        }
        this.connection.getQueryExecutor().fetch(resultCursor, new CursorResultHandler(), n2, this.adaptiveFetch);
        this.lastUsedFetchSize = n2;
        list = Nullness.castNonNull(this.rows, "rows");
        list.add(0, Nullness.castNonNull(this.thisRow));
        this.currentRow = 0;
        return list.size() == 1;
    }

    @Override
    public boolean last() {
        this.checkScrollable();
        List<Tuple> list = Nullness.castNonNull(this.rows, "rows");
        int n = list.size();
        if (n <= 0) {
            return false;
        }
        this.currentRow = n - 1;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public boolean previous() {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.currentRow - 1 < 0) {
            this.currentRow = -1;
            this.thisRow = null;
            this.rowBuffer = null;
            return false;
        }
        --this.currentRow;
        this.initRowBuffer();
        return true;
    }

    @Override
    public boolean relative(int n) {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        int n2 = this.currentRow + 1 + n;
        if (n2 < 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(n2);
    }

    @Override
    public void setFetchDirection(int n) {
        this.checkClosed();
        switch (n) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                this.checkScrollable();
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", n), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        this.fetchdirection = n;
    }

    @Override
    public synchronized void cancelRowUpdates() {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call cancelRowUpdates() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer(true);
        }
    }

    @Override
    public synchronized void deleteRow() {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call deleteRow() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst()) {
            throw new PSQLException(GT.tr("Currently positioned before the start of the ResultSet.  You cannot call deleteRow() here.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isAfterLast()) {
            throw new PSQLException(GT.tr("Currently positioned after the end of the ResultSet.  You cannot call deleteRow() here.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        List<Tuple> list = Nullness.castNonNull(this.rows, "rows");
        if (list.isEmpty()) {
            throw new PSQLException(GT.tr("There are no rows in this ResultSet.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        List<PrimaryKey> list2 = Nullness.castNonNull(this.primaryKeys, "primaryKeys");
        int n = list2.size();
        if (this.deleteStatement == null) {
            StringBuilder stringBuilder = new StringBuilder("DELETE FROM ").append(this.onlyTable).append(this.tableName).append(" where ");
            for (int i = 0; i < n; ++i) {
                Utils.escapeIdentifier(stringBuilder, list2.get((int)i).name);
                stringBuilder.append(" = ?");
                if (i >= n - 1) continue;
                stringBuilder.append(" and ");
            }
            this.deleteStatement = this.connection.prepareStatement(stringBuilder.toString());
        }
        this.deleteStatement.clearParameters();
        for (int i = 0; i < n; ++i) {
            this.deleteStatement.setObject(i + 1, list2.get(i).getValue());
        }
        this.deleteStatement.executeUpdate();
        list.remove(this.currentRow);
        --this.currentRow;
        this.moveToCurrentRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertRow() {
        Object object;
        this.checkUpdateable();
        Nullness.castNonNull(this.rows, "rows");
        if (!this.onInsertRow) {
            throw new PSQLException(GT.tr("Not on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        HashMap<String, Object> hashMap = this.updateValues;
        if (hashMap == null || hashMap.isEmpty()) {
            throw new PSQLException(GT.tr("You must specify at least one column value to insert a row.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ").append(this.tableName).append(" (");
        StringBuilder stringBuilder2 = new StringBuilder(") values (");
        Iterator<String> iterator = hashMap.keySet().iterator();
        int n = hashMap.size();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            Utils.escapeIdentifier(stringBuilder, (String)object);
            if (n2 < n - 1) {
                stringBuilder.append(", ");
                stringBuilder2.append("?,");
            } else {
                stringBuilder2.append("?)");
            }
            ++n2;
        }
        stringBuilder.append(stringBuilder2.toString());
        PreparedStatement preparedStatement = null;
        object = Nullness.castNonNull(this.rowBuffer);
        try {
            preparedStatement = this.connection.prepareStatement(stringBuilder.toString(), 1);
            Iterator<Object> iterator2 = hashMap.values().iterator();
            int n3 = 1;
            while (iterator2.hasNext()) {
                preparedStatement.setObject(n3, iterator2.next());
                ++n3;
            }
            preparedStatement.executeUpdate();
            if (this.usingOID) {
                long l = ((PgStatement)((Object)preparedStatement)).getLastOID();
                hashMap.put("oid", l);
            }
            this.updateRowBuffer(preparedStatement, (Tuple)object, Nullness.castNonNull(hashMap));
        }
        catch (Throwable throwable) {
            JdbcBlackHole.close(preparedStatement);
            throw throwable;
        }
        JdbcBlackHole.close(preparedStatement);
        Nullness.castNonNull(this.rows).add((Tuple)object);
        this.thisRow = object;
        this.clearRowBuffer(false);
    }

    @Override
    public synchronized void moveToCurrentRow() {
        this.checkUpdateable();
        Nullness.castNonNull(this.rows, "rows");
        if (this.currentRow < 0 || this.currentRow >= this.rows.size()) {
            this.thisRow = null;
            this.rowBuffer = null;
        } else {
            this.initRowBuffer();
        }
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    @Override
    public synchronized void moveToInsertRow() {
        this.checkUpdateable();
        this.clearRowBuffer(false);
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    private synchronized void clearRowBuffer(boolean bl) {
        this.rowBuffer = bl ? Nullness.castNonNull(this.thisRow, "thisRow").updateableCopy() : new Tuple(this.fields.length);
        HashMap<String, Object> hashMap = this.updateValues;
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    @Override
    public boolean rowDeleted() {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() {
        this.checkClosed();
        return false;
    }

    @Override
    public synchronized void updateAsciiStream(@Positive int n, @Nullable InputStream inputStream, int n2) {
        if (inputStream == null) {
            this.updateNull(n);
            return;
        }
        try {
            int n3;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.US_ASCII);
            char[] cArray = new char[n2];
            int n4 = 0;
            while ((n3 = inputStreamReader.read(cArray, n4, n2 - n4)) != -1 && (n4 += n3) != n2) {
            }
            this.updateString(n, new String(cArray, 0, n4));
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), null, (Throwable)iOException);
        }
    }

    @Override
    public synchronized void updateBigDecimal(@Positive int n, @Nullable BigDecimal bigDecimal) {
        this.updateValue(n, bigDecimal);
    }

    @Override
    public synchronized void updateBinaryStream(@Positive int n, @Nullable InputStream inputStream, int n2) {
        if (inputStream == null) {
            this.updateNull(n);
            return;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            int n4;
            while ((n4 = inputStream.read(byArray, n3, n2 - n3)) != -1 && (n3 += n4) != n2) {
            }
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), null, (Throwable)iOException);
        }
        if (n3 == n2) {
            this.updateBytes(n, byArray);
        } else {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            this.updateBytes(n, byArray2);
        }
    }

    @Override
    public synchronized void updateBoolean(@Positive int n, boolean bl) {
        this.updateValue(n, bl);
    }

    @Override
    public synchronized void updateByte(@Positive int n, byte by) {
        this.updateValue(n, String.valueOf(by));
    }

    @Override
    public synchronized void updateBytes(@Positive int n, byte @Nullable [] byArray) {
        this.updateValue(n, byArray);
    }

    @Override
    public synchronized void updateCharacterStream(@Positive int n, @Nullable Reader reader, int n2) {
        if (reader == null) {
            this.updateNull(n);
            return;
        }
        try {
            int n3;
            char[] cArray = new char[n2];
            int n4 = 0;
            while ((n3 = reader.read(cArray, n4, n2 - n4)) != -1 && (n4 += n3) != n2) {
            }
            this.updateString(n, new String(cArray, 0, n4));
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Provided Reader failed.", new Object[0]), null, (Throwable)iOException);
        }
    }

    @Override
    public synchronized void updateDate(@Positive int n, @Nullable java.sql.Date date) {
        this.updateValue(n, date);
    }

    @Override
    public synchronized void updateDouble(@Positive int n, double d) {
        this.updateValue(n, d);
    }

    @Override
    public synchronized void updateFloat(@Positive int n, float f) {
        this.updateValue(n, Float.valueOf(f));
    }

    @Override
    public synchronized void updateInt(@Positive int n, int n2) {
        this.updateValue(n, n2);
    }

    @Override
    public synchronized void updateLong(@Positive int n, long l) {
        this.updateValue(n, l);
    }

    @Override
    public synchronized void updateNull(@Positive int n) {
        this.checkColumnIndex(n);
        String string = this.getPGType(n);
        this.updateValue(n, new NullObject(string));
    }

    @Override
    public synchronized void updateObject(int n, @Nullable Object object) {
        this.updateValue(n, object);
    }

    @Override
    public synchronized void updateObject(int n, @Nullable Object object, int n2) {
        this.updateObject(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() {
        Object object;
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t refresh the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || Nullness.castNonNull(this.rows, "rows").isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("select ");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        PGResultSetMetaData pGResultSetMetaData = (PGResultSetMetaData)((Object)resultSetMetaData);
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            if (i > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(pGResultSetMetaData.getBaseColumnName(i));
        }
        stringBuilder.append(" from ").append(this.onlyTable).append(this.tableName).append(" where ");
        List<PrimaryKey> list = Nullness.castNonNull(this.primaryKeys, "primaryKeys");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            object = list.get(i);
            stringBuilder.append(((PrimaryKey)object).name).append(" = ?");
            if (i >= n - 1) continue;
            stringBuilder.append(" and ");
        }
        String string = stringBuilder.toString();
        if (this.connection.getLogger().isLoggable(Level.FINE)) {
            this.connection.getLogger().log(Level.FINE, "selecting {0}", string);
        }
        object = null;
        try {
            object = this.connection.prepareStatement(string, 1004, 1008);
            for (int i = 0; i < n; ++i) {
                object.setObject(i + 1, list.get(i).getValue());
            }
            PgResultSet pgResultSet = (PgResultSet)object.executeQuery();
            if (pgResultSet.next()) {
                this.rowBuffer = pgResultSet.thisRow == null ? null : Nullness.castNonNull(pgResultSet.thisRow).updateableCopy();
            }
            Nullness.castNonNull(this.rows).set(this.currentRow, Nullness.castNonNull(this.rowBuffer));
            this.thisRow = this.rowBuffer;
            this.connection.getLogger().log(Level.FINE, "done updates");
            pgResultSet.close();
        }
        finally {
            JdbcBlackHole.close((Statement)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateRow() {
        Object object;
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call updateRow() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        List<Tuple> list = Nullness.castNonNull(this.rows, "rows");
        if (this.isBeforeFirst() || this.isAfterLast() || list.isEmpty()) {
            throw new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the results.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (!this.doingUpdates) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE " + this.onlyTable + this.tableName + " SET  ");
        HashMap<String, Object> hashMap = Nullness.castNonNull(this.updateValues);
        int n = hashMap.size();
        Iterator<String> iterator = hashMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            Utils.escapeIdentifier(stringBuilder, string);
            stringBuilder.append(" = ?");
            if (n2 < n - 1) {
                stringBuilder.append(", ");
            }
            ++n2;
        }
        stringBuilder.append(" WHERE ");
        List<PrimaryKey> list2 = Nullness.castNonNull(this.primaryKeys, "primaryKeys");
        int n3 = list2.size();
        for (int i = 0; i < n3; ++i) {
            object = list2.get(i);
            Utils.escapeIdentifier(stringBuilder, ((PrimaryKey)object).name);
            stringBuilder.append(" = ?");
            if (i >= n3 - 1) continue;
            stringBuilder.append(" and ");
        }
        String string = stringBuilder.toString();
        if (this.connection.getLogger().isLoggable(Level.FINE)) {
            this.connection.getLogger().log(Level.FINE, "updating {0}", string);
        }
        object = null;
        try {
            object = this.connection.prepareStatement(string);
            int n4 = 0;
            for (Object object2 : hashMap.values()) {
                object.setObject(n4 + 1, object2);
                ++n4;
            }
            int n5 = 0;
            while (n5 < n3) {
                object.setObject(n4 + 1, list2.get(n5).getValue());
                ++n5;
                ++n4;
            }
            object.executeUpdate();
        }
        finally {
            JdbcBlackHole.close((Statement)object);
        }
        Tuple tuple = Nullness.castNonNull(this.rowBuffer, "rowBuffer");
        this.updateRowBuffer(null, tuple, hashMap);
        this.connection.getLogger().log(Level.FINE, "copying data");
        this.thisRow = tuple.readOnlyCopy();
        list.set(this.currentRow, tuple);
        this.connection.getLogger().log(Level.FINE, "done updates");
        hashMap.clear();
        this.doingUpdates = false;
    }

    @Override
    public synchronized void updateShort(@Positive int n, short s) {
        this.updateValue(n, s);
    }

    @Override
    public synchronized void updateString(@Positive int n, @Nullable String string) {
        this.updateValue(n, string);
    }

    @Override
    public synchronized void updateTime(@Positive int n, @Nullable Time time) {
        this.updateValue(n, time);
    }

    @Override
    public synchronized void updateTimestamp(int n, @Nullable Timestamp timestamp) {
        this.updateValue(n, timestamp);
    }

    @Override
    public synchronized void updateNull(String string) {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public synchronized void updateBoolean(String string, boolean bl) {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public synchronized void updateByte(String string, byte by) {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public synchronized void updateShort(String string, short s) {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public synchronized void updateInt(String string, int n) {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public synchronized void updateLong(String string, long l) {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public synchronized void updateFloat(String string, float f) {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public synchronized void updateDouble(String string, double d) {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public synchronized void updateBigDecimal(String string, @Nullable BigDecimal bigDecimal) {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public synchronized void updateString(String string, @Nullable String string2) {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public synchronized void updateBytes(String string, byte @Nullable [] byArray) {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public synchronized void updateDate(String string, @Nullable java.sql.Date date) {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public synchronized void updateTime(String string, @Nullable Time time) {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public synchronized void updateTimestamp(String string, @Nullable Timestamp timestamp) {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public synchronized void updateAsciiStream(String string, @Nullable InputStream inputStream, int n) {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public synchronized void updateBinaryStream(String string, @Nullable InputStream inputStream, int n) {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public synchronized void updateCharacterStream(String string, @Nullable Reader reader, int n) {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public synchronized void updateObject(String string, @Nullable Object object, int n) {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public synchronized void updateObject(String string, @Nullable Object object) {
        this.updateObject(this.findColumn(string), object);
    }

    boolean isUpdateable() {
        int n;
        this.checkClosed();
        if (this.resultsetconcurrency == 1007) {
            throw new PSQLException(GT.tr("ResultSets with concurrency CONCUR_READ_ONLY cannot be updated.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateable) {
            return true;
        }
        this.connection.getLogger().log(Level.FINE, "checking if rs is updateable");
        this.parseQuery();
        if (this.tableName == null) {
            this.connection.getLogger().log(Level.FINE, "tableName is not found");
            return false;
        }
        if (!this.singleTable) {
            this.connection.getLogger().log(Level.FINE, "not a single table");
            return false;
        }
        this.usingOID = false;
        this.connection.getLogger().log(Level.FINE, "getting primary keys");
        ArrayList<PrimaryKey> arrayList = new ArrayList<PrimaryKey>();
        this.primaryKeys = arrayList;
        int n2 = 0;
        int n3 = 0;
        @Nullable String[] stringArray = PgResultSet.quotelessTableName(Nullness.castNonNull(this.tableName));
        String string = Nullness.castNonNull(stringArray[0]);
        String string2 = stringArray[1];
        ResultSet resultSet = ((PgDatabaseMetaData)this.connection.getMetaData()).getPrimaryUniqueKeys("", string2, string);
        String string3 = null;
        while (resultSet.next()) {
            String string4;
            int n4;
            String string5 = Nullness.castNonNull(resultSet.getString(6));
            if (string3 == null || !string3.equals(string5)) {
                if (string3 != null) {
                    if (n2 == n3 && n3 > 0) break;
                    this.connection.getLogger().log(Level.FINE, "no of keys={0} from constraint {1}", new Object[]{n2, string3});
                }
                n2 = 0;
                n3 = 0;
                arrayList.clear();
                string3 = string5;
            }
            ++n3;
            boolean bl = resultSet.getBoolean("IS_NOT_NULL");
            if (!bl || (n4 = this.findColumnIndex(string4 = Nullness.castNonNull(resultSet.getString(4)))) <= 0) continue;
            ++n2;
            arrayList.add(new PrimaryKey(n4, string4));
        }
        resultSet.close();
        this.connection.getLogger().log(Level.FINE, "no of keys={0} from constraint {1}", new Object[]{n2, string3});
        this.updateable = n2 == n3 && n3 > 0;
        this.connection.getLogger().log(Level.FINE, "checking primary key {0}", this.updateable);
        if (!this.updateable && (n = this.findColumnIndex("oid")) > 0) {
            arrayList.add(new PrimaryKey(n, "oid"));
            this.usingOID = true;
            this.updateable = true;
        }
        if (!this.updateable) {
            throw new PSQLException(GT.tr("No eligible primary or unique key found for table {0}.", this.tableName), PSQLState.INVALID_CURSOR_STATE);
        }
        return this.updateable;
    }

    public void setAdaptiveFetch(boolean bl) {
        this.checkClosed();
        this.updateQueryInsideAdaptiveFetchCache(bl);
        this.adaptiveFetch = bl;
    }

    private void updateQueryInsideAdaptiveFetchCache(boolean bl) {
        if (Objects.nonNull(this.cursor)) {
            ResultCursor resultCursor = this.cursor;
            if (!this.adaptiveFetch && bl) {
                this.connection.getQueryExecutor().addQueryToAdaptiveFetchCache(true, resultCursor);
            }
            if (this.adaptiveFetch && !bl && Objects.nonNull(this.cursor)) {
                this.connection.getQueryExecutor().removeQueryFromAdaptiveFetchCache(true, resultCursor);
            }
        }
    }

    public boolean getAdaptiveFetch() {
        this.checkClosed();
        return this.adaptiveFetch;
    }

    public static @Nullable String[] quotelessTableName(String string) {
        @Nullable String[] stringArray = new String[]{null, ""};
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    if (i < string.length() - 1 && string.charAt(i + 1) == '\"') {
                        ++i;
                        stringBuilder.append(c);
                        continue block4;
                    }
                    bl = !bl;
                    continue block4;
                }
                case '.': {
                    if (bl) {
                        stringBuilder.append(c);
                        continue block4;
                    }
                    stringArray[1] = stringBuilder.toString();
                    stringBuilder = new StringBuilder();
                    continue block4;
                }
                default: {
                    stringBuilder.append(bl ? c : Character.toLowerCase(c));
                }
            }
        }
        stringArray[0] = stringBuilder.toString();
        return stringArray;
    }

    private void parseQuery() {
        Query query = this.originalQuery;
        if (query == null) {
            return;
        }
        String string = query.toString(null);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \r\t\n");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        this.singleTable = true;
        while (!bl && !bl2 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!"from".equalsIgnoreCase(string2)) continue;
            this.tableName = stringTokenizer.nextToken();
            if ("only".equalsIgnoreCase(this.tableName)) {
                this.tableName = stringTokenizer.nextToken();
                this.onlyTable = "ONLY ";
            }
            bl = true;
        }
    }

    private void setRowBufferColumn(Tuple tuple, int n, @Nullable Object object) {
        if (object instanceof PGobject) {
            String string = ((PGobject)object).getValue();
            tuple.set(n, string == null ? null : this.connection.encodeString(string));
        } else {
            if (object == null) {
                tuple.set(n, null);
                return;
            }
            switch (this.getSQLType(n + 1)) {
                case -7: 
                case 16: {
                    tuple.set(n, this.connection.encodeString((Boolean)object != false ? "t" : "f"));
                    break;
                }
                case 91: {
                    tuple.set(n, this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (java.sql.Date)object)));
                    break;
                }
                case 92: {
                    tuple.set(n, this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (Time)object)));
                    break;
                }
                case 93: {
                    tuple.set(n, this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (Timestamp)object)));
                    break;
                }
                case 0: {
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (this.isBinary(n + 1)) {
                        tuple.set(n, (byte[])object);
                        break;
                    }
                    try {
                        tuple.set(n, PGbytea.toPGString((byte[])object).getBytes(this.connection.getEncoding().name()));
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", this.connection.getEncoding().name()), PSQLState.UNEXPECTED_ERROR, (Throwable)unsupportedEncodingException);
                    }
                }
                default: {
                    tuple.set(n, this.connection.encodeString(String.valueOf(object)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRowBuffer(@Nullable PreparedStatement preparedStatement, Tuple tuple, HashMap<String, Object> hashMap) {
        int n;
        for (Map.Entry<String, Object> object : hashMap.entrySet()) {
            n = this.findColumn(object.getKey()) - 1;
            Object i = object.getValue();
            this.setRowBufferColumn(tuple, n, i);
        }
        if (preparedStatement == null) {
            return;
        }
        try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
            resultSet.next();
            List<PrimaryKey> list = Nullness.castNonNull(this.primaryKeys);
            n = list.size();
            for (int i = 0; i < n; ++i) {
                PrimaryKey primaryKey = list.get(i);
                int n2 = primaryKey.index - 1;
                Object object = resultSet.getObject(primaryKey.name);
                this.setRowBufferColumn(tuple, n2, object);
            }
        }
    }

    public BaseStatement getPGStatement() {
        return this.statement;
    }

    @Override
    public @Nullable String getRefCursor() {
        return this.refCursorName;
    }

    private void setRefCursor(String string) {
        this.refCursorName = string;
    }

    @Override
    public void setFetchSize(int n) {
        this.checkClosed();
        if (n < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = n;
    }

    @Override
    public int getFetchSize() {
        this.checkClosed();
        if (this.adaptiveFetch) {
            return this.lastUsedFetchSize;
        }
        return this.fetchSize;
    }

    public int getLastUsedFetchSize() {
        this.checkClosed();
        return this.lastUsedFetchSize;
    }

    @Override
    public boolean next() {
        this.checkClosed();
        Nullness.castNonNull(this.rows, "rows");
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.currentRow + 1 >= this.rows.size()) {
            ResultCursor resultCursor = this.cursor;
            if (resultCursor == null || this.maxRows > 0 && this.rowOffset + this.rows.size() >= this.maxRows) {
                this.currentRow = this.rows.size();
                this.thisRow = null;
                this.rowBuffer = null;
                return false;
            }
            this.rowOffset += this.rows.size();
            int n = this.fetchSize;
            int n2 = this.connection.getQueryExecutor().getAdaptiveFetchSize(this.adaptiveFetch, resultCursor);
            if (n2 != -1) {
                n = n2;
            }
            if (this.maxRows != 0 && (n == 0 || this.rowOffset + n > this.maxRows)) {
                n = this.maxRows - this.rowOffset;
            }
            this.connection.getQueryExecutor().fetch(resultCursor, new CursorResultHandler(), n, this.adaptiveFetch);
            this.lastUsedFetchSize = n;
            this.currentRow = 0;
            if (this.rows == null || this.rows.isEmpty()) {
                this.thisRow = null;
                this.rowBuffer = null;
                return false;
            }
        } else {
            ++this.currentRow;
        }
        this.initRowBuffer();
        return true;
    }

    @Override
    public void close() {
        try {
            this.closeInternally();
        }
        finally {
            ((PgStatement)this.statement).checkCompletion();
        }
    }

    protected void closeInternally() {
        this.rows = null;
        JdbcBlackHole.close(this.deleteStatement);
        this.deleteStatement = null;
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    @Override
    public boolean wasNull() {
        this.checkClosed();
        return this.wasNullFlag;
    }

    @Override
    @Pure
    public @Nullable String getString(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getString columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        if (this.isBinary(n) && this.getSQLType(n) != 12) {
            Field field = this.fields[n - 1];
            Object object = this.internalGetObject(n, field);
            if (object == null) {
                object = this.getObject(n);
                if (object == null) {
                    return null;
                }
                return object.toString();
            }
            if (object instanceof Date) {
                int n2 = field.getOID();
                return this.connection.getTimestampUtils().timeToString((Date)object, n2 == 1184 || n2 == 1266);
            }
            if ("hstore".equals(this.getPGType(n))) {
                return HStoreConverter.toString((Map)object);
            }
            return this.trimString(n, object.toString());
        }
        Encoding encoding = this.connection.getEncoding();
        try {
            return this.trimString(n, encoding.decode(byArray));
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)iOException);
        }
    }

    @Override
    @Pure
    public boolean getBoolean(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getBoolean columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return false;
        }
        int n2 = n - 1;
        if (16 == this.fields[n2].getOID()) {
            byte[] byArray2 = byArray;
            return 1 == byArray2.length && 116 == byArray2[0];
        }
        if (this.isBinary(n)) {
            return BooleanTypeUtil.castToBoolean(this.readDoubleValue(byArray, this.fields[n2].getOID(), "boolean"));
        }
        String string = Nullness.castNonNull(this.getString(n));
        return BooleanTypeUtil.castToBoolean(string);
    }

    @Override
    public byte getByte(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getByte columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return 0;
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            return (byte)this.readLongValue(byArray, this.fields[n2].getOID(), -128L, 127L, "byte");
        }
        String string = this.getString(n);
        if (string != null) {
            if ((string = string.trim()).isEmpty()) {
                return 0;
            }
            try {
                return Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    BigInteger bigInteger = bigDecimal.toBigInteger();
                    int n3 = bigInteger.compareTo(BYTEMAX);
                    int n4 = bigInteger.compareTo(BYTEMIN);
                    if (n3 > 0 || n4 < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "byte", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return bigInteger.byteValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "byte", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    @Override
    public short getShort(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getShort columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return 0;
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            if (n3 == 21) {
                return ByteConverter.int2(byArray, 0);
            }
            return (short)this.readLongValue(byArray, n3, -32768L, 32767L, "short");
        }
        return PgResultSet.toShort(this.getFixedString(n));
    }

    @Override
    @Pure
    public int getInt(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getInt columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return 0;
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            if (n3 == 23) {
                return ByteConverter.int4(byArray, 0);
            }
            return (int)this.readLongValue(byArray, n3, Integer.MIN_VALUE, Integer.MAX_VALUE, "int");
        }
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                return this.getFastInt(byArray);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return PgResultSet.toInt(this.getFixedString(n));
    }

    @Override
    @Pure
    public long getLong(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getLong columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return 0L;
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            if (n3 == 20) {
                return ByteConverter.int8(byArray, 0);
            }
            return this.readLongValue(byArray, n3, Long.MIN_VALUE, Long.MAX_VALUE, "long");
        }
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                return this.getFastLong(byArray);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return PgResultSet.toLong(this.getFixedString(n));
    }

    private long getFastLong(byte[] byArray) {
        int n;
        boolean bl;
        if (byArray.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        long l = 0L;
        if (byArray[0] == 45) {
            bl = true;
            n = 1;
            if (byArray.length == 1 || byArray.length > 19) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            n = 0;
            bl = false;
            if (byArray.length > 18) {
                throw FAST_NUMBER_FAILED;
            }
        }
        while (n < byArray.length) {
            byte by;
            if ((by = byArray[n++]) < 48 || by > 57) {
                throw FAST_NUMBER_FAILED;
            }
            l *= 10L;
            l += (long)(by - 48);
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    private int getFastInt(byte[] byArray) {
        int n;
        boolean bl;
        if (byArray.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        int n2 = 0;
        if (byArray[0] == 45) {
            bl = true;
            n = 1;
            if (byArray.length == 1 || byArray.length > 10) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            n = 0;
            bl = false;
            if (byArray.length > 9) {
                throw FAST_NUMBER_FAILED;
            }
        }
        while (n < byArray.length) {
            byte by;
            if ((by = byArray[n++]) < 48 || by > 57) {
                throw FAST_NUMBER_FAILED;
            }
            n2 *= 10;
            n2 += by - 48;
        }
        if (bl) {
            n2 = -n2;
        }
        return n2;
    }

    private BigDecimal getFastBigDecimal(byte[] byArray) {
        int n;
        int n2;
        boolean bl;
        if (byArray.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        int n3 = 0;
        long l = 0L;
        if (byArray[0] == 45) {
            bl = true;
            n2 = 1;
            if (byArray.length == 1 || byArray.length > 19) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            n2 = 0;
            bl = false;
            if (byArray.length > 18) {
                throw FAST_NUMBER_FAILED;
            }
        }
        int n4 = 0;
        while (n2 < byArray.length) {
            if ((n = byArray[n2++]) < 48 || n > 57) {
                if (n == 46) {
                    n3 = byArray.length - n2;
                    ++n4;
                    continue;
                }
                throw FAST_NUMBER_FAILED;
            }
            l *= 10L;
            l += (long)(n - 48);
        }
        int n5 = n = bl ? byArray.length - 1 : byArray.length;
        if (n4 > 1 || n4 == n) {
            throw FAST_NUMBER_FAILED;
        }
        if (bl) {
            l = -l;
        }
        return BigDecimal.valueOf(l, n3);
    }

    @Override
    @Pure
    public float getFloat(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getFloat columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return 0.0f;
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            if (n3 == 700) {
                return ByteConverter.float4(byArray, 0);
            }
            return (float)this.readDoubleValue(byArray, n3, "float");
        }
        return PgResultSet.toFloat(this.getFixedString(n));
    }

    @Override
    @Pure
    public double getDouble(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getDouble columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return 0.0;
        }
        if (this.isBinary(n)) {
            int n2 = n - 1;
            int n3 = this.fields[n2].getOID();
            if (n3 == 701) {
                return ByteConverter.float8(byArray, 0);
            }
            return this.readDoubleValue(byArray, n3, "double");
        }
        return PgResultSet.toDouble(this.getFixedString(n));
    }

    @Override
    public @Nullable BigDecimal getBigDecimal(int n, int n2) {
        this.connection.getLogger().log(Level.FINEST, "  getBigDecimal columnIndex: {0}", n);
        return (BigDecimal)this.getNumeric(n, n2, false);
    }

    @Pure
    private @Nullable Number getNumeric(int n, int n2, boolean bl) {
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        if (this.isBinary(n)) {
            int n3 = this.getSQLType(n);
            if (n3 != 2 && n3 != 3) {
                Object object = this.internalGetObject(n, this.fields[n - 1]);
                if (object == null) {
                    return null;
                }
                if (object instanceof Long || object instanceof Integer || object instanceof Byte) {
                    BigDecimal bigDecimal = BigDecimal.valueOf(((Number)object).longValue());
                    bigDecimal = this.scaleBigDecimal(bigDecimal, n2);
                    return bigDecimal;
                }
                return this.toBigDecimal(this.trimMoney(String.valueOf(object)), n2);
            }
            Number number = ByteConverter.numeric(byArray);
            if (bl && Double.isNaN(number.doubleValue())) {
                return Double.NaN;
            }
            return number;
        }
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                BigDecimal bigDecimal = this.getFastBigDecimal(byArray);
                bigDecimal = this.scaleBigDecimal(bigDecimal, n2);
                return bigDecimal;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string = this.getFixedString(n);
        if (bl && "NaN".equalsIgnoreCase(string)) {
            return Double.NaN;
        }
        return this.toBigDecimal(string, n2);
    }

    @Override
    @Pure
    public byte @Nullable [] getBytes(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getBytes columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        if (this.isBinary(n)) {
            return byArray;
        }
        if (this.fields[n - 1].getOID() == 17) {
            return this.trimBytes(n, PGbytea.toBytes(byArray));
        }
        return this.trimBytes(n, byArray);
    }

    @Override
    @Pure
    public @Nullable java.sql.Date getDate(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getDate columnIndex: {0}", n);
        return this.getDate(n, null);
    }

    @Override
    @Pure
    public @Nullable Time getTime(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getTime columnIndex: {0}", n);
        return this.getTime(n, null);
    }

    @Override
    @Pure
    public @Nullable Timestamp getTimestamp(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getTimestamp columnIndex: {0}", n);
        return this.getTimestamp(n, null);
    }

    @Override
    @Pure
    public @Nullable InputStream getAsciiStream(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getAsciiStream columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        String string = Nullness.castNonNull(this.getString(n));
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    @Pure
    public @Nullable InputStream getUnicodeStream(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getUnicodeStream columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        String string = Nullness.castNonNull(this.getString(n));
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    @Pure
    public @Nullable InputStream getBinaryStream(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getBinaryStream columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = this.getBytes(n);
        if (byArray2 != null) {
            return new ByteArrayInputStream(byArray2);
        }
        return null;
    }

    @Override
    @Pure
    public @Nullable String getString(String string) {
        return this.getString(this.findColumn(string));
    }

    @Override
    @Pure
    public boolean getBoolean(String string) {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    @Pure
    public byte getByte(String string) {
        return this.getByte(this.findColumn(string));
    }

    @Override
    @Pure
    public short getShort(String string) {
        return this.getShort(this.findColumn(string));
    }

    @Override
    @Pure
    public int getInt(String string) {
        return this.getInt(this.findColumn(string));
    }

    @Override
    @Pure
    public long getLong(String string) {
        return this.getLong(this.findColumn(string));
    }

    @Override
    @Pure
    public float getFloat(String string) {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    @Pure
    public double getDouble(String string) {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    @Pure
    public @Nullable BigDecimal getBigDecimal(String string, int n) {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    @Pure
    public byte @Nullable [] getBytes(String string) {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    @Pure
    public @Nullable java.sql.Date getDate(String string) {
        return this.getDate(this.findColumn(string), null);
    }

    @Override
    @Pure
    public @Nullable Time getTime(String string) {
        return this.getTime(this.findColumn(string), null);
    }

    @Override
    @Pure
    public @Nullable Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.findColumn(string), null);
    }

    @Override
    @Pure
    public @Nullable InputStream getAsciiStream(String string) {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    @Pure
    public @Nullable InputStream getUnicodeStream(String string) {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    @Pure
    public @Nullable InputStream getBinaryStream(String string) {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    @Pure
    public @Nullable SQLWarning getWarnings() {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() {
        this.checkClosed();
        this.warnings = null;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    @Override
    public @Nullable String getCursorName() {
        this.checkClosed();
        return null;
    }

    @Override
    public @Nullable Object getObject(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getObject columnIndex: {0}", n);
        byte[] byArray = this.getRawValue(n);
        if (byArray == null) {
            return null;
        }
        Field field = this.fields[n - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        Object object = this.internalGetObject(n, field);
        if (object != null) {
            return object;
        }
        if (this.isBinary(n)) {
            return this.connection.getObject(this.getPGType(n), null, byArray);
        }
        String string = Nullness.castNonNull(this.getString(n));
        return this.connection.getObject(this.getPGType(n), string, null);
    }

    @Override
    public @Nullable Object getObject(String string) {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public @NonNegative int findColumn(String string) {
        this.checkClosed();
        int n = this.findColumnIndex(string);
        if (n == 0) {
            throw new PSQLException(GT.tr("The column name {0} was not found in this ResultSet.", string), PSQLState.UNDEFINED_COLUMN);
        }
        return n;
    }

    public static Map<String, Integer> createColumnNameIndexMap(Field[] fieldArray, boolean bl) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(fieldArray.length * 2);
        for (int i = fieldArray.length - 1; i >= 0; --i) {
            String string = fieldArray[i].getColumnLabel();
            if (bl) {
                hashMap.put(string, i + 1);
                continue;
            }
            hashMap.put(string.toLowerCase(Locale.US), i + 1);
        }
        return hashMap;
    }

    private @NonNegative int findColumnIndex(String string) {
        Integer n;
        if (this.columnNameIndexMap == null) {
            if (this.originalQuery != null) {
                this.columnNameIndexMap = this.originalQuery.getResultSetColumnNameIndexMap();
            }
            if (this.columnNameIndexMap == null) {
                this.columnNameIndexMap = PgResultSet.createColumnNameIndexMap(this.fields, this.connection.isColumnSanitiserDisabled());
            }
        }
        if ((n = this.columnNameIndexMap.get(string)) != null) {
            return n;
        }
        n = this.columnNameIndexMap.get(string.toLowerCase(Locale.US));
        if (n != null) {
            this.columnNameIndexMap.put(string, n);
            return n;
        }
        n = this.columnNameIndexMap.get(string.toUpperCase(Locale.US));
        if (n != null) {
            this.columnNameIndexMap.put(string, n);
            return n;
        }
        return 0;
    }

    public int getColumnOID(int n) {
        return this.fields[n - 1].getOID();
    }

    public @Nullable String getFixedString(int n) {
        String string = Nullness.castNonNull(this.getString(n));
        return this.trimMoney(string);
    }

    private @PolyNull String trimMoney(@PolyNull String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        char c = string.charAt(0);
        if (c > '-') {
            return string;
        }
        if (c == '(') {
            string = "-" + PGtokenizer.removePara(string).substring(1);
        } else if (c == '$') {
            string = string.substring(1);
        } else if (c == '-' && string.charAt(1) == '$') {
            string = "-" + string.substring(2);
        }
        return string;
    }

    @Pure
    protected String getPGType(@Positive int n) {
        Field field = this.fields[n - 1];
        this.initSqlType(field);
        return field.getPGType();
    }

    @Pure
    protected int getSQLType(@Positive int n) {
        Field field = this.fields[n - 1];
        this.initSqlType(field);
        return field.getSQLType();
    }

    @Pure
    private void initSqlType(Field field) {
        if (field.isTypeInitialized()) {
            return;
        }
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int n = field.getOID();
        String string = Nullness.castNonNull(typeInfo.getPGType(n));
        int n2 = typeInfo.getSQLType(string);
        field.setSQLType(n2);
        field.setPGType(string);
    }

    @EnsuresNonNull(value={"updateValues", "rows"})
    private void checkUpdateable() {
        this.checkClosed();
        if (!this.isUpdateable()) {
            throw new PSQLException(GT.tr("ResultSet is not updateable.  The query that generated this result set must select only one table, and must select all primary keys from that table. See the JDBC 2.1 API Specification, section 5.6 for more details.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues == null) {
            this.updateValues = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
        }
        Nullness.castNonNull(this.updateValues, "updateValues");
        Nullness.castNonNull(this.rows, "rows");
    }

    @Pure
    @EnsuresNonNull(value={"rows"})
    protected void checkClosed() {
        if (this.rows == null) {
            throw new PSQLException(GT.tr("This ResultSet is closed.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    protected boolean isResultSetClosed() {
        return this.rows == null;
    }

    @Pure
    protected void checkColumnIndex(@Positive int n) {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", n, this.fields.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @EnsuresNonNull(value={"thisRow"})
    protected byte @Nullable [] getRawValue(@Positive int n) {
        this.checkClosed();
        if (this.thisRow == null) {
            throw new PSQLException(GT.tr("ResultSet not positioned properly, perhaps you need to call next.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(n);
        byte[] byArray = this.thisRow.get(n - 1);
        this.wasNullFlag = byArray == null;
        return byArray;
    }

    @Pure
    protected boolean isBinary(@Positive int n) {
        return this.fields[n - 1].getFormat() == 1;
    }

    public static short toShort(@Nullable String string) {
        if (string != null) {
            try {
                string = string.trim();
                return Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    BigInteger bigInteger = bigDecimal.toBigInteger();
                    int n = bigInteger.compareTo(SHORTMAX);
                    int n2 = bigInteger.compareTo(SHORTMIN);
                    if (n > 0 || n2 < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "short", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return bigInteger.shortValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "short", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public static int toInt(@Nullable String string) {
        if (string != null) {
            try {
                string = string.trim();
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    BigInteger bigInteger = bigDecimal.toBigInteger();
                    int n = bigInteger.compareTo(INTMAX);
                    int n2 = bigInteger.compareTo(INTMIN);
                    if (n > 0 || n2 < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "int", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return bigInteger.intValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "int", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public static long toLong(@Nullable String string) {
        if (string != null) {
            try {
                string = string.trim();
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    BigInteger bigInteger = bigDecimal.toBigInteger();
                    int n = bigInteger.compareTo(LONGMAX);
                    int n2 = bigInteger.compareTo(LONGMIN);
                    if (n > 0 || n2 < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "long", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return bigInteger.longValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "long", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0L;
    }

    public static @PolyNull BigDecimal toBigDecimal(@PolyNull String string) {
        if (string == null) {
            return null;
        }
        try {
            string = string.trim();
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "BigDecimal", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
    }

    public @PolyNull BigDecimal toBigDecimal(@PolyNull String string, int n) {
        if (string == null) {
            return null;
        }
        BigDecimal bigDecimal = PgResultSet.toBigDecimal(string);
        return this.scaleBigDecimal(bigDecimal, n);
    }

    private BigDecimal scaleBigDecimal(BigDecimal bigDecimal, int n) {
        if (n == -1) {
            return bigDecimal;
        }
        try {
            return bigDecimal.setScale(n);
        }
        catch (ArithmeticException arithmeticException) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "BigDecimal", bigDecimal), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
    }

    public static float toFloat(@Nullable String string) {
        if (string != null) {
            try {
                string = string.trim();
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "float", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0f;
    }

    public static double toDouble(@Nullable String string) {
        if (string != null) {
            try {
                string = string.trim();
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "double", string), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0;
    }

    @RequiresNonNull(value={"rows"})
    private void initRowBuffer() {
        this.thisRow = Nullness.castNonNull(this.rows, "rows").get(this.currentRow);
        this.rowBuffer = this.resultsetconcurrency == 1008 ? this.thisRow.updateableCopy() : null;
    }

    private boolean isColumnTrimmable(@Positive int n) {
        switch (this.getSQLType(n)) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] trimBytes(@Positive int n, byte[] byArray) {
        if (this.maxFieldSize > 0 && byArray.length > this.maxFieldSize && this.isColumnTrimmable(n)) {
            byte[] byArray2 = new byte[this.maxFieldSize];
            System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
            return byArray2;
        }
        return byArray;
    }

    private String trimString(@Positive int n, String string) {
        if (this.maxFieldSize > 0 && string.length() > this.maxFieldSize && this.isColumnTrimmable(n)) {
            return string.substring(0, this.maxFieldSize);
        }
        return string;
    }

    private double readDoubleValue(byte[] byArray, int n, String string) {
        switch (n) {
            case 21: {
                return ByteConverter.int2(byArray, 0);
            }
            case 23: {
                return ByteConverter.int4(byArray, 0);
            }
            case 20: {
                return ByteConverter.int8(byArray, 0);
            }
            case 700: {
                return ByteConverter.float4(byArray, 0);
            }
            case 701: {
                return ByteConverter.float8(byArray, 0);
            }
            case 1700: {
                return ByteConverter.numeric(byArray).doubleValue();
            }
        }
        throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(n), string), PSQLState.DATA_TYPE_MISMATCH);
    }

    @Pure
    private long readLongValue(byte[] byArray, int n, long l, long l2, String string) {
        long l3;
        switch (n) {
            case 21: {
                l3 = ByteConverter.int2(byArray, 0);
                break;
            }
            case 23: {
                l3 = ByteConverter.int4(byArray, 0);
                break;
            }
            case 20: {
                l3 = ByteConverter.int8(byArray, 0);
                break;
            }
            case 700: {
                l3 = (long)ByteConverter.float4(byArray, 0);
                break;
            }
            case 701: {
                l3 = (long)ByteConverter.float8(byArray, 0);
                break;
            }
            case 1700: {
                Number number = ByteConverter.numeric(byArray);
                if (number instanceof BigDecimal) {
                    l3 = ((BigDecimal)number).setScale(0, RoundingMode.DOWN).longValueExact();
                    break;
                }
                l3 = number.longValue();
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(n), string), PSQLState.DATA_TYPE_MISMATCH);
            }
        }
        if (l3 < l || l3 > l2) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", string, l3), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return l3;
    }

    protected void updateValue(@Positive int n, @Nullable Object object) {
        this.checkUpdateable();
        if (!this.onInsertRow && (this.isBeforeFirst() || this.isAfterLast() || Nullness.castNonNull(this.rows, "rows").isEmpty())) {
            throw new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the results.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(n);
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (object == null) {
            this.updateNull(n);
        } else {
            PGResultSetMetaData pGResultSetMetaData = (PGResultSetMetaData)((Object)this.getMetaData());
            Nullness.castNonNull(this.updateValues, "updateValues").put(pGResultSetMetaData.getBaseColumnName(n), object);
        }
    }

    @Pure
    protected Object getUUID(String string) {
        UUID uUID;
        try {
            uUID = UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PSQLException(GT.tr("Invalid UUID data.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)illegalArgumentException);
        }
        return uUID;
    }

    @Pure
    protected Object getUUID(byte[] byArray) {
        return new UUID(ByteConverter.int8(byArray, 0), ByteConverter.int8(byArray, 8));
    }

    void addRows(List<Tuple> list) {
        Nullness.castNonNull(this.rows, "rows").addAll(list);
    }

    @Override
    public void updateRef(@Positive int n, @Nullable Ref ref) {
        throw Driver.notImplemented(this.getClass(), "updateRef(int,Ref)");
    }

    @Override
    public void updateRef(String string, @Nullable Ref ref) {
        throw Driver.notImplemented(this.getClass(), "updateRef(String,Ref)");
    }

    @Override
    public void updateBlob(@Positive int n, @Nullable Blob blob) {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int,Blob)");
    }

    @Override
    public void updateBlob(String string, @Nullable Blob blob) {
        throw Driver.notImplemented(this.getClass(), "updateBlob(String,Blob)");
    }

    @Override
    public void updateClob(@Positive int n, @Nullable Clob clob) {
        throw Driver.notImplemented(this.getClass(), "updateClob(int,Clob)");
    }

    @Override
    public void updateClob(String string, @Nullable Clob clob) {
        throw Driver.notImplemented(this.getClass(), "updateClob(String,Clob)");
    }

    @Override
    public void updateArray(@Positive int n, @Nullable Array array) {
        this.updateObject(n, (Object)array);
    }

    @Override
    public void updateArray(String string, @Nullable Array array) {
        this.updateArray(this.findColumn(string), array);
    }

    @Override
    public <T> @Nullable T getObject(@Positive int n, Class<T> clazz) {
        if (clazz == null) {
            throw new SQLException("type is null");
        }
        int n2 = this.getSQLType(n);
        if (clazz == BigDecimal.class) {
            if (n2 == 2 || n2 == 3) {
                return clazz.cast(this.getBigDecimal(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == String.class) {
            if (n2 == 1 || n2 == 12) {
                return clazz.cast(this.getString(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Boolean.class) {
            if (n2 == 16 || n2 == -7) {
                boolean bl = this.getBoolean(n);
                if (this.wasNull()) {
                    return null;
                }
                return clazz.cast(bl);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Short.class) {
            if (n2 == 5) {
                short s = this.getShort(n);
                if (this.wasNull()) {
                    return null;
                }
                return clazz.cast(s);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Integer.class) {
            if (n2 == 4 || n2 == 5) {
                int n3 = this.getInt(n);
                if (this.wasNull()) {
                    return null;
                }
                return clazz.cast(n3);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Long.class) {
            if (n2 == -5) {
                long l = this.getLong(n);
                if (this.wasNull()) {
                    return null;
                }
                return clazz.cast(l);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == BigInteger.class) {
            if (n2 == -5) {
                long l = this.getLong(n);
                if (this.wasNull()) {
                    return null;
                }
                return clazz.cast(BigInteger.valueOf(l));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Float.class) {
            if (n2 == 7) {
                float f = this.getFloat(n);
                if (this.wasNull()) {
                    return null;
                }
                return clazz.cast(Float.valueOf(f));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Double.class) {
            if (n2 == 6 || n2 == 8) {
                double d = this.getDouble(n);
                if (this.wasNull()) {
                    return null;
                }
                return clazz.cast(d);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == java.sql.Date.class) {
            if (n2 == 91) {
                return clazz.cast(this.getDate(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Time.class) {
            if (n2 == 92) {
                return clazz.cast(this.getTime(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Timestamp.class) {
            if (n2 == 93 || n2 == 2014) {
                return clazz.cast(this.getTimestamp(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Calendar.class) {
            if (n2 == 93 || n2 == 2014) {
                Timestamp timestamp = this.getTimestamp(n);
                if (timestamp == null) {
                    return null;
                }
                Calendar calendar = Calendar.getInstance(this.getDefaultCalendar().getTimeZone());
                calendar.setTimeInMillis(timestamp.getTime());
                return clazz.cast(calendar);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Blob.class) {
            if (n2 == 2004 || n2 == -2 || n2 == -5) {
                return clazz.cast(this.getBlob(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Clob.class) {
            if (n2 == 2005 || n2 == -5) {
                return clazz.cast(this.getClob(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Date.class) {
            if (n2 == 93) {
                Timestamp timestamp = this.getTimestamp(n);
                if (timestamp == null) {
                    return null;
                }
                return clazz.cast(new Date(timestamp.getTime()));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == Array.class) {
            if (n2 == 2003) {
                return clazz.cast(this.getArray(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == SQLXML.class) {
            if (n2 == 2009) {
                return clazz.cast(this.getSQLXML(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == UUID.class) {
            return clazz.cast(this.getObject(n));
        }
        if (clazz == InetAddress.class) {
            String string = this.getString(n);
            if (string == null) {
                return null;
            }
            int n4 = string.indexOf("/");
            try {
                return clazz.cast(InetAddress.getByName(n4 < 0 ? string : string.substring(0, n4)));
            }
            catch (UnknownHostException unknownHostException) {
                throw new PSQLException(GT.tr("Invalid Inet data.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)unknownHostException);
            }
        }
        if (clazz == LocalDate.class) {
            if (n2 == 91) {
                java.sql.Date date = this.getDate(n);
                if (date == null) {
                    return null;
                }
                long l = date.getTime();
                if (l == 9223372036825200000L) {
                    return clazz.cast(LocalDate.MAX);
                }
                if (l == -9223372036832400000L) {
                    return clazz.cast(LocalDate.MIN);
                }
                return clazz.cast(date.toLocalDate());
            }
            if (n2 == 93) {
                LocalDateTime localDateTime = this.getLocalDateTime(n);
                if (localDateTime == null) {
                    return null;
                }
                return clazz.cast(localDateTime.toLocalDate());
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == LocalTime.class) {
            if (n2 == 92) {
                return clazz.cast(this.getLocalTime(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == LocalDateTime.class) {
            if (n2 == 93) {
                return clazz.cast(this.getLocalDateTime(n));
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (clazz == OffsetDateTime.class) {
            if (n2 == 2014 || n2 == 93) {
                OffsetDateTime offsetDateTime = this.getOffsetDateTime(n);
                return clazz.cast(offsetDateTime);
            }
            throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (PGobject.class.isAssignableFrom(clazz)) {
            Object object;
            if (this.isBinary(n)) {
                byte[] byArray = Nullness.castNonNull(this.thisRow, "thisRow").get(n - 1);
                object = this.connection.getObject(this.getPGType(n), null, byArray);
            } else {
                object = this.connection.getObject(this.getPGType(n), this.getString(n), null);
            }
            return clazz.cast(object);
        }
        throw new PSQLException(GT.tr("conversion to {0} from {1} not supported", clazz, this.getPGType(n)), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> @Nullable T getObject(String string, Class<T> clazz) {
        return this.getObject(this.findColumn(string), clazz);
    }

    @Override
    public @Nullable Object getObject(String string, @Nullable Map<String, Class<?>> map) {
        return this.getObjectImpl(string, map);
    }

    @Override
    public @Nullable Object getObject(@Positive int n, @Nullable Map<String, Class<?>> map) {
        return this.getObjectImpl(n, map);
    }

    @Override
    public void updateObject(@Positive int n, @Nullable Object object, SQLType sQLType, int n2) {
        throw Driver.notImplemented(this.getClass(), "updateObject");
    }

    @Override
    public void updateObject(String string, @Nullable Object object, SQLType sQLType, int n) {
        throw Driver.notImplemented(this.getClass(), "updateObject");
    }

    @Override
    public void updateObject(@Positive int n, @Nullable Object object, SQLType sQLType) {
        throw Driver.notImplemented(this.getClass(), "updateObject");
    }

    @Override
    public void updateObject(String string, @Nullable Object object, SQLType sQLType) {
        throw Driver.notImplemented(this.getClass(), "updateObject");
    }

    @Override
    public @Nullable RowId getRowId(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getRowId columnIndex: {0}", n);
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public @Nullable RowId getRowId(String string) {
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public void updateRowId(@Positive int n, @Nullable RowId rowId) {
        throw Driver.notImplemented(this.getClass(), "updateRowId(int, RowId)");
    }

    @Override
    public void updateRowId(String string, @Nullable RowId rowId) {
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public int getHoldability() {
        throw Driver.notImplemented(this.getClass(), "getHoldability()");
    }

    @Override
    public boolean isClosed() {
        return this.rows == null;
    }

    @Override
    public void updateNString(@Positive int n, @Nullable String string) {
        throw Driver.notImplemented(this.getClass(), "updateNString(int, String)");
    }

    @Override
    public void updateNString(String string, @Nullable String string2) {
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public void updateNClob(@Positive int n, @Nullable NClob nClob) {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, NClob)");
    }

    @Override
    public void updateNClob(String string, @Nullable NClob nClob) {
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public void updateNClob(@Positive int n, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, Reader)");
    }

    @Override
    public void updateNClob(String string, @Nullable Reader reader) {
        this.updateNClob(this.findColumn(string), reader);
    }

    @Override
    public void updateNClob(@Positive int n, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, Reader, long)");
    }

    @Override
    public void updateNClob(String string, @Nullable Reader reader, long l) {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public @Nullable NClob getNClob(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getNClob columnIndex: {0}", n);
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public @Nullable NClob getNClob(String string) {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public void updateBlob(@Positive int n, @Nullable InputStream inputStream, long l) {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream, long)");
    }

    @Override
    public void updateBlob(String string, @Nullable InputStream inputStream, long l) {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBlob(@Positive int n, @Nullable InputStream inputStream) {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream)");
    }

    @Override
    public void updateBlob(String string, @Nullable InputStream inputStream) {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateClob(@Positive int n, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Reader, long)");
    }

    @Override
    public void updateClob(String string, @Nullable Reader reader, long l) {
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateClob(@Positive int n, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Reader)");
    }

    @Override
    public void updateClob(String string, @Nullable Reader reader) {
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    @Pure
    public @Nullable SQLXML getSQLXML(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getSQLXML columnIndex: {0}", n);
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new PgSQLXML(this.connection, string);
    }

    @Override
    public @Nullable SQLXML getSQLXML(String string) {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public void updateSQLXML(@Positive int n, @Nullable SQLXML sQLXML) {
        this.updateValue(n, sQLXML);
    }

    @Override
    public void updateSQLXML(String string, @Nullable SQLXML sQLXML) {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public @Nullable String getNString(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getNString columnIndex: {0}", n);
        throw Driver.notImplemented(this.getClass(), "getNString(int)");
    }

    @Override
    public @Nullable String getNString(String string) {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public @Nullable Reader getNCharacterStream(@Positive int n) {
        this.connection.getLogger().log(Level.FINEST, "  getNCharacterStream columnIndex: {0}", n);
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public @Nullable Reader getNCharacterStream(String string) {
        return this.getNCharacterStream(this.findColumn(string));
    }

    public void updateNCharacterStream(@Positive int n, @Nullable Reader reader, int n2) {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, int)");
    }

    public void updateNCharacterStream(String string, @Nullable Reader reader, int n) {
        this.updateNCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateNCharacterStream(@Positive int n, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader)");
    }

    @Override
    public void updateNCharacterStream(String string, @Nullable Reader reader) {
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(@Positive int n, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, long)");
    }

    @Override
    public void updateNCharacterStream(String string, @Nullable Reader reader, long l) {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateCharacterStream(@Positive int n, @Nullable Reader reader, long l) {
        throw Driver.notImplemented(this.getClass(), "updateCharaceterStream(int, Reader, long)");
    }

    @Override
    public void updateCharacterStream(String string, @Nullable Reader reader, long l) {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateCharacterStream(@Positive int n, @Nullable Reader reader) {
        throw Driver.notImplemented(this.getClass(), "updateCharaceterStream(int, Reader)");
    }

    @Override
    public void updateCharacterStream(String string, @Nullable Reader reader) {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateBinaryStream(@Positive int n, @Nullable InputStream inputStream, long l) {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream, long)");
    }

    @Override
    public void updateBinaryStream(String string, @Nullable InputStream inputStream, long l) {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBinaryStream(@Positive int n, @Nullable InputStream inputStream) {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream)");
    }

    @Override
    public void updateBinaryStream(String string, @Nullable InputStream inputStream) {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(@Positive int n, @Nullable InputStream inputStream, long l) {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream, long)");
    }

    @Override
    public void updateAsciiStream(String string, @Nullable InputStream inputStream, long l) {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateAsciiStream(@Positive int n, @Nullable InputStream inputStream) {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream)");
    }

    @Override
    public void updateAsciiStream(String string, @Nullable InputStream inputStream) {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar calendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = calendar.getTimeZone();
        }
        return calendar;
    }

    protected PgResultSet upperCaseFieldLabels() {
        for (Field field : this.fields) {
            field.upperCaseLabel();
        }
        return this;
    }

    static class NullObject
    extends PGobject {
        NullObject(String string) {
            this.type = string;
        }

        @Override
        public @Nullable String getValue() {
            return null;
        }
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int n, String string) {
            this.index = n;
            this.name = string;
        }

        @Nullable Object getValue() {
            return PgResultSet.this.getObject(this.index);
        }
    }

    public class CursorResultHandler
    extends ResultHandlerBase {
        @Override
        public void handleResultRows(Query query, Field[] fieldArray, List<Tuple> list, @Nullable ResultCursor resultCursor) {
            PgResultSet.this.rows = list;
            PgResultSet.this.cursor = resultCursor;
        }

        @Override
        public void handleCommandStatus(String string, long l, long l2) {
            this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", string), PSQLState.PROTOCOL_VIOLATION));
        }

        @Override
        public void handleCompletion() {
            SQLWarning sQLWarning = this.getWarning();
            if (sQLWarning != null) {
                PgResultSet.this.addWarning(sQLWarning);
            }
            super.handleCompletion();
        }
    }
}

