/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.PGResultSetMetaData;
import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.Field;
import com.hm.postgresql.core.ServerVersion;
import com.hm.postgresql.jdbc.FieldMetadata;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.Gettable;
import com.hm.postgresql.util.GettableHashMap;
import com.hm.postgresql.util.JdbcBlackHole;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PgResultSetMetaData
implements ResultSetMetaData,
PGResultSetMetaData {
    protected final BaseConnection connection;
    protected final Field[] fields;
    private boolean fieldInfoFetched;

    public PgResultSetMetaData(BaseConnection baseConnection, Field[] fieldArray) {
        this.connection = baseConnection;
        this.fields = fieldArray;
        this.fieldInfoFetched = false;
    }

    @Override
    public int getColumnCount() {
        return this.fields.length;
    }

    @Override
    public boolean isAutoIncrement(int n) {
        this.fetchFieldMetaData();
        Field field = this.getField(n);
        FieldMetadata fieldMetadata = field.getMetadata();
        return fieldMetadata != null && fieldMetadata.autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int n) {
        Field field = this.getField(n);
        return this.connection.getTypeInfo().isCaseSensitive(field.getOID());
    }

    @Override
    public boolean isSearchable(int n) {
        return true;
    }

    @Override
    public boolean isCurrency(int n) {
        String string = this.getPGType(n);
        return "cash".equals(string) || "money".equals(string);
    }

    @Override
    public int isNullable(int n) {
        this.fetchFieldMetaData();
        Field field = this.getField(n);
        FieldMetadata fieldMetadata = field.getMetadata();
        return fieldMetadata == null ? 1 : fieldMetadata.nullable;
    }

    @Override
    public boolean isSigned(int n) {
        Field field = this.getField(n);
        return this.connection.getTypeInfo().isSigned(field.getOID());
    }

    @Override
    public int getColumnDisplaySize(int n) {
        Field field = this.getField(n);
        return this.connection.getTypeInfo().getDisplaySize(field.getOID(), field.getMod());
    }

    @Override
    public String getColumnLabel(int n) {
        Field field = this.getField(n);
        return field.getColumnLabel();
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnLabel(n);
    }

    @Override
    public String getBaseColumnName(int n) {
        Field field = this.getField(n);
        if (field.getTableOid() == 0) {
            return "";
        }
        this.fetchFieldMetaData();
        FieldMetadata fieldMetadata = field.getMetadata();
        return fieldMetadata == null ? "" : fieldMetadata.columnName;
    }

    @Override
    public String getSchemaName(int n) {
        return "";
    }

    private boolean populateFieldsWithMetadata(Gettable<FieldMetadata.Key, FieldMetadata> gettable) {
        boolean bl = true;
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            FieldMetadata fieldMetadata = gettable.get(new FieldMetadata.Key(field.getTableOid(), field.getPositionInTable()));
            if (fieldMetadata == null) {
                bl = false;
                continue;
            }
            field.setMetadata(fieldMetadata);
        }
        this.fieldInfoFetched |= bl;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFieldMetaData() {
        if (this.fieldInfoFetched) {
            return;
        }
        if (this.populateFieldsWithMetadata(this.connection.getFieldMetadataCache())) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT c.oid, a.attnum, a.attname, c.relname, n.nspname, a.attnotnull OR (t.typtype = 'd' AND t.typnotnull), ");
        if (this.connection.haveMinimumServerVersion(ServerVersion.v10)) {
            stringBuilder.append("a.attidentity != '' OR pg_catalog.pg_get_expr(d.adbin, d.adrelid) LIKE '%nextval(%' ");
        } else {
            stringBuilder.append("pg_catalog.pg_get_expr(d.adbin, d.adrelid) LIKE '%nextval(%' ");
        }
        stringBuilder.append("FROM pg_catalog.pg_class c JOIN pg_catalog.pg_namespace n ON (c.relnamespace = n.oid) JOIN pg_catalog.pg_attribute a ON (c.oid = a.attrelid) JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) LEFT JOIN pg_catalog.pg_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) JOIN (");
        boolean bl = false;
        for (Field field : this.fields) {
            if (field.getMetadata() != null) continue;
            if (bl) {
                stringBuilder.append(" UNION ALL ");
            }
            stringBuilder.append("SELECT ");
            stringBuilder.append(field.getTableOid());
            if (!bl) {
                stringBuilder.append(" AS oid ");
            }
            stringBuilder.append(", ");
            stringBuilder.append(field.getPositionInTable());
            if (!bl) {
                stringBuilder.append(" AS attnum");
            }
            if (bl) continue;
            bl = true;
        }
        stringBuilder.append(") vals ON (c.oid = vals.oid AND a.attnum = vals.attnum) ");
        if (!bl) {
            this.fieldInfoFetched = true;
            return;
        }
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = null;
        GettableHashMap<FieldMetadata.Key, FieldMetadata> gettableHashMap = new GettableHashMap<FieldMetadata.Key, FieldMetadata>();
        try {
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                int n = (int)resultSet.getLong(1);
                int n2 = (int)resultSet.getLong(2);
                String string = Nullness.castNonNull(resultSet.getString(3));
                String string2 = Nullness.castNonNull(resultSet.getString(4));
                String string3 = Nullness.castNonNull(resultSet.getString(5));
                int n3 = resultSet.getBoolean(6) ? 0 : 1;
                boolean bl2 = resultSet.getBoolean(7);
                FieldMetadata fieldMetadata = new FieldMetadata(string, string2, string3, n3, bl2);
                FieldMetadata.Key key = new FieldMetadata.Key(n, n2);
                gettableHashMap.put(key, fieldMetadata);
            }
        }
        catch (Throwable throwable) {
            JdbcBlackHole.close(resultSet);
            JdbcBlackHole.close(statement);
            throw throwable;
        }
        JdbcBlackHole.close(resultSet);
        JdbcBlackHole.close(statement);
        this.populateFieldsWithMetadata(gettableHashMap);
        this.connection.getFieldMetadataCache().putAll(gettableHashMap);
    }

    @Override
    public String getBaseSchemaName(int n) {
        this.fetchFieldMetaData();
        Field field = this.getField(n);
        FieldMetadata fieldMetadata = field.getMetadata();
        return fieldMetadata == null ? "" : fieldMetadata.schemaName;
    }

    @Override
    public int getPrecision(int n) {
        Field field = this.getField(n);
        return this.connection.getTypeInfo().getPrecision(field.getOID(), field.getMod());
    }

    @Override
    public int getScale(int n) {
        Field field = this.getField(n);
        return this.connection.getTypeInfo().getScale(field.getOID(), field.getMod());
    }

    @Override
    public String getTableName(int n) {
        return this.getBaseTableName(n);
    }

    @Override
    public String getBaseTableName(int n) {
        this.fetchFieldMetaData();
        Field field = this.getField(n);
        FieldMetadata fieldMetadata = field.getMetadata();
        return fieldMetadata == null ? "" : fieldMetadata.tableName;
    }

    @Override
    public String getCatalogName(int n) {
        return "";
    }

    @Override
    public int getColumnType(int n) {
        return this.getSQLType(n);
    }

    @Override
    public int getFormat(int n) {
        return this.getField(n).getFormat();
    }

    @Override
    public String getColumnTypeName(int n) {
        String string = this.getPGType(n);
        if (this.isAutoIncrement(n)) {
            if ("int4".equals(string)) {
                return "serial";
            }
            if ("int8".equals(string)) {
                return "bigserial";
            }
            if ("int2".equals(string) && this.connection.haveMinimumServerVersion(ServerVersion.v9_2)) {
                return "smallserial";
            }
        }
        return Nullness.castNonNull(string);
    }

    @Override
    public boolean isReadOnly(int n) {
        return false;
    }

    @Override
    public boolean isWritable(int n) {
        return !this.isReadOnly(n);
    }

    @Override
    public boolean isDefinitelyWritable(int n) {
        return false;
    }

    protected Field getField(int n) {
        if (n < 1 || n > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", n, this.fields.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[n - 1];
    }

    protected @Nullable String getPGType(int n) {
        return this.connection.getTypeInfo().getPGType(this.getField(n).getOID());
    }

    protected int getSQLType(int n) {
        return this.connection.getTypeInfo().getSQLType(this.getField(n).getOID());
    }

    @Override
    public String getColumnClassName(int n) {
        Field field = this.getField(n);
        String string = this.connection.getTypeInfo().getJavaClass(field.getOID());
        if (string != null) {
            return string;
        }
        int n2 = this.getSQLType(n);
        switch (n2) {
            case 2003: {
                return "java.sql.Array";
            }
        }
        String string2 = this.getPGType(n);
        if ("unknown".equals(string2)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }
}

