/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.PGProperty;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.util.Properties;

public enum SslMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full");

    public static final SslMode[] VALUES;
    public final String value;

    private SslMode(String string2) {
        this.value = string2;
    }

    public boolean requireEncryption() {
        return this.compareTo(REQUIRE) >= 0;
    }

    public boolean verifyCertificate() {
        return this == VERIFY_CA || this == VERIFY_FULL;
    }

    public boolean verifyPeerName() {
        return this == VERIFY_FULL;
    }

    public static SslMode of(Properties properties) {
        String string = PGProperty.SSL_MODE.get(properties);
        if (string == null) {
            if (PGProperty.SSL.getBoolean(properties) || "".equals(PGProperty.SSL.get(properties))) {
                return VERIFY_FULL;
            }
            return PREFER;
        }
        for (SslMode sslMode : VALUES) {
            if (!sslMode.value.equalsIgnoreCase(string)) continue;
            return sslMode;
        }
        throw new PSQLException(GT.tr("Invalid sslmode value: {0}", string), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    static {
        VALUES = SslMode.values();
    }
}

