/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jdbc;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.core.BaseStatement;
import com.hm.postgresql.core.ServerVersion;
import com.hm.postgresql.core.TypeInfo;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PGobject;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeInfoCache
implements TypeInfo {
    private static final Logger LOGGER = Logger.getLogger(TypeInfoCache.class.getName());
    private Map<String, Integer> pgNameToSQLType;
    private Map<Integer, Integer> oidToSQLType;
    private Map<String, String> pgNameToJavaClass;
    private Map<Integer, String> oidToPgName;
    private Map<String, Integer> pgNameToOid;
    private Map<String, Class<? extends PGobject>> pgNameToPgObject;
    private Map<Integer, Integer> pgArrayToPgType;
    private Map<Integer, Character> arrayOidToDelimiter;
    private final BaseConnection conn;
    private final int unknownLength;
    private @Nullable PreparedStatement getOidStatementSimple;
    private @Nullable PreparedStatement getOidStatementComplexNonArray;
    private @Nullable PreparedStatement getOidStatementComplexArray;
    private @Nullable PreparedStatement getNameStatement;
    private @Nullable PreparedStatement getArrayElementOidStatement;
    private @Nullable PreparedStatement getArrayDelimiterStatement;
    private @Nullable PreparedStatement getTypeInfoStatement;
    private @Nullable PreparedStatement getAllTypeInfoStatement;
    private static final Object[][] types = new Object[][]{{"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}, {"json", 114, 1111, "com.hm.postgresql.util.PGobject", 199}, {"point", 600, 1111, "com.hm.postgresql.geometric.PGpoint", 1017}};
    private static final ConcurrentMap<String, String> TYPE_ALIASES = new ConcurrentHashMap<String, String>(20);

    public TypeInfoCache(BaseConnection baseConnection, int n) {
        this.conn = baseConnection;
        this.unknownLength = n;
        this.oidToPgName = new HashMap<Integer, String>((int)Math.round((double)types.length * 1.5));
        this.pgNameToOid = new HashMap<String, Integer>((int)Math.round((double)types.length * 1.5));
        this.pgNameToJavaClass = new HashMap<String, String>((int)Math.round((double)types.length * 1.5));
        this.pgNameToPgObject = new HashMap<String, Class<? extends PGobject>>((int)Math.round((double)types.length * 1.5));
        this.pgArrayToPgType = new HashMap<Integer, Integer>((int)Math.round((double)types.length * 1.5));
        this.arrayOidToDelimiter = new HashMap<Integer, Character>((int)Math.round((double)types.length * 2.5));
        this.pgNameToSQLType = Collections.synchronizedMap(new HashMap((int)Math.round((double)types.length * 1.5)));
        this.oidToSQLType = Collections.synchronizedMap(new HashMap((int)Math.round((double)types.length * 1.5)));
        for (Object[] objectArray : types) {
            String string = (String)objectArray[0];
            Integer n2 = (Integer)objectArray[1];
            Integer n3 = (Integer)objectArray[2];
            String string2 = (String)objectArray[3];
            Integer n4 = (Integer)objectArray[4];
            this.addCoreType(string, n2, n3, string2, n4);
        }
        this.pgNameToJavaClass.put("hstore", Map.class.getName());
    }

    @Override
    public synchronized void addCoreType(String string, Integer n, Integer n2, String string2, Integer n3) {
        this.pgNameToJavaClass.put(string, string2);
        this.pgNameToOid.put(string, n);
        this.oidToPgName.put(n, string);
        this.pgArrayToPgType.put(n3, n);
        this.pgNameToSQLType.put(string, n2);
        this.oidToSQLType.put(n, n2);
        Character c = Character.valueOf(',');
        this.arrayOidToDelimiter.put(n, c);
        this.arrayOidToDelimiter.put(n3, c);
        String string3 = string + "[]";
        this.pgNameToJavaClass.put(string3, "java.sql.Array");
        this.pgNameToSQLType.put(string3, 2003);
        this.oidToSQLType.put(n3, 2003);
        this.pgNameToOid.put(string3, n3);
        string3 = "_" + string;
        if (!this.pgNameToJavaClass.containsKey(string3)) {
            this.pgNameToJavaClass.put(string3, "java.sql.Array");
            this.pgNameToSQLType.put(string3, 2003);
            this.pgNameToOid.put(string3, n3);
            this.oidToPgName.put(n3, string3);
        }
    }

    @Override
    public synchronized void addDataType(String string, Class<? extends PGobject> clazz) {
        this.pgNameToPgObject.put(string, clazz);
        this.pgNameToJavaClass.put(string, clazz.getName());
    }

    @Override
    public Iterator<String> getPGTypeNamesWithSQLTypes() {
        return this.pgNameToSQLType.keySet().iterator();
    }

    @Override
    public Iterator<Integer> getPGTypeOidsWithSQLTypes() {
        return this.oidToSQLType.keySet().iterator();
    }

    private String getSQLTypeQuery(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT typinput='array_in'::regproc as is_array, typtype, typname, pg_type.oid ");
        stringBuilder.append("  FROM pg_catalog.pg_type ");
        stringBuilder.append("  LEFT JOIN (select ns.oid as nspoid, ns.nspname, r.r ");
        stringBuilder.append("          from pg_namespace as ns ");
        stringBuilder.append("          join ( select s.r, (current_schemas(false))[s.r] as nspname ");
        stringBuilder.append("                   from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r ");
        stringBuilder.append("         using ( nspname ) ");
        stringBuilder.append("       ) as sp ");
        stringBuilder.append("    ON sp.nspoid = typnamespace ");
        if (bl) {
            stringBuilder.append(" WHERE pg_type.oid = ? ");
        }
        stringBuilder.append(" ORDER BY sp.r, pg_type.oid DESC;");
        return stringBuilder.toString();
    }

    private int getSQLTypeFromQueryResult(ResultSet resultSet) {
        Integer n = null;
        boolean bl = resultSet.getBoolean("is_array");
        String string = resultSet.getString("typtype");
        if (bl) {
            n = 2003;
        } else if ("c".equals(string)) {
            n = 2002;
        } else if ("d".equals(string)) {
            n = 2001;
        } else if ("e".equals(string)) {
            n = 12;
        }
        if (n == null) {
            n = 1111;
        }
        return n;
    }

    private PreparedStatement prepareGetAllTypeInfoStatement() {
        PreparedStatement preparedStatement = this.getAllTypeInfoStatement;
        if (preparedStatement == null) {
            this.getAllTypeInfoStatement = preparedStatement = this.conn.prepareStatement(this.getSQLTypeQuery(false));
        }
        return preparedStatement;
    }

    public void cacheSQLTypes() {
        LOGGER.log(Level.FINEST, "caching all SQL typecodes");
        PreparedStatement preparedStatement = this.prepareGetAllTypeInfoStatement();
        if (!((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet resultSet = Nullness.castNonNull(preparedStatement.getResultSet());
        while (resultSet.next()) {
            Integer n;
            String string = Nullness.castNonNull(resultSet.getString("typname"));
            Integer n2 = this.getSQLTypeFromQueryResult(resultSet);
            if (!this.pgNameToSQLType.containsKey(string)) {
                this.pgNameToSQLType.put(string, n2);
            }
            if (this.oidToSQLType.containsKey(n = Integer.valueOf(this.longOidToInt(Nullness.castNonNull(resultSet.getLong("oid")))))) continue;
            this.oidToSQLType.put(n, n2);
        }
        resultSet.close();
    }

    private PreparedStatement prepareGetTypeInfoStatement() {
        PreparedStatement preparedStatement = this.getTypeInfoStatement;
        if (preparedStatement == null) {
            this.getTypeInfoStatement = preparedStatement = this.conn.prepareStatement(this.getSQLTypeQuery(true));
        }
        return preparedStatement;
    }

    @Override
    public synchronized int getSQLType(String string) {
        if (string.endsWith("[]")) {
            return 2003;
        }
        Integer n = this.pgNameToSQLType.get(string);
        if (n != null) {
            return n;
        }
        n = this.getSQLType(Nullness.castNonNull(this.getPGType(string)));
        this.pgNameToSQLType.put(string, n);
        return n;
    }

    @Override
    public synchronized int getSQLType(int n) {
        if (n == 0) {
            return 1111;
        }
        Integer n2 = this.oidToSQLType.get(n);
        if (n2 != null) {
            return n2;
        }
        LOGGER.log(Level.FINEST, "querying SQL typecode for pg type oid '{0}'", this.intOidToLong(n));
        PreparedStatement preparedStatement = this.prepareGetTypeInfoStatement();
        preparedStatement.setLong(1, this.intOidToLong(n));
        if (!((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet resultSet = Nullness.castNonNull(preparedStatement.getResultSet());
        int n3 = 1111;
        if (resultSet.next()) {
            n3 = this.getSQLTypeFromQueryResult(resultSet);
        }
        resultSet.close();
        this.oidToSQLType.put(n, n3);
        return n3;
    }

    private PreparedStatement getOidStatement(String string) {
        String string2;
        String string3;
        PreparedStatement preparedStatement;
        String string4;
        boolean bl = string.endsWith("[]");
        boolean bl2 = string.contains("\"");
        int n = string.indexOf(46);
        if (n == -1 && !bl2 && !bl) {
            String string5;
            if (this.getOidStatementSimple == null) {
                string5 = "SELECT pg_type.oid, typname   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getOidStatementSimple = this.conn.prepareStatement(string5);
            }
            string5 = string.toLowerCase();
            this.getOidStatementSimple.setString(1, string5);
            return this.getOidStatementSimple;
        }
        if (bl) {
            if (this.getOidStatementComplexArray == null) {
                string4 = this.conn.haveMinimumServerVersion(ServerVersion.v8_3) ? "SELECT t.typarray, arr.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid  JOIN pg_catalog.pg_type arr ON arr.oid = t.typarray WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1" : "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM pg_catalog.pg_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                this.getOidStatementComplexArray = this.conn.prepareStatement(string4);
            }
            preparedStatement = this.getOidStatementComplexArray;
        } else {
            if (this.getOidStatementComplexNonArray == null) {
                string4 = "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this.getOidStatementComplexNonArray = this.conn.prepareStatement(string4);
            }
            preparedStatement = this.getOidStatementComplexNonArray;
        }
        String string6 = string4 = bl ? string.substring(0, string.length() - 2) : string;
        if (n == -1) {
            string3 = null;
            string2 = string4;
        } else if (string4.startsWith("\"")) {
            if (string4.endsWith("\"")) {
                String[] stringArray = string4.split("\"\\.\"");
                string3 = stringArray.length == 2 ? stringArray[0] + "\"" : null;
                string2 = stringArray.length == 2 ? "\"" + stringArray[1] : stringArray[0];
            } else {
                int n2 = string4.lastIndexOf(46);
                string2 = string4.substring(n2 + 1);
                string3 = string4.substring(0, n2);
            }
        } else {
            string3 = string4.substring(0, n);
            string2 = string4.substring(n + 1);
        }
        if (string3 != null && string3.startsWith("\"") && string3.endsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        } else if (string3 != null) {
            string3 = string3.toLowerCase();
        }
        string2 = string2.startsWith("\"") && string2.endsWith("\"") ? string2.substring(1, string2.length() - 1) : string2.toLowerCase();
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string3);
        preparedStatement.setBoolean(3, string3 == null);
        return preparedStatement;
    }

    @Override
    public synchronized int getPGType(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = this.pgNameToOid.get(string);
        if (n != null) {
            return n;
        }
        PreparedStatement preparedStatement = this.getOidStatement(string);
        if (!((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        n = 0;
        ResultSet resultSet = Nullness.castNonNull(preparedStatement.getResultSet());
        if (resultSet.next()) {
            n = (int)resultSet.getLong(1);
            String string2 = Nullness.castNonNull(resultSet.getString(2));
            this.oidToPgName.put(n, string2);
            this.pgNameToOid.put(string2, n);
        }
        this.pgNameToOid.put(string, n);
        resultSet.close();
        return n;
    }

    @Override
    public synchronized @Nullable String getPGType(int n) {
        if (n == 0) {
            return null;
        }
        String string = this.oidToPgName.get(n);
        if (string != null) {
            return string;
        }
        PreparedStatement preparedStatement = this.prepareGetNameStatement();
        preparedStatement.setInt(1, n);
        if (!((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet resultSet = Nullness.castNonNull(preparedStatement.getResultSet());
        if (resultSet.next()) {
            boolean bl = resultSet.getBoolean(1);
            String string2 = Nullness.castNonNull(resultSet.getString(2), "schema");
            String string3 = Nullness.castNonNull(resultSet.getString(3), "name");
            if (bl) {
                string = string3;
                this.pgNameToOid.put(string2 + "." + string3, n);
            } else {
                string = "\"" + string2 + "\".\"" + string3 + "\"";
                if (string2.equals(string2.toLowerCase()) && string2.indexOf(46) == -1 && string3.equals(string3.toLowerCase()) && string3.indexOf(46) == -1) {
                    this.pgNameToOid.put(string2 + "." + string3, n);
                }
            }
            this.pgNameToOid.put(string, n);
            this.oidToPgName.put(n, string);
        }
        resultSet.close();
        return string;
    }

    private PreparedStatement prepareGetNameStatement() {
        PreparedStatement preparedStatement = this.getNameStatement;
        if (preparedStatement == null) {
            String string = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getNameStatement = preparedStatement = this.conn.prepareStatement(string);
        }
        return preparedStatement;
    }

    @Override
    public int getPGArrayType(@Nullable String string) {
        string = this.getTypeForAlias(string);
        return this.getPGType(string + "[]");
    }

    protected synchronized int convertArrayToBaseOid(int n) {
        Integer n2 = this.pgArrayToPgType.get(n);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    @Override
    public synchronized char getArrayDelimiter(int n) {
        if (n == 0) {
            return ',';
        }
        Character c = this.arrayOidToDelimiter.get(n);
        if (c != null) {
            return c.charValue();
        }
        PreparedStatement preparedStatement = this.prepareGetArrayDelimiterStatement();
        preparedStatement.setInt(1, n);
        if (!((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet resultSet = Nullness.castNonNull(preparedStatement.getResultSet());
        if (!resultSet.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        String string = Nullness.castNonNull(resultSet.getString(1));
        c = Character.valueOf(string.charAt(0));
        this.arrayOidToDelimiter.put(n, c);
        resultSet.close();
        return c.charValue();
    }

    private PreparedStatement prepareGetArrayDelimiterStatement() {
        PreparedStatement preparedStatement = this.getArrayDelimiterStatement;
        if (preparedStatement == null) {
            String string = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this.getArrayDelimiterStatement = preparedStatement = this.conn.prepareStatement(string);
        }
        return preparedStatement;
    }

    @Override
    public synchronized int getPGArrayElement(int n) {
        if (n == 0) {
            return 0;
        }
        Integer n2 = this.pgArrayToPgType.get(n);
        if (n2 != null) {
            return n2;
        }
        PreparedStatement preparedStatement = this.prepareGetArrayElementOidStatement();
        preparedStatement.setInt(1, n);
        if (!((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet resultSet = Nullness.castNonNull(preparedStatement.getResultSet());
        if (!resultSet.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        n2 = (int)resultSet.getLong(1);
        boolean bl = resultSet.getBoolean(2);
        String string = resultSet.getString(3);
        String string2 = Nullness.castNonNull(resultSet.getString(4));
        this.pgArrayToPgType.put(n, n2);
        this.pgNameToOid.put(string + "." + string2, n2);
        String string3 = "\"" + string + "\".\"" + string2 + "\"";
        this.pgNameToOid.put(string3, n2);
        if (bl && string2.equals(string2.toLowerCase())) {
            this.oidToPgName.put(n2, string2);
            this.pgNameToOid.put(string2, n2);
        } else {
            this.oidToPgName.put(n2, string3);
        }
        resultSet.close();
        return n2;
    }

    private PreparedStatement prepareGetArrayElementOidStatement() {
        PreparedStatement preparedStatement = this.getArrayElementOidStatement;
        if (preparedStatement == null) {
            String string = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getArrayElementOidStatement = preparedStatement = this.conn.prepareStatement(string);
        }
        return preparedStatement;
    }

    @Override
    public synchronized @Nullable Class<? extends PGobject> getPGobject(String string) {
        return this.pgNameToPgObject.get(string);
    }

    @Override
    public synchronized String getJavaClass(int n) {
        String string = this.getPGType(n);
        if (string == null) {
            return "java.lang.String";
        }
        String string2 = this.pgNameToJavaClass.get(string);
        if (string2 != null) {
            return string2;
        }
        if (this.getSQLType(string) == 2003) {
            string2 = "java.sql.Array";
            this.pgNameToJavaClass.put(string, string2);
        }
        return string2 == null ? "java.lang.String" : string2;
    }

    @Override
    public @Nullable String getTypeForAlias(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)TYPE_ALIASES.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = (String)TYPE_ALIASES.get(string.toLowerCase());
        if (string2 == null) {
            string2 = string;
        }
        TYPE_ALIASES.put(string, string2);
        return string2;
    }

    @Override
    public int getPrecision(int n, int n2) {
        n = this.convertArrayToBaseOid(n);
        switch (n) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (n2 == -1) {
                    return 0;
                }
                return (n2 - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: {
                if (n2 == -1) {
                    return this.unknownLength;
                }
                return n2 - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return this.getDisplaySize(n, n2);
            }
            case 1560: {
                return n2;
            }
            case 1562: {
                if (n2 == -1) {
                    return this.unknownLength;
                }
                return n2;
            }
        }
        return this.unknownLength;
    }

    @Override
    public int getScale(int n, int n2) {
        n = this.convertArrayToBaseOid(n);
        switch (n) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (n2 == -1) {
                    return 0;
                }
                return n2 - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (n2 == -1) {
                    return 6;
                }
                return n2;
            }
            case 1186: {
                if (n2 == -1) {
                    return 6;
                }
                return n2 & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public boolean isCaseSensitive(int n) {
        n = this.convertArrayToBaseOid(n);
        switch (n) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int n) {
        n = this.convertArrayToBaseOid(n);
        switch (n) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDisplaySize(int n, int n2) {
        n = this.convertArrayToBaseOid(n);
        switch (n) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 15;
            }
            case 701: {
                return 25;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int n3;
                switch (n2) {
                    case -1: {
                        n3 = 7;
                        break;
                    }
                    case 0: {
                        n3 = 0;
                        break;
                    }
                    case 1: {
                        n3 = 3;
                        break;
                    }
                    default: {
                        n3 = n2 + 1;
                    }
                }
                switch (n) {
                    case 1083: {
                        return 8 + n3;
                    }
                    case 1266: {
                        return 8 + n3 + 6;
                    }
                    case 1114: {
                        return 22 + n3;
                    }
                    case 1184: {
                        return 22 + n3 + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: {
                if (n2 == -1) {
                    return this.unknownLength;
                }
                return n2 - 4;
            }
            case 1700: {
                if (n2 == -1) {
                    return 131089;
                }
                int n4 = n2 - 4 >> 16 & 0xFFFF;
                int n5 = n2 - 4 & 0xFFFF;
                return 1 + n4 + (n5 != 0 ? 1 : 0);
            }
            case 1560: {
                return n2;
            }
            case 1562: {
                if (n2 == -1) {
                    return this.unknownLength;
                }
                return n2;
            }
            case 17: 
            case 25: {
                return this.unknownLength;
            }
        }
        return this.unknownLength;
    }

    @Override
    public int getMaximumPrecision(int n) {
        n = this.convertArrayToBaseOid(n);
        switch (n) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: {
                return 6;
            }
            case 1042: 
            case 1043: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int n) {
        int n2 = this.getSQLType(n);
        return this.requiresQuotingSqlType(n2);
    }

    @Override
    public boolean requiresQuotingSqlType(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int longOidToInt(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new PSQLException(GT.tr("Value is not an OID: {0}", l), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (int)l;
    }

    @Override
    public long intOidToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    static {
        TYPE_ALIASES.put("bool", "bool");
        TYPE_ALIASES.put("boolean", "bool");
        TYPE_ALIASES.put("smallint", "int2");
        TYPE_ALIASES.put("int2", "int2");
        TYPE_ALIASES.put("int", "int4");
        TYPE_ALIASES.put("integer", "int4");
        TYPE_ALIASES.put("int4", "int4");
        TYPE_ALIASES.put("long", "int8");
        TYPE_ALIASES.put("int8", "int8");
        TYPE_ALIASES.put("bigint", "int8");
        TYPE_ALIASES.put("float", "float4");
        TYPE_ALIASES.put("float4", "float4");
        TYPE_ALIASES.put("double", "float8");
        TYPE_ALIASES.put("float8", "float8");
        TYPE_ALIASES.put("decimal", "numeric");
        TYPE_ALIASES.put("numeric", "numeric");
    }
}

