/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.jre7.sasl;

import com.hm.postgresql.core.PGStream;
import com.hm.postgresql.shaded.com.ongres.scram.client.ScramClient;
import com.hm.postgresql.shaded.com.ongres.scram.client.ScramSession;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramException;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.hm.postgresql.shaded.com.ongres.scram.common.exception.ScramServerErrorException;
import com.hm.postgresql.shaded.com.ongres.scram.common.stringprep.StringPreparations;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import com.hm.postgresql.util.internal.Nullness;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ScramAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ScramAuthenticator.class.getName());
    private final String user;
    private final String password;
    private final PGStream pgStream;
    private @Nullable ScramClient scramClient;
    private @Nullable ScramSession scramSession;
    private @Nullable ScramSession.ClientFinalProcessor clientFinalProcessor;

    private void sendAuthenticationMessage(int n, BodySender bodySender) {
        this.pgStream.sendChar(112);
        this.pgStream.sendInteger4(4 + n);
        bodySender.sendBody(this.pgStream);
        this.pgStream.flush();
    }

    public ScramAuthenticator(String string, String string2, PGStream pGStream) {
        this.user = string;
        this.password = string2;
        this.pgStream = pGStream;
    }

    public void processServerMechanismsAndInit() {
        ScramClient scramClient;
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            arrayList.add(this.pgStream.receiveString());
        } while (this.pgStream.peekChar() != 0);
        int n = this.pgStream.receiveChar();
        assert (n == 0);
        if (arrayList.size() < 1) {
            throw new PSQLException(GT.tr("No SCRAM mechanism(s) advertised by the server", new Object[0]), PSQLState.CONNECTION_REJECTED);
        }
        try {
            scramClient = ScramClient.channelBinding(ScramClient.ChannelBinding.NO).stringPreparation(StringPreparations.SASL_PREPARATION).selectMechanismBasedOnServerAdvertised(arrayList.toArray(new String[0])).setup();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PSQLException(GT.tr("Invalid or unsupported by client SCRAM mechanisms", illegalArgumentException), PSQLState.CONNECTION_REJECTED);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " Using SCRAM mechanism {0}", scramClient.getScramMechanism().getName());
        }
        this.scramClient = scramClient;
        this.scramSession = scramClient.scramSession("*");
    }

    public void sendScramClientFirstMessage() {
        ScramSession scramSession = this.scramSession;
        String string = Nullness.castNonNull(scramSession).clientFirstMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLInitialResponse( {0} )", string);
        ScramClient scramClient = this.scramClient;
        String string2 = Nullness.castNonNull(scramClient).getScramMechanism().getName();
        final byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        final byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(byArray.length + 1 + 4 + byArray2.length, new BodySender(){

            @Override
            public void sendBody(PGStream pGStream) {
                pGStream.send(byArray);
                pGStream.sendChar(0);
                pGStream.sendInteger4(byArray2.length);
                pGStream.send(byArray2);
            }
        });
    }

    public void processServerFirstMessage(int n) {
        ScramSession.ServerFirstProcessor serverFirstProcessor;
        String string = this.pgStream.receiveString(n);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue( {0} )", string);
        ScramSession scramSession = this.scramSession;
        if (scramSession == null) {
            throw new PSQLException(GT.tr("SCRAM session does not exist", new Object[0]), PSQLState.UNKNOWN_STATE);
        }
        try {
            serverFirstProcessor = scramSession.receiveServerFirstMessage(string);
        }
        catch (ScramException scramException) {
            throw new PSQLException(GT.tr("Invalid server-first-message: {0}", string), PSQLState.CONNECTION_REJECTED, (Throwable)scramException);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue(salt={0}, iterations={1})", new Object[]{serverFirstProcessor.getSalt(), serverFirstProcessor.getIteration()});
        }
        this.clientFinalProcessor = serverFirstProcessor.clientFinalProcessor(this.password);
        String string2 = this.clientFinalProcessor.clientFinalMessage();
        LOGGER.log(Level.FINEST, " FE=> SASLResponse( {0} )", string2);
        final byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(byArray.length, new BodySender(){

            @Override
            public void sendBody(PGStream pGStream) {
                pGStream.send(byArray);
            }
        });
    }

    public void verifyServerSignature(int n) {
        String string = this.pgStream.receiveString(n);
        LOGGER.log(Level.FINEST, " <=BE AuthenticationSASLFinal( {0} )", string);
        ScramSession.ClientFinalProcessor clientFinalProcessor = this.clientFinalProcessor;
        if (clientFinalProcessor == null) {
            throw new PSQLException(GT.tr("SCRAM client final processor does not exist", new Object[0]), PSQLState.UNKNOWN_STATE);
        }
        try {
            clientFinalProcessor.receiveServerFinalMessage(string);
        }
        catch (ScramParseException scramParseException) {
            throw new PSQLException(GT.tr("Invalid server-final-message: {0}", string), PSQLState.CONNECTION_REJECTED, (Throwable)scramParseException);
        }
        catch (ScramServerErrorException scramServerErrorException) {
            throw new PSQLException(GT.tr("SCRAM authentication failed, server returned error: {0}", scramServerErrorException.getError().getErrorMessage()), PSQLState.CONNECTION_REJECTED, (Throwable)scramServerErrorException);
        }
        catch (ScramInvalidServerSignatureException scramInvalidServerSignatureException) {
            throw new PSQLException(GT.tr("Invalid server SCRAM signature", new Object[0]), PSQLState.CONNECTION_REJECTED, (Throwable)scramInvalidServerSignatureException);
        }
    }

    private static interface BodySender {
        public void sendBody(PGStream var1) throws IOException;
    }
}

