/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.largeobject;

import com.hm.postgresql.largeobject.LargeObject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlobInputStream
extends InputStream {
    private @Nullable LargeObject lo;
    private long apos;
    private byte @Nullable [] buffer;
    private int bpos;
    private int bsize;
    private long mpos = 0L;
    private long limit = -1L;

    public BlobInputStream(LargeObject largeObject) {
        this(largeObject, 1024);
    }

    public BlobInputStream(LargeObject largeObject, int n) {
        this(largeObject, n, -1L);
    }

    public BlobInputStream(LargeObject largeObject, int n, long l) {
        this.lo = largeObject;
        this.buffer = null;
        this.bpos = 0;
        this.apos = 0L;
        this.bsize = n;
        this.limit = l;
    }

    @Override
    public int read() {
        LargeObject largeObject = this.getLo();
        try {
            if (this.limit > 0L && this.apos >= this.limit) {
                return -1;
            }
            if (this.buffer == null || this.bpos >= this.buffer.length) {
                this.buffer = largeObject.read(this.bsize);
                this.bpos = 0;
            }
            if (this.buffer == null || this.bpos >= this.buffer.length) {
                return -1;
            }
            int n = this.buffer[this.bpos] & 0x7F;
            if ((this.buffer[this.bpos] & 0x80) == 128) {
                n |= 0x80;
            }
            ++this.bpos;
            ++this.apos;
            return n;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    @Override
    public void close() {
        if (this.lo != null) {
            try {
                this.lo.close();
                this.lo = null;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.toString());
            }
        }
    }

    @Override
    public synchronized void mark(int n) {
        this.mpos = this.apos;
    }

    @Override
    public synchronized void reset() {
        LargeObject largeObject = this.getLo();
        try {
            if (this.mpos <= Integer.MAX_VALUE) {
                largeObject.seek((int)this.mpos);
            } else {
                largeObject.seek64(this.mpos, 0);
            }
            this.buffer = null;
            this.apos = this.mpos;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    private LargeObject getLo() {
        if (this.lo == null) {
            throw new IOException("BlobOutputStream is closed");
        }
        return this.lo;
    }
}

