/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.largeobject;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.fastpath.Fastpath;
import com.hm.postgresql.fastpath.FastpathArg;
import com.hm.postgresql.largeobject.LargeObject;
import com.hm.postgresql.util.GT;
import com.hm.postgresql.util.PSQLException;
import com.hm.postgresql.util.PSQLState;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;

public class LargeObjectManager {
    private Fastpath fp;
    private BaseConnection conn;
    public static final int WRITE = 131072;
    public static final int READ = 262144;
    public static final int READWRITE = 393216;

    public LargeObjectManager(BaseConnection baseConnection) {
        this.conn = baseConnection;
        this.fp = baseConnection.getFastpathAPI();
        String string = baseConnection.getMetaData().supportsSchemasInTableDefinitions() ? "SELECT p.proname,p.oid  FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n  WHERE p.pronamespace=n.oid AND n.nspname='pg_catalog' AND (" : "SELECT proname,oid FROM pg_proc WHERE ";
        string = string + " proname = 'lo_open' or proname = 'lo_close' or proname = 'lo_creat' or proname = 'lo_unlink' or proname = 'lo_lseek' or proname = 'lo_lseek64' or proname = 'lo_tell' or proname = 'lo_tell64' or proname = 'loread' or proname = 'lowrite' or proname = 'lo_truncate' or proname = 'lo_truncate64'";
        if (baseConnection.getMetaData().supportsSchemasInTableDefinitions()) {
            string = string + ")";
        }
        Statement statement = baseConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        this.fp.addFunctions(resultSet);
        resultSet.close();
        statement.close();
        baseConnection.getLogger().log(Level.FINE, "Large Object initialised");
    }

    @Deprecated
    public LargeObject open(int n) {
        return this.open((long)n, false);
    }

    public LargeObject open(int n, boolean bl) {
        return this.open((long)n, bl);
    }

    public LargeObject open(long l) {
        return this.open(l, 393216, false);
    }

    public LargeObject open(long l, boolean bl) {
        return this.open(l, 393216, bl);
    }

    @Deprecated
    public LargeObject open(int n, int n2) {
        return this.open((long)n, n2, false);
    }

    public LargeObject open(int n, int n2, boolean bl) {
        return this.open((long)n, n2, bl);
    }

    public LargeObject open(long l, int n) {
        return this.open(l, n, false);
    }

    public LargeObject open(long l, int n, boolean bl) {
        if (this.conn.getAutoCommit()) {
            throw new PSQLException(GT.tr("Large Objects may not be used in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return new LargeObject(this.fp, l, n, this.conn, bl);
    }

    @Deprecated
    public int create() {
        return this.create(393216);
    }

    public long createLO() {
        return this.createLO(393216);
    }

    public long createLO(int n) {
        if (this.conn.getAutoCommit()) {
            throw new PSQLException(GT.tr("Large Objects may not be used in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        FastpathArg[] fastpathArgArray = new FastpathArg[]{new FastpathArg(n)};
        return this.fp.getOID("lo_creat", fastpathArgArray);
    }

    @Deprecated
    public int create(int n) {
        long l = this.createLO(n);
        return (int)l;
    }

    public void delete(long l) {
        FastpathArg[] fastpathArgArray = new FastpathArg[]{Fastpath.createOIDArg(l)};
        this.fp.fastpath("lo_unlink", fastpathArgArray);
    }

    @Deprecated
    public void unlink(int n) {
        this.delete((long)n);
    }

    public void unlink(long l) {
        this.delete(l);
    }

    @Deprecated
    public void delete(int n) {
        this.delete((long)n);
    }
}

