/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.replication;

import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LogSequenceNumber
implements Comparable<LogSequenceNumber> {
    public static final LogSequenceNumber INVALID_LSN = LogSequenceNumber.valueOf(0L);
    private final long value;

    private LogSequenceNumber(long l) {
        this.value = l;
    }

    public static LogSequenceNumber valueOf(long l) {
        return new LogSequenceNumber(l);
    }

    public static LogSequenceNumber valueOf(String string) {
        int n = string.lastIndexOf(47);
        if (n <= 0) {
            return INVALID_LSN;
        }
        String string2 = string.substring(0, n);
        int n2 = (int)Long.parseLong(string2, 16);
        String string3 = string.substring(n + 1, string.length());
        int n3 = (int)Long.parseLong(string3, 16);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n3);
        byteBuffer.position(0);
        long l = byteBuffer.getLong();
        return LogSequenceNumber.valueOf(l);
    }

    public long asLong() {
        return this.value;
    }

    public String asString() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(this.value);
        byteBuffer.position(0);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        return String.format("%X/%X", n, n2);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LogSequenceNumber logSequenceNumber = (LogSequenceNumber)object;
        return this.value == logSequenceNumber.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return "LSN{" + this.asString() + '}';
    }

    @Override
    public int compareTo(LogSequenceNumber logSequenceNumber) {
        if (this.value == logSequenceNumber.value) {
            return 0;
        }
        return this.value + Long.MIN_VALUE < logSequenceNumber.value + Long.MIN_VALUE ? -1 : 1;
    }
}

