/*
 * Decompiled with CFR 0.152.
 */
package com.hm.postgresql.replication;

import com.hm.postgresql.core.BaseConnection;
import com.hm.postgresql.replication.PGReplicationConnection;
import com.hm.postgresql.replication.fluent.ChainedCreateReplicationSlotBuilder;
import com.hm.postgresql.replication.fluent.ChainedStreamBuilder;
import com.hm.postgresql.replication.fluent.ReplicationCreateSlotBuilder;
import com.hm.postgresql.replication.fluent.ReplicationStreamBuilder;
import java.sql.Statement;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection baseConnection) {
        this.connection = baseConnection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + string);
        }
    }
}

